function [J,th]=segmentation(Y,Km,modele);

%*****************************************************************************
% This function realizes the segmentation according to the model
% G is the matrix containing the likelihood for every possible segment (cost matrix)
% J is the contrast (related to the likelihood) for K=1...Km
% th contains the breakpoint coordinates for K=1...Km
% lmin is the minimum length of a segment (lmin>1 if model=1)
%*****************************************************************************

global lmin S;

n=length(Y);

if modele==1					%heteroscedastique
   G=Gmean_std(Y,lmin);
   [J,th]=dynprog(G,Km);
   J=J/n;
   
elseif modele==2				%homoscedastique
   G=Gmean(Y,lmin);
   [J,th]=dynprog(G,Km);
   J=log(J/n);
end;

