function [Kh]=selection(Y,J,Km,modele,critere);

%*****************************************************************************
% This function selects the number of segments
%
% critere==1 Marc Lavielle Criterion
% critere==2 Emilie Lebarbier Criterion
% critere==3 Akaike Information Criterion
% critere==4 Bayes Information Criterion
% critere==5 beta (user specific penalty constant)
%
% Likelihood = -n/2*(J+1+log(2*pi));
%*****************************************************************************


global lmin S KhS KmS JS Kmchoix;

n=length(Y);

if critere==1 
   Jtild=(J(Km)-J)/(J(Km)-J(1))*(Km-1)+1;
   D=zeros(Km,3);
   D(1,2)=inf;
   D(:,1)=(1:Km)';
   for i=2:Km-1
      D(i,2)=(Jtild(i-1)-2*Jtild(i)+Jtild(i+1))/2;
   end;
   D(:,3)=S;
   Kh=max(find(diff(diff(Jtild))>S))+1;
   if isempty(Kh)==1 Kh=1; end;
end;

if critere==2
   c1=2.6; c2=2;
   K=(1:Km);
   pen=K.*(c1*log(n./K)+c2);
   pen=pen';
   if modele==1
      [km_1,kv,pv]=penteexplo(J,pen);
      Kh=km_1;
   elseif modele==2
      [km_2,kv,pv]=penteexplo(J,pen);
      Kh=km_2;
   end
end

if critere==3
   if modele==1
      K=2*(1:Km)';
      [a,Kh]=max ( -n*(J+1+log(2*pi)) - 2*K );
   elseif modele==2
      K=(1:Km)';
      [a,Kh]=max ( -n*(J+1+log(2*pi)) - 2*K);
   end;
end;

if critere==4
   if modele==1
      K=2*(1:Km)';
      [a,Kh]=max ( -n*(J+1+log(2*pi)) - log(n)*K );
   elseif modele==2
      K=(1:Km)';
      [a,Kh]=max ( -n*(J+1+log(2*pi)) - log(n)*K);
   end;
end;

if critere==5
   if modele==1
      K=2*(1:Km)';
      [a,Kh]=max ( -n*(J+1+log(2*pi)) - beta*K );
   elseif modele==2
      K=(1:Km)';
      [a,Kh]=max ( -n*(J+1+log(2*pi)) - beta*K);
   end;
end;

KhS=[KhS Kh];
KmS=[KmS Km];
Jchoix=[J;Inf*ones(Kmchoix-length(J),1)];
JS=[JS Jchoix];