source("poissonfun.R")
library(haarfisz)
library(wavethresh)
library(grplasso)
library(glmnet)
J         = 10
n         = 2^J
ff        = "blocks"
## ff: blocks, doppler, heavisine, bumps
f0        = getf0(n,J,alpha=10,ff)$f0
dict      = "H"
## H = Haar, F = Fourier, D = Daubechies (with combinations DF, DH, FH, DFH)
Y         = sapply(f0,FUN=function(y){rpois(1,y)})


out.lasso = getlasso(Y,dict,gamma=1)
grpsize   = 4   # group size of the grp-lasso (power of 2)
gamma.grp = getgammagrp(Y,dict, grpsize,gamma1=0)
out.grp   = getgrplasso(Y,dict,grpsize,gamma.grp,gamma1=0,theta=0)

plot(Y,type="l",col="gray",ylim=range(c(Y,out.lasso$fh,out.grp$fh)))
lines(f0,type="l",col=2,lwd=3)
lines(out.lasso$fh,col="blue",lwd=3)
lines(out.grp$fh,col="purple",lwd=3)


# choice of the dictionary by CV
dictlist = c("D","H","DH")
n        = length(Y)
res = sapply(dictlist,FUN=function(dict){
    cv = sapply(c("odd","even"),FUN=function(sub){
        v     = seq(1,n,2)+(sub=="even")
        w     = seq(2,n,2)-(sub=="even")
        out   = getlasso(Y[v],dict,gamma=1)
        fh    = out$fh
        gh = rep(0,length(fh))
        for (j in c(1:(n/2))){
            gh[j] = 0.5*(fh[j]+fh[j+1])
        }
        gh[n/2] = fh[n/2]
        ui        = log(gh/Y[w])
        sum(Y[w]*(exp(ui)-ui-1),na.rm=T)/n
    })
    sum(cv)
})
dict = dictlist[which.min(res)]






