gethft <- function(Y,dict){
    if (dict=="H"){
        filter.number = 1        
    } else {
        filter.number = 8
    }    
    ywd   = wd(hft(Y),filter.number,family="DaubExPhase")
    tywd  = threshold(ywd,type="soft",policy="universal")
    ywr   = wr(tywd)  
    betah = tywd$D
    fh    = hft.inv(ywr)    
    return(list(fh=fh,betah=betah))
}

getf0 <- function(n,J,alpha,fname){
    if (fname=="blocks"){
        g0        = DJ.EX(n)$blocks
        g0        = (g0-mean(g0))/sd(g0)
        Amat      = getAmat("H",n)
        betas     = c(t(Amat)%*%g0)
        pp        = abs(betas)<1e-8
        betas[pp] = 0
        f0        = exp(g0)*alpha
    } else if (fname == "doppler"){
        g0        = DJ.EX(n)$doppler
        g0        = (g0-mean(g0))/sd(g0)
        Amat      = getAmat("D",n)
        betas     = t(Amat)%*%g0
        pp        = abs(betas)<exp(-4)
        betas[pp] = 0
        f0        = exp(g0)*alpha
    } else if (fname == "heavi"){
        g0        = DJ.EX(n)$heavi
        g0        = (g0-mean(g0))/sd(g0)
        Amat      = getAmat("D",n)
        betas     = t(Amat)%*%g0
        pp        = abs(betas)<1e-8
        betas[pp] = 0
        f0        = exp(g0)*alpha
    } else if (fname == "bumps"){
        g0        = DJ.EX(n)$bumps
        g0        = (g0-mean(g0))/sd(g0)
        g0        = g0/5
        Amat      = getAmat("D",n)
        betas     = t(Amat)%*%g0
        pp        = abs(betas)<1e-8
        betas[pp] = 0
        f0        = (exp(g0))*alpha        
    } 
    return(list(f0=f0, betas = betas))
}




getAmat <- function(dict,n){
    # si on veut avoir des -1/1 dans la matrice de Haar
    J    = log2(n)
    coef = 1/2^((0:J)/2)
    coef = coef[-1]
    ff   = sapply(1+rep(0:(J-1),2^((J-1):0)),FUN=function(jj){coef[jj]})
    ## si on veut que tAA = nI
    coef2 = 2^((0:J)/2)
    coef2 = coef2[length(coef2):1]
    ff2   = sapply(1+rep(1:J,2^((J-1):0)),FUN=function(jj){coef2[jj]})
    
    if (dict=="DFH"){
        AH = GenW(n,filter.number=1,family="DaubExPhase")[,-1]
        AD = GenW(n,filter.number=6,family="DaubExPhase")[,-1]        
        AH = sweep(AH,2,ff,"/"); AH = sweep(AH,2,ff2,"*"); 
        AD = sweep(AD,2,ff,"/"); AD = sweep(AD,2,ff2,"*")
        Amat = cbind(AD,
            t(FourierMatrix(n,n))[,-c(1,n+1)],
            AH
            )
    } else if (dict=="H"){
        AH   = GenW(n,filter.number=1,family="DaubExPhase")[,-1]
        AH   =  sweep(AH,2,ff,"/")
        AH = sweep(AH,2,ff2,"*")
        Amat = AH
    } else if (dict=="D"){
        AD   =  GenW(n,filter.number=6,family="DaubExPhase")[,-1]
        AD   =  sweep(AD,2,ff,"/")
        AD = sweep(AD,2,ff2,"*")
        Amat = AD
    } else if (dict=="F"){
        Amat = cbind(
            t(FourierMatrix(n,n))[,-c(1,n+1)]
            )
    } else if (dict=="FH"){
        AH = GenW(n,filter.number=1,family="DaubExPhase")[,-1]
        AH = sweep(AH,2,ff,"/")
        AH = sweep(AH,2,ff2,"*");
        Amat = cbind(
            t(FourierMatrix(n,n))[,-c(1,n+1)],
            AH
            )
    } else if (dict=="DH"){
        AH = GenW(n,filter.number=1,family="DaubExPhase")[,-1]
        AD = GenW(n,filter.number=6,family="DaubExPhase")[,-1]       
        AH = sweep(AH,2,ff,"/"); AH = sweep(AH,2,ff2,"*"); 
        AD = sweep(AD,2,ff,"/"); AD = sweep(AD,2,ff2,"*")
        Amat = cbind(AD,AH)
    } else if (dict=="DF"){
         AD = GenW(n,filter.number=6,family="DaubExPhase")[,-1]
         AD = sweep(AD,2,ff,"/"); AD = sweep(AD,2,ff2,"*")
         Amat = cbind(AD,t(FourierMatrix(n,n))[,-c(1,n+1)])         
    }
    
}


getlasso <- function(Y,dict,gamma=1){
   
    n        = length(Y)
    Amat     = getAmat(dict,n)
    p        = dim(Amat)[2]        
    Vjhat    = apply( sweep(Amat*Amat, 1, Y, FUN = "*"), 2, sum)    
    phijmax  = apply(abs(Amat), 2, max)
    if (gamma==0){
        Vjtilde = Vjhat
        gamma   = 1
        lambdaj  = c(1,sqrt( 2*gamma*log(p)*Vjtilde ) + gamma* log(p) *phijmax / 3)
    } else {
        Vjtilde  = Vjhat + sqrt(2*gamma*log( p )*Vjhat*phijmax^2) + 3*gamma*log( p )* phijmax^2
        lambdaj  = c(1,sqrt( 2*gamma*log(p)*Vjtilde ) + gamma* log(p) *phijmax / 3)
    }
    
    X        = sweep(cbind(rep(1,n),Amat),2,lambdaj,"/")
    index    = c(NA,seq(1:p))
    betah    = grplasso(X, Y, index=index,  lambda=1, model = PoissReg(),standardize=F)$coefficients/lambdaj
    betah[1] = log(mean(Y))
    posnonnull = which(betah!=0)

    if (length(posnonnull)>=3){
        betah.reest             = rep(0,length(betah))
        betah.reest[posnonnull] = grplasso(X[,posnonnull], Y, index=index[posnonnull],  
        							lambda=0, model = PoissReg(),standardize=F)$coefficients/lambdaj[posnonnull]
        betah                   = betah.reest
    }
    
    Amat = cbind(rep(1,n),Amat)
    fh   = as.vector(exp(Amat%*%betah))
    ll   = loglik(Y,Amat,betah)
        
    return(list(fh = as.vector(exp(Amat%*%betah)),betah=as.vector(betah),ll=ll))
}

getgroups <- function(dict,n,grpsize){

    if (dict=="H" | dict=="D"){
        p            = n
        J            = log2(p)
        groups       = c(paste(dict,1+rep((J-1):0,2^((J-1):0)),sep="."))        
        Gk           = table(groups)
        Gk           = Gk[order(nchar(names(Gk)), names(Gk),decreasing=T)]
        ii = c()
        for (i in 1:length(Gk)){
            rr = Gk[i]/grpsize
            if (rr>1){
                nn  = rep(paste(names(Gk)[i],rr:1,sep="."),each=grpsize)
            } else {
                nn  = rep(paste(names(Gk)[i],Gk[i],sep="."),each=Gk[i])
                }
            ii = c(ii,nn)
        }
        groups      = ii
    }
    if (dict=="F"){
        p      = 2*n
        nbgrp  = p/grpsize
        groups = paste(dict,rep(c(1:nbgrp),each=grpsize),sep=".")[-n]     
    }
    return(groups)
}
    
    
is.wholenumber <- function(x, tol = .Machine$double.eps^0.5){abs(x - round(x)) < tol}
loglik <- function(Y,X,beta){return(sum(Y* (X%*%beta)) - sum(exp((X%*%beta))))}

grouppen <- function(beta,groups,lambda){
    beta = beta*lambda
    pen = sapply(groups,FUN=function(gr){
        sqrt(sum(beta[groups==gr]^2))
    })
    pen = sum(pen)
    return(pen)
}


getc2k <- function(Amat,groups,method="global"){
    tAA = t(Amat)%*%Amat    
    if (method=="global"){
        c2k = 0
        for (gr in groups){
            grpl = sum(groups==gr)
            tAAk = as.matrix(tAA[groups==gr,groups==gr],ncol=grpl)
            c2k  = max(c2k,max(abs(apply(tAAk,1,sum))))
        }
        c2k = rep(c2k,length(groups))
    } else if (method=="global.by.group"){
        c2k = c()
        for (gr in groups){
            grpl = sum(groups==gr)
            tAAk = as.matrix(tAA[groups==gr,groups==gr],nrow=grpl)
            c2k  = c(c2k,max(abs(apply(tAAk,2,sum))))
        }        
    } else if (method=="spectral"){
        c2k = c()
        for (gr in groups){
            grpl    = sum(groups==gr)            
            Ak  = as.matrix(Amat[,groups==gr],ncol=grpl)
            c2k = c(c2k,max(svd(t(Ak)%*%Ak)$d))
        }
    } else if (method=="raw" | method=="noDk"){
        c2k = rep(0,length(groups))
    }
    return(c2k)
}

getgammagrp <- function(Y,dict, grpsize, gamma1=1,theta=0){

    if (!is.wholenumber(log2(grpsize))){
        stop("Group size must be a power of 2")
    }
    gamma.grp   = 0
    n        = length(Y)
    M        = quantile(Y,0.95)
    Amat     = getAmat(dict,n)
    p        = dim(Amat)[2]        
    phijmax  = apply(abs(Amat), 2, max)
    Vjhat    = apply( sweep(Amat*Amat, 1, Y, FUN = "*"), 2, sum)
    groups   = unlist(lapply( unlist(strsplit(dict,"")),FUN=function(d){getgroups(d,n,grpsize)}))
   
    lambdak.group = c(1) ## for the intercept
    jj            = 1
    gg            = groups[1]
    c2k           = getc2k(Amat,groups,method="global")
    i             = 0
    term1 = term2 = term3 = c()
    for (gr in groups){
        i = i + 1
        if (gr!=gg){jj=jj+1; gg = gr}
        grpl    = sum(groups==gr)
        Vjtilde = Vjhat + sqrt(2* ( gamma1*log(p) + log(grpl)  ) * Vjhat *phijmax^2) + 3*( gamma1*log(p) + log(grpl) ) * phijmax^2
        Vktilde = sum(Vjtilde[groups==gr])
        if (theta == 0){Dk.theta = 8*M*c2k[i]} else {Dk.theta = 8*M*c2k[i]}# + 2*b2k/theta^2}        
        lk      = (1+theta) * sqrt(Vktilde)+2* sqrt(gamma.grp*log(p)*Dk.theta)  
        lambdak.group = c(lambdak.group,lk*sqrt(grpl))
        term1   = c(term1,(1+theta) * sqrt(Vktilde))
        term2   = c(term2,2* sqrt(log(p) *Dk.theta))
    }   
    
    return(median( (term1/term2)^2 ))
} 

getgrplasso <- function(Y,dict,grpsize,gamma.grp,gamma1=1,theta=0){

    if (!is.wholenumber(log2(grpsize))){
        stop("Group size must be a power of 2")
    }
    
    n        = length(Y)
    M        = quantile(Y,0.95)
    Amat     = getAmat(dict,n)
    p        = dim(Amat)[2]        
    phijmax  = apply(abs(Amat), 2, max)
    Vjhat    = apply( sweep(Amat*Amat, 1, Y, FUN = "*"), 2, sum)
    groups   = unlist(lapply( unlist(strsplit(dict,"")),FUN=function(d){getgroups(d,n,grpsize)}))
   
    lambdak.group = c(1) ## for the intercept
    jj            = 1
    index         = c()
    gg            = groups[1]
    c2k           = getc2k(Amat,groups,method="global")
    i             = 0
    for (gr in groups){
        i = i + 1
        if (gr!=gg){jj=jj+1; gg = gr}
        grpl    = sum(groups==gr)
        Vjtilde = Vjhat + sqrt(2* ( gamma1*log(p) + log(grpl)  ) * Vjhat *phijmax^2) + 3*( gamma1*log(p) + log(grpl) ) * phijmax^2
        Vktilde = sum(Vjtilde[groups==gr])
        if (theta == 0){Dk.theta = 8*M*c2k[i]} else {Dk.theta = 8*M*c2k[i]}
        lk      = (1+theta) * sqrt(Vktilde)+2* sqrt(gamma.grp*log(p)*Dk.theta)  
        lambdak.group = c(lambdak.group,lk*sqrt(grpl))
        index         = c(index,jj)            
    }   
    index      = c(NA, index)
    X          = sweep(cbind(rep(1,n),Amat),2,lambdak.group,"/")
    Amat       = cbind(rep(1,n),Amat)
    
    betah      = grplasso(X, Y, index=index,  lambda=1, model = PoissReg(),standardize=F)$coefficients/lambdak.group   
    posnonnull = which(betah!=0)
    
    if (length(posnonnull)>2){
        betah.reest             = rep(0,length(betah))
        betah.reest[posnonnull] = grplasso(X[,posnonnull], Y, index=index[posnonnull],  
        							lambda=0, model = PoissReg(),standardize=F)$coefficients/lambdak.group[posnonnull]
        betah                   = betah.reest
    }
    
    fh    = as.vector(exp(Amat%*%betah))   
    return(list(fh=fh,betah=betah,ll=loglik(Y,Amat,betah), pen = grouppen(betah,groups,lambdak.group)))
} 

    
getACC<-function(vtrue, vest){
  p   = length(vtrue)
  tp  = sum(vtrue!=0 & vest!=0)
  tn  = sum(vtrue==0 & vest ==0)

  ACC = (tp+tn)/p
  return(ACC)
}
getsens <- function(vtrue,vest){
    tp  = sum(vtrue!=0 & vest!=0)
    fn  = sum(vtrue!=0 & vest==0)
    tp/(fn+tp)
}
getspe <- function(vtrue,vest){
    tn  = sum(vtrue==0 & vest ==0)
    fp  = sum(vtrue==0 & vest!=0)
    tn/(tn+fp)
}


FourierMatrix <- function(Nb,Disc){
	H     = matrix(0,nrow=2*Nb+1,ncol=Disc)
	t     = seq(.5/Disc,1-.5/Disc,by=1/Disc)
	omega = matrix(1:Nb,ncol=1,nrow=Nb)
	H[1,] = 1
	H[2:(1+Nb),]        = sqrt(2)*(cos(2*pi*omega%*%t))
	H[(2+Nb):(1+2*Nb),] = sqrt(2)*(sin(2*pi*omega%*%t))
        return(H)
}


getgrplasso.CV <- function(Y,dict,grpsize,gamma.grp,gamma1=1,theta=0){
  
  if (!is.wholenumber(log2(grpsize))){
    stop("Group size must be a power of 2")
  }
  
  n      = length(Y)
  Amat   = getAmat(dict,n/2)
  p      = dim(Amat)[2]        
  groups = unlist(lapply( unlist(strsplit(dict,"")),FUN=function(d){getgroups(d,n/2,grpsize)}))
  index  = c()
  i      = 0
  gg     = groups[1]
  jj     = 1
  
  for (gr in groups){
    i = i + 1
    if (gr!=gg){jj=jj+1; gg = gr}
    index         = c(index,jj)            
  }   
  index = c(NA, index)
  Amat  = cbind(rep(1,n/2),Amat)
  
  lambdamax = lambdamax(Amat, Y[seq(1,n,2)], index = index, penscale = sqrt,model = PoissReg()) 
  ratio     = 1/1000
  Nlam      = 20
  lambdaseq = exp(seq(log(lambdamax),log(lambdamax*ratio), length.out=Nlam))
  RSS = sapply(lambdaseq, FUN=function(ll){ 
    cv = sapply(c("odd","even"),FUN=function(sub){
      v     = seq(1,n,2)+(sub=="even")
      w     = seq(2,n,2)-(sub=="even")
      betah = grplasso(Amat, Y[v], index=index,  lambda=ll, 
                       model = PoissReg(),standardize=F)$coefficients 
      posnonnull = which(betah!=0)
      if (length(posnonnull)>2){
        betah.reest             = rep(0,length(betah))
        betah.reest[posnonnull] = grplasso(Amat[,posnonnull], Y[v], index=index[posnonnull],  
                                           lambda=0, model = PoissReg(),standardize=F)$coefficients
        betah                   = betah.reest
      }
      fh    = as.vector(exp(Amat%*%betah))  
      gh = rep(0,length(fh))
      for (j in c(1:(n/2))){
        gh[j] = 0.5*(fh[j]+fh[j+1])
      }
      gh[n/2] = fh[n/2]
      sum( (Y[w]-gh)^2 ) 
    })
    sum(cv)
  })
  Amat   = getAmat(dict,n)
  p      = dim(Amat)[2]        
  groups = unlist(lapply( unlist(strsplit(dict,"")),FUN=function(d){getgroups(d,n,grpsize)}))
  index  = c()
  i      = 0
  gg     = groups[1]
  jj     = 1
  
  for (gr in groups){
    i = i + 1
    if (gr!=gg){jj=jj+1; gg = gr}
    index         = c(index,jj)            
  }   
  index = c(NA, index)
  Amat  = cbind(rep(1,n),Amat)
  
  ll.CV      = lambdaseq[which.min(RSS)]*(1-log(2)/log(n))^(-0.5)
  betah      = grplasso(Amat, Y, index=index,  lambda=ll.CV, model = PoissReg(),standardize=F)$coefficients  
  posnonnull = which(betah!=0)
  
  if (length(posnonnull)>2){
    betah.reest             = rep(0,length(betah))
    betah.reest[posnonnull] = grplasso(Amat[,posnonnull], Y, index=index[posnonnull],  
                                       lambda=0, model = PoissReg(),standardize=F)$coefficients
    betah                   = betah.reest
  }
  
  fh    = as.vector(exp(Amat%*%betah))   
  return(list(fh=fh,betah=betah,ll=loglik(Y,Amat,betah), pen = grouppen(betah,groups,lambdak.group)))
}








getlasso.CV <- function(Y,dict){
  
  n        = length(Y)
  Amat     = getAmat(dict,n/2)
  p        = dim(Amat)[2]        
  
  Amat     = cbind(rep(1,n/2),Amat)
  index    = c(NA,seq(1:p))
  
  lambdamax = lambdamax(Amat, Y[seq(1,n,2)], index = index, penscale = sqrt,model = PoissReg()) 
  ratio     = 1/1000
  Nlam      = 20
  lambdaseq = exp(seq(log(lambdamax),log(lambdamax*ratio), length.out=Nlam))
  RSS = mclapply(lambdaseq, FUN=function(ll){ 
    cv = sapply(c("odd","even"),FUN=function(sub){
      v     = seq(1,n,2)+(sub=="even")
      w     = seq(2,n,2)-(sub=="even")

      index    = c(NA,seq(1:p))
      betah    = grplasso(Amat, Y[v], index=index,  lambda=ll, model = PoissReg(),standardize=F)$coefficients
      betah[1] = log(mean(Y[v]))
      posnonnull = which(betah!=0)
      
      posnonnull = which(betah!=0)
      if (length(posnonnull)>2){
        betah.reest             = rep(0,length(betah))
        betah.reest[posnonnull] = grplasso(Amat[,posnonnull], Y[v], index=index[posnonnull],  
                                           lambda=0, model = PoissReg(),standardize=F)$coefficients
        betah                   = betah.reest
      }
      fh    = as.vector(exp(Amat%*%betah))  
      gh = rep(0,length(fh))
      for (j in c(1:(n/2))){
        gh[j] = 0.5*(fh[j]+fh[j+1])
      }
      gh[n/2] = fh[n/2]
      ui        = log(gh/Y[w])
      sum(Y[w]*(exp(ui)-ui-1),na.rm=T)/n
      })
    sum(cv)
  },mc.cores=1)
  
  ll.CV      = lambdaseq[which.min(RSS)]*(1-log(2)/log(n))^(-0.5)
  n        = length(Y)
  Amat     = getAmat(dict,n)
  p        = dim(Amat)[2]        
  
  Amat     = cbind(rep(1,n),Amat)
  index    = c(NA,seq(1:p))
  betah    = grplasso(Amat, Y, index=index,  lambda=ll.CV, model = PoissReg(),standardize=F)$coefficients
  betah[1] = log(mean(Y))
  posnonnull = which(betah!=0)
  
  if (length(posnonnull)>=3){
    betah.reest             = rep(0,length(betah))
    betah.reest[posnonnull] = grplasso(Amat[,posnonnull], Y, index=index[posnonnull],  
                                       lambda=0, model = PoissReg(),standardize=F)$coefficients
    betah                   = betah.reest
  }
  
  fh   = as.vector(exp(Amat%*%betah))
  return(list(fh=fh,betah=betah))
}


getlasso.CVj <- function(Y,dict){
  
  n        = length(Y)
  J        = log2(n/2)
  Amat     = getAmat(dict,n/2)
  p        = dim(Amat)[2]        
  
  ww        = 2^rep((J-1):0,2^((J-1):0))
  Amat     = sweep(Amat,2,ww,"/")
  Amat     = cbind(rep(1,n/2),Amat)
  index    = c(NA,seq(1:p))
  
  lambdamax = lambdamax(Amat, Y[seq(1,n,2)], index = index, penscale = sqrt,model = PoissReg()) 
  ratio     = 1/1000
  Nlam      = 20
  lambdaseq = exp(seq(log(lambdamax),log(lambdamax*ratio), length.out=Nlam))
  RSS = mclapply(lambdaseq, FUN=function(ll){ 
    cv = sapply(c("odd","even"),FUN=function(sub){
      v     = seq(1,n,2)+(sub=="even")
      w     = seq(2,n,2)-(sub=="even")
      
      index    = c(NA,seq(1:p))
      betah    = grplasso(Amat, Y[v], index=index,  lambda=ll, model = PoissReg(),standardize=F)$coefficients/c(1,ww)
      betah[1] = log(mean(Y[v]))
      posnonnull = which(betah!=0)
      
      posnonnull = which(betah!=0)
      if (length(posnonnull)>2){
        betah.reest             = rep(0,length(betah))
        betah.reest[posnonnull] = grplasso(Amat[,posnonnull], Y[v], index=index[posnonnull],  
                                           lambda=0, model = PoissReg(),standardize=F)$coefficients/c(1,ww)[posnonnull]
        betah                   = betah.reest
      }
      fh    = as.vector(exp(Amat%*%betah))  
      gh = rep(0,length(fh))
      for (j in c(1:(n/2))){
        gh[j] = 0.5*(fh[j]+fh[j+1])
      }
      gh[n/2] = fh[n/2]
      ui        = log(gh/Y[w])
      sum(Y[w]*(exp(ui)-ui-1),na.rm=T)/n
    })
    sum(cv)
  },mc.cores=1)
  ll.CV      = lambdaseq[which.min(RSS)]*(1-log(2)/log(n))^(-0.5)
  n        = length(Y)
  Amat     = getAmat(dict,n)
  J        = log2(n)
  p        = dim(Amat)[2]        
  ww        = 2^rep((J-1):0,2^((J-1):0))
  Amat     = sweep(Amat,2,ww,"/")
  Amat     = cbind(rep(1,n),Amat)
  index    = c(NA,seq(1:p))
  betah    = grplasso(Amat, Y, index=index,  lambda=ll.CV, model = PoissReg(),standardize=F)$coefficients/c(1,ww)
  betah[1] = log(mean(Y))
  posnonnull = which(betah!=0)
  
  if (length(posnonnull)>=3){
    betah.reest             = rep(0,length(betah))
    betah.reest[posnonnull] = grplasso(Amat[,posnonnull], Y, index=index[posnonnull],  
                                       lambda=0, model = PoissReg(),standardize=F)$coefficients/c(1,ww)[posnonnull]
    betah                   = betah.reest
  }
  Amat     = getAmat(dict,n)
  Amat     = cbind(rep(1,n),Amat)

  fh   = as.vector(exp(Amat%*%betah))
  return(list(fh=fh,betah=betah))
}

getdict.lasso.CV <- function(Y){
    n = length(Y)
    mclapply(c("D","F","H","DF","DH","FH","DFH"),FUN=function(dict){
        cv = sapply(c("odd","even"),FUN=function(sub){
            v     = seq(1,n,2)+(sub=="even")
            w     = seq(2,n,2)-(sub=="even")
            out   = getlasso(Y[v],dict,gamma=1)
            fh    = out$fh
            gh = rep(0,length(fh))
            for (j in c(1:(n/2))){
                gh[j] = 0.5*(fh[j]+fh[j+1])
            }
            gh[n/2] = fh[n/2]
            sum( (Y[w]-gh)^2 )
            ui        = log(gh/Y[w])
            sum(Y[w]*(exp(ui)-ui-1),na.rm=T)/n
        })
        sum(cv)
    },mc.cores=2)
}

