rm(list=ls())
dir = "/home/picard/Dropbox/Poisson/"
source(paste(dir,"code/poissonfun.R",sep=""))
library(wavethresh)
library(grplasso)
library(glmnet)
library(haarfisz)
library(ggplot2)
library(gridExtra)
library(parallel)

J  = 10
ff = "truebeta0"
nbsimul  = 20
alphaseq = 1:7
n        = 2^J
dict = "H"
out = lapply(alphaseq,FUN=function(alpha){
  out = mclapply(1:nbsimul, FUN = function(i){
    cat(ff," ",alpha,"\n")
    res       = c()
    res.f     = c()
    out0      = getf0(n,J,alpha,ff)
    
    betas     = out0$betas
    f0        = out0$f0
    Y         = sapply(f0,FUN=function(y){rpois(1,y)})
    
    out.lasso = getlasso(Y,dict,gamma=1)
    ui        = log(out.lasso$fh/f0)
    kl        = sum(f0*(exp(ui)-ui-1))/n
    df        = sum(out.lasso$betah!=0)
    res       = rbind(res,c(dict,"lasso.exact",alpha,getACC(betas,out.lasso$betah[-1]),getspe(betas,out.lasso$betah[-1]),getsens(betas,out.lasso$betah[-1]),sum( (out.lasso$fh-f0)^2 )/sum(f0^2),sum( (out.lasso$fh-Y)^2 )/n,kl,df))
    res.f     = rbind(res.f,c(dict,"lasso.exact",alpha,out.lasso$fh))
    
    
    gamma.grp = getgammagrp(Y,dict, grpsize=2,gamma1=0)
    out.grp   = getgrplasso(Y,dict,grpsize=2,gamma.grp,gamma1=0,theta=0)
    ui        = log(out.grp$fh/f0)
    kl        = sum(f0*(exp(ui)-ui-1))/n
    df        = sum(out.grp$betah!=0)                
    res       = rbind(res,c(dict,"grplasso.2",alpha,getACC(betas,out.grp$betah[-1]),getspe(betas,out.grp$betah[-1]),getsens(betas,out.grp$betah[-1]),sum( (out.grp$fh-f0)^2 )/sum(f0^2),sum( (out.grp$fh-Y)^2 )/n,kl,df))
    res.f     = rbind(res.f,c(dict,"grplasso.2",alpha,out.grp$fh))
    
    
    gamma.grp = getgammagrp(Y,dict, grpsize=4,gamma1=0)
    out.grp   = getgrplasso(Y,dict,grpsize=4,gamma.grp,gamma1=0,theta=0)
    ui        = log(out.grp$fh/f0)
    kl        = sum(f0*(exp(ui)-ui-1))/n
    df        = sum(out.grp$betah!=0)                                
    res       = rbind(res,c(dict,"grplasso.4",alpha,getACC(betas,out.grp$betah[-1]),getspe(betas,out.grp$betah[-1]),getsens(betas,out.grp$betah[-1]),sum( (out.grp$fh-f0)^2 )/sum(f0^2),sum( (out.grp$fh-Y)^2 )/n,kl,df))
    res.f     = rbind(res.f,c(dict,"grplasso.4",alpha,out.grp$fh))
    
    
    gamma.grp = getgammagrp(Y,dict, grpsize=8,gamma1=0)
    out.grp   = getgrplasso(Y,dict,grpsize=8,gamma.grp,gamma1=0,theta=0)
    ui        = log(out.grp$fh/f0)
    kl        = sum(f0*(exp(ui)-ui-1))/n
    df        = sum(out.grp$betah!=0)                
    res       = rbind(res,c(dict,"grplasso.8",alpha,getACC(betas,out.grp$betah[-1]),getspe(betas,out.grp$betah[-1]),getsens(betas,out.grp$betah[-1]),sum( (out.grp$fh-f0)^2 )/sum(f0^2),sum( (out.grp$fh-Y)^2 )/n,kl,df))
    res.f     = rbind(res.f,c(dict,"grplasso.8",alpha,out.grp$fh))
    
    out.hft   = gethft(Y,dict)
    ui        = log(out.hft$fh/f0)
    kl        = sum(f0*(exp(ui)-ui-1))/n
    df        = sum(out.hft$betah!=0)                                    
    res       = rbind(res,c(dict,"HaarFisz",alpha,getACC(betas,out.hft$betah),getspe(betas,out.hft$betah),getsens(betas,out.hft$betah),sum( (out.hft$fh-f0)^2 )/sum(f0^2),sum( (out.hft$fh-Y)^2 )/n,kl,df))
    res.f     = rbind(res.f,c(dict,"HaarFisz",alpha,out.hft$fh))
    
    out.cv    = getlasso.CV(Y,dict)
    ui        = log(out.cv$fh/f0)
    kl        = sum(f0*(exp(ui)-ui-1))/n
    df        = sum(out.cv$betah!=0)                
    res       = rbind(res,c(dict,"lasso.cv",alpha,getACC(betas,out.cv$betah[-1]),getspe(betas,out.cv$betah[-1]),getsens(betas,out.cv$betah[-1]),sum( (out.cv$fh-f0)^2 )/sum(f0^2),sum( (out.cv$fh-Y)^2 )/n,kl,df))
    res.f     = rbind(res.f,c(dict,"lasso.cv",alpha,out.cv$fh))
    
    out.cvj    = getlasso.CVj(Y,dict)
    ui        = log(out.cvj$fh/f0)
    kl        = sum(f0*(exp(ui)-ui-1))/n
    df        = sum(out.cvj$betah!=0)                
    res       = rbind(res,c(dict,"lasso.cvj",alpha,getACC(betas,out.cvj$betah[-1]),getspe(betas,out.cvj$betah[-1]),getsens(betas,out.cvj$betah[-1]),sum( (out.cvj$fh-f0)^2 )/sum(f0^2),sum( (out.cvj$fh-Y)^2 )/n,kl,df))
    res.f     = rbind(res.f,c(dict,"lasso.cvj",alpha,out.cvj$fh))
    
    return(list(res=res,res.f=res.f))            
  },mc.cores=8)
  res   = Reduce("rbind",lapply(out,FUN=function(x){x$res}))
  res.f = Reduce("rbind",lapply(out,FUN=function(x){x$res.f}))
  return(list(res=res,res.f=res.f))            
})
res             = Reduce("rbind",lapply(out,FUN=function(x){x$res}))
res.f           = Reduce("rbind",lapply(out,FUN=function(x){x$res.f}))
res             = as.data.frame(res)
res.f           = as.data.frame(res.f)
res[,-1]        = apply(res[,-1],2,FUN=function(x){x=as.numeric(as.character(x))})
res.f[,-1]      = apply(res.f[,-1],2,FUN=function(x){x=as.numeric(as.character(x))})
colnames(res)   = c("dict","method","alpha","acc","spe","sens","MSE","resid","KL","df")
colnames(res.f) = c("dict","method","alpha",paste("f",c(1:n),sep="."))
save(res,file=paste(dir,"/results/res-",ff,"-selection-J-",J,".RData",sep=""))
save(res.f,file=paste(dir,"results/res-",ff,"-resconstruction-J-",J,".RData",sep=""))



