`EMAlgo` <-
function(mdata,param,stop.crit)
{
  if (length(param) == 5)
    final <- list(logLike(mdata,one.comp(mdata,param)),matrix(1,nrow=length(mdata),ncol=1))
  else { 
        
      res.paramk <- list()
      tauk <- list()  
      old.eps <- 0
           
      for (k in 1:10000)
   {
           tauk[[k]] <- eStep(mdata,param)
           res <- m1Step(mdata,tauk[[k]],param)
          
          if (sum(is.na(res)) != 0)
                    {
              param <- NA
              final <- list(NA,NA)
              cat("Convergence problem (type1) \n")
              break
            }
          res.paramk[[k]] <- m2Step(res)
          res.param <- res.paramk[[k]]
          
          if (k<3){
          if ((max(abs(res.param-param)/param)>stop.crit) != 0){
           param <- res.param
          } else{
              taux <- tauk[[k]]
              param <- res.param
              final <- list(logLike(mdata,param),taux)
              cat("EM algorithm converged after ", k," iterations \n")
              break
          }
          }
          
          if (k>=3){
   
          a <- k-1  
             
          eps <- res.paramk[[a]]+1/(1/(res.paramk[[a-1]]-res.paramk[[a]])+1/(res.paramk[[a+1]]-res.paramk[[a]]))  
             
         if (is.na((max(abs(eps - old.eps)) <= stop.crit))) {
              param <- NA
              final <- list(NA,NA)
              ## type 2 : is.na((sum((eps-old.eps)^2)<=stop.crit))
              cat("Convergence problem (type2) \n")
              break
         }
         
         if (max(abs(eps - old.eps)) <= stop.crit) {
          taux <- eStep(mdata,eps)
          param <- eps
          final <- list(logLike(mdata,param),taux)
              cat("EM algorithm converged after ", a," iterations \n")
              break
         
          }
          old.eps <- eps
          param <- res.param
         }
 
        }
    
     if (k == 10000)
        {
          param <- NA
          final <- list(NA,NA)
          cat("Convergence problem (type3)\n")
          cat("Last parameters : ",matrix(res.param,ncol=5,byrow=TRUE),"\n")
        }
  }
  final
}

