`hybridization` <-
function(x, leftT=c(TRUE,FALSE,TRUE,FALSE), rightT=c(TRUE,TRUE,FALSE,FALSE), stop.crit=1e-6,Kmax=5) 
  {
    
    if (length(rightT)!=length(leftT)) 
    {
          cat("Problem with arguments, please verify rightT and leftT \n")
          break
        }
    
    mdata =x[,2]
    
    i.compteur1 <- numeric(Kmax*length(rightT))*0 
    

    resCollec <- list()
        for (j in 1:length(rightT))
          {
           l <- min(mdata)*(leftT[j]==TRUE)+(-100)*(leftT[j]==FALSE)
           u <- max(mdata)*(rightT[j]==TRUE)+(100)*(rightT[j]==FALSE)
           cat("----------------------------------------------- \n")
           cat(" Truncatures :" , l, "and", u," \n")
            
           for (comp in 1:Kmax) 
              {
                param <- numeric()
                param[seq(4,by=5,length=comp)] <- l
                param[seq(5,by=5,length=comp)] <- u
                param[seq(3,by=5,length=comp)] <- 1/comp
                param[seq(2,by=5,length=comp)] <- sort(runif(comp,0.1,1))
                param[seq(1,by=5,length=comp)] <- seq(min(mdata),max(mdata),by=(max(mdata)-min(mdata))/(comp+1))[2:(2+comp-1)]+runif(comp,0,.5)#rajout na.rm=TRUE
                 modele <- (j-1)*5+comp
                resCollec[[modele]] <- EMAlgo(mdata,param,stop.crit)
                if (!is.na(resCollec[[modele]][[1]][1]))
                  {
                    cat("Number of components :",comp,"\n")
                    i.compteur1[modele] <- modele
                    cat("estimated parameters : \n")
                    resSelect <- matrix(resCollec[[modele]][[1]]$estimation,ncol=5,byrow=TRUE)[,1:3]
                    print(resSelect)
                    cat("log-likelihood :",resCollec[[modele]][[1]]$logLike,"\t BIC : ",resCollec[[modele]][[1]]$bic,"\n")
                    cat("\n")
                  }
              }
             
          }
          

        i.compteur1 <- sort(unique(i.compteur1))[-1]
        bic <- numeric()
        nb.comp <- numeric()
        for(i in i.compteur1){
        bic <- c(bic,extract(resCollec,i)$bic)
        nb.comp <- c(nb.comp,extract(resCollec,i)$nb.comp)
        }
        best <- i.compteur1[which.max(bic)]
        fic <- resCollec[[best]]
        j = ceiling(best/Kmax)
        l <- min(mdata)*(leftT[j]==TRUE)+(-100)*(leftT[j]==FALSE)
        u <- max(mdata)*(rightT[j]==TRUE)+(100)*(rightT[j]==FALSE)
        
        out <- list(GeneID=x[,1],InputData=x[,2],ModelInfo=fic[[1]],Prob=fic[[2]],Trunc=c(l,u),Bic=bic,NbComp=nb.comp)
        class(out) <- "MixThres"
        print(out)
        invisible(out)
        }

