`m2Step` <-
function(param)
{
  for (g in 1:(length(param)/5))
    {
      param.g <- param[seq(from=(5*(g-1))+1,by=1,length=5)]
      l <- param.g[4]
      u <- param.g[5]
      moy <- param.g[1]
      sdev <- param.g[2]
      variance <- sdev^2
      var.init <- pmin(pmax(variance,1e-6),1000)
      moy.init <- moy
      for (i in 1:1000)
        {
          rapport <- (dnorm(l,moy,sdev)-dnorm(u,mean=moy,sd=sdev))/(pnorm(u,mean=moy,sd=sdev)-pnorm(l,mean=moy,sd=sdev))
          m.iter <- moy+var.init*rapport
          a1.num <- (l-m.iter)*dnorm(l,moy,sdev)-(u-m.iter)*dnorm(u,moy,sdev)
          a1.deno <- pnorm(u,moy,sdev)-pnorm(l,moy,sdev)
          a1 <- a1.num/a1.deno
          s2.iter <- variance/(1+a1+var.init*(rapport)^2)
          if ((abs(m.iter-moy)/moy>1e-6) && (abs(s2.iter-var.init)/var.init>1e-6) )
                      {
              moy.init <- m.iter
              var.init <- s2.iter
            }
          else
            {
              param.g[1] <- m.iter
              param.g[2] <- sqrt(s2.iter)
              param[seq(from=(5*(g-1))+1,by=1,length=5)] <- param.g
              break
            }
       }
    }
  param
}

