`threshold` <-
function(MixThres,crit=1e-04,fileGRAPH=NULL,fileOUT=NULL,sep="\t",...) 
  { 
    resSelect <- matrix(MixThres$ModelInfo$estimation,ncol=5,byrow=TRUE)
    MixThres$Crit <- crit
    mdata <- MixThres$InputData
  
    classes <- seq(min(mdata),max(mdata),length=50)
    nb.comp <- nrow(resSelect) 
    seuil.int <- numeric(nb.comp) 
    value <- matrix(0,ncol=length(classes),nrow=nb.comp) 
    resSelect <- resSelect[order(resSelect[,1]),]
    
    if (!is.null(fileGRAPH)){
    pdf(paste(fileGRAPH,".pdf",sep=""))
    hist(MixThres)
    dev.off()
    } ## end if(display) 
    
    taux <- eStep(classes,c(t(resSelect)))
    kstar <- apply(taux,1,which.max)
    donnee <- classes[kstar != max(kstar)]
    tau.reduit <- taux[kstar != max(kstar),]
    kstar <- apply(tau.reduit,1,which.max)
    if (max(kstar) == 1)
      {
        seuil.possible <- max(donnee)
      }
    else
      {
        i <- length(donnee)
        while (sum((tau.reduit[i,(1:(kstar[i]-1))]<=crit)) == (kstar[i]-1))
          {
            i <- i-1
          }
        seuil.possible <- donnee[i]
      }
    MixThres$Threshold <- seuil.possible
    MixThres$Hybrid <- 0*numeric(length(MixThres$InputData))
     if (MixThres$Threshold!=0)
    MixThres$Hybrid <- 1*(MixThres$InputData>=MixThres$Threshold)
    
    if (!is.null(fileOUT)){
    Proba <- MixThres$Prob
    colnames(Proba) <- paste("tau",1:ncol(Proba),sep="")
    fic <- data.frame(GeneID=MixThres$GeneID,Signal=MixThres$InputData,Proba,Index.Hybrid=MixThres$Hybrid)
    
    write.table(fic,paste(fileOUT,".txt",sep=""),row.names=FALSE,sep=sep,...)
    } 
    
    MixThres
    
    
  }

