\name{EMAlgo}
\alias{EMAlgo}
\title{ EM algorithm }
\description{
  EM algorithm to estimate the parameters of the mixture model.
}
\usage{
EMAlgo(mdata, param, stop.crit)
}
\arguments{
  \item{mdata       }{ A vector of numeric. }
  \item{param       }{ A vector of parameters. }
  \item{stop.crit   }{ The stopping relative precision limit for stopping EM algorithm. }
}
\details{
  The traditionnal EM algorithm of Depster et al. is modified in order to correct the mean and variance biaises du to the truncatures
  by including a fixed-point algorithm in the M-step.
  Then the vector epsilon algorithm is used to accelerate the convergence of the EM algorithm.
}
\value{
  A list of result of the \link{logLike} function and a matrix of the posterior probabilities of belonging to each component of the mixture for each probe.
}
\references{ 
Picard et al., Using mixture models to define a hybridization threshold in DNA microarray experiments.

Kuroda M., Sakakihara M., (2006), Accelerating the convergence of the EM algorithm using the vector epsilon algorithm, Computational Statistics & Data Analysis 51.}
\author{ J. Aubert }

\seealso{ \code{\link{hybridization}}
}
\keyword{ programming }
\keyword{ internal }
