\name{MixThres-package}
\alias{MixThres-package}
\alias{MixThres}
\docType{package}
\title{
Mixture models to define a hybridization Threshold
}
\description{
A hybridization threshold is defined based on the histogramm of the probe intensity values.
The procedure is divided in two steps. First the intensity distribution is estimated using a particular mixture model.
Second a hybridization threshold is defined from the components of the mixture.
}
\details{
\tabular{ll}{
Package: \tab MixThres\cr
Type: \tab Package\cr
Version: \tab 1.0\cr
Date: \tab 2008-09-23\cr
License: \tab gpl-2 \cr
}
}
\author{
J. Aubert <julie.aubert@agroparistech.fr>
}
\references{
Picard et al., Using mixture models to define a hybridization threshold in DNA microarray experiments.
}
\keyword{ package }
\seealso{
\code{\link[<pkg>:<pkg>-MixThres]{hybridization}},\code{\link[<pkg>:<pkg>-MixThres]{threshold}}
}
\examples{
## Data simulation
Signal <- c(rnorm(100,5,1),rnorm(700,8,1),rnorm(200,12,1))
Data <- data.frame(Gene=paste("Gene",1:1000,sep=""),Signal=Signal)

## Mixture models
out <- hybridization(Data)

## Threshold corresponding to the selected mixture model and a particular precision criterion
out <- threshold(out,crit= 1e-04)


## Printing and graphics
print(out) 
hist(out)
plot(out)
}
