\name{gfct}
\alias{gfct}
\title{ Density function for a truncated gaussian distribution }
\description{
  Density function for a truncated gaussian distribution with mean equal to \emph{moy} and standard deviation equal to \emph{sdev} and truncature parameters equal to \emph{l} and \emph{u}. 
}
\usage{
gfct(x, moy, sdev, l, u)
}
\arguments{
  \item{x       }{ vector of quantiles. }
  \item{moy     }{ vector of means. }
  \item{sdev    }{ vector of standard deviations. }
  \item{l       }{ the left (lower) truncature parameter. }
  \item{u       }{ the right (upper) truncature parameter. }
}
\details{

The gfct function is defined as :
\code{  gfct <-
function(x,moy,sdev,l,u)
  (dnorm(x,mean=moy,sd=sdev)*(x<=u)*(x>=l))/(pnorm(u,mean=moy,sd=sdev)-pnorm(l,mean=moy,sd=sdev))
}
}
\value{
  The density.
}
\author{ J. Aubert }

\seealso{ \code{\link{loggfct}}}
\keyword{ internal }
