\name{hybridization}
\alias{hybridization}
\title{Hybridization  : estimation and selection of the mixture model }
\description{
  This function estimates the probe intensity values distribution using a particular mixture model
  in order to define in a second step a hybridization threshold.
}
\usage{
hybridization(x, leftT = c(TRUE, FALSE, TRUE, FALSE), rightT = c(TRUE, TRUE, FALSE, FALSE), stop.crit = 1e-06, Kmax = 5)
}
\arguments{
  \item{x      	  	}{ A dataframe containing a vector of probenames and a vector of probe intensity values.}
  \item{leftT       	}{ A vector of boolean specifying the presence of a left truncature. }
  \item{rightT      	}{ A vector of boolean specifying the presence of a right truncature of the same length than leftT.}
  \item{stop.crit   	}{ The stopping relative precision limit for stopping EM algorithm. }
  \item{Kmax        	}{ The maximal number of components in the mixture model. }
}
\details{
  Truncated gaussian distributions are used. An EM algorithm with a supplement M-step corresponding to a fixed-point algorithm
  (in order to correct bias) is used to estimate the parameters of the mixture.
  A vector epsilon algorithm is used to accelerate the EM algorithm.
  The model is selected according to the BIC.
}
\value{
  An object of class MixThres,
  \item{GeneID      	}{The vector of probenames.}
  \item{InputData   	}{The vector of input intensity values.}
  \item{ModelInfo   	}{A list concerning the selected model : nb of components, parameters estimation, loglikelihood, nb of parameters, aic, bic}
  \item{Prob        	}{The matrix of posterior probabilities.}
  \item{Trunc       	}{A vector of the two truncatures values.}
  \item{Bic         	}{A vector of the BIC calculated for all the models.}
  \item{NbParam     	}{A vector of the number of parameters for all the models.}
  \item{Crit        	}{NULL. Will be filled with the use of the \link{threshold} function.}
  \item{Threshold   	}{NULL. Will be filled with the use of the \link{threshold} function.}
  \item{Hybrid      	}{NULL. Will be filled with the use of the \link{threshold} function.}

}
\references{ Picard et al., Using mixture models to define a hybridization threshold in DNA microarray experiments. }
\author{ J. Aubert }
\seealso{ \code{\link{threshold}}, \code{\link{print.MixThres}}, \code{\link{plot.MixThres}}, \code{\link{hist.MixThres}}}
\examples{
## Data simulation
Signal <- c(rnorm(100,5,1),rnorm(700,8,1),rnorm(200,12,1))
fileIN <- data.frame(Gene=paste("Gene",1:1000,sep=""),Signal=Signal)

## Mixture models
out <- hybridization(fileIN)
}
\keyword{ programming }
