\name{threshold}
\alias{threshold}
\title{ Threshold Hybridization }
\description{
  Define a threshold hybridization in DNA microarray experiments.
}
\usage{
threshold(MixThres, crit = 1e-04, fileGRAPH = NULL, fileOUT = NULL, sep = "\t", ...)
}
\arguments{
  \item{MixThres    }{ an object of class MixThres. }
  \item{crit        }{ precision used to define the hybridization threshold }
  \item{fileGRAPH   }{ the name of the file where graphic is created. If fileGRAPH=NULL no graphic is made. }
  \item{fileOUT     }{ the name of the file where output are created. If fileOUT=NULL no output file is created. }
  \item{sep         }{ the field separator string used for writing the output file. Values within each row of x are separated by this string. }
  \item{\dots       }{ others arguments to write.table }
}
\details{
  The threshold above which a probe is declared as being hybridized is defined as following : \cr
  \eqn{
   T(crit) = max(y_g |{k^*_g}<\widehat{K} \exists s \epsilon (1,...,k^*_{g-1}), \widehat{\tau}_{sg} \geq crit)
   } \cr
  In other words, intensity values are ranked by descending order, for each probe \emph{g} $k^*_g$ is determined using the Maximum A Posteriori
  rule. Then if $k^*_g$ differs from the component with the highest mean $\widehat{K}$, the posterior probability of belonging to
  each component with lower mean than $\mu_{k^*_g}$ is calculated. The threshold is then defined as the first intensity value such
  that one of the calculated posterior probabilities is greater than \emph{crit}.
}
\value{
  an object of class MixThres. Three components are added :
  \item{threshold   }{the hybridization threshold.}
  \item{crit        }{the precision value associated to the hybridization threshold.}
  \item{Hybrid      }{the hybridization index precising wether the spot is hybridized (1) or not (0).}
}
\references{ Picard et al., Using mixture models to define a hybridization threshold in DNA microarray experiments.}
\author{ J. Aubert }

\seealso{ \code{\link{hybridization}} }

\keyword{ programming }

