### Name: MixThres-package
### Title: Mixture models to define a hybridization Threshold
### Aliases: MixThres-package MixThres
### Keywords: package

### ** Examples

## Data simulation
Signal <- c(rnorm(100,5,1),rnorm(700,8,1),rnorm(200,12,1))
Data <- data.frame(Gene=paste("Gene",1:1000,sep=""),Signal=Signal)

## Mixture models
out <- hybridization(Data)

## Threshold corresponding to the selected mixture model and a particular precision criterion
out <- threshold(out,crit= 1e-04)

## Printing and graphics
print(out) 
hist(out)
plot(out)



