library(wavethresh)
library(curvclust)
library(mclust)


## creation of a simulated dataset with 2 groups
mu1           = c(rep(0,20),rep(1,20),rep(0,150),rep(-0.5,10),rep(1,60),rep(0.5,50),rep(0,200),rep(-1,80),rep(0,190),rep(-0.5,84),rep(0,80),rep(0.5,30),rep(0,50))
mu2           = c(rep(0,20),rep(0.5,40),rep(0,130),rep(-0.5,10),rep(1,45),rep(0.5,65),rep(0,180),rep(-0.5,121),rep(0,86),rep(-0.5,170),rep(0,50),rep(1,57),rep(0,50))
mu0           = cbind(mu1,mu2)
n             = 50
prop          = c(0.6,0.4)
eta           = 2
filter.number = 1
SNR           = 5
lambda        = 1
nbclust       = 2
simdata       = simcurv(mu0,prop,SNR,lambda,n,eta,filter.number)
label0        = apply(simdata$CCR@Tau,1,which.max)


## running the package
CCO            = new("CClustO")
CCO@burn       = 100
CCO@init       = "SEM"
CCO@nbclust    = nbclust
CCO@loglikplot = FALSE

# retrieve functional data
Yfun =getwr.Y(simdata$CCD)
Ufun =getwr.Blup(simdata$CCR,CCO,simdata$CCD)
plot(Yfun[[1]],type="l",col="grey")
lines(mu0[,label0[1]],type="l",col="red")
lines(Ufun[[label0[1]]][1,],type="l",col="blue")


model  = "FCMM"
dimred = "union"

if (model=="FCMM"){
   CCO@Gamma2.structure = "constant"
} else if (model =="FCM"){
  CCO@Gamma2.structure = "none"
}

if (dimred=="union"){
  CCD = getUnionCoef(simdata$CCD)
} else {
  CCD = simdata$CCD
}

summary(CCD)

ptm =  proc.time()

if ( ((model=="FCMM" & (nbclust>1)))){
  CCR = getFCMM(CCD,CCO)
} else if ( ((model=="FCMM" & (nbclust==1)))){
  CCR = getFMM(CCD,CCO)
} else if ((model =="FCM") & (nbclust>1)){
  CCR = getFCM(CCD,CCO)
} else if ((model =="FCM") & (nbclust==1)){
  CCR = getCM(CCD,CCO)
} 

summary(CCR)

elapsed = proc.time()-ptm

CCR0   = simdata$CCR
labelh = apply(CCR@Tau,1,which.max)

EER = classError(labelh,label0)$errorRate
muh = getwr.mu(CCR,CCO,CCD)

# plot estimated and simulated functional fixed effects
# dimension reduction is not performed to minimise reconstruction errors
# these plots illustrate that the estimated functional fixed effects do 
# not correspond to the simulated functions
par(mfrow=c(2,1))
plot(muh[[1]],type="l",ylab="muhat")
lines(muh[[2]],type="l",col="red")
plot(mu0[,1],type="l",ylab="mu0")
lines(mu0[,2],col="red",type="l")
 





