rm(list=ls())
library(curvclust)

load("petricoin-spectro-groupalign.RData")

filter.num = 2
M      = dim(data)[1]
J      = log(M)/log(2)
n      = dim(data)[2]
CCD    = new("CClustData",lapply(1:n,FUN=function(k){data[,k]}),filter.number=2)
CCD    = getUnionCoef(CCD)
EER    = c()

for (g in c("constant","group","scale.location","group.scale.location")){
  CCO                  = new("CClustO")
  CCO["Gamma2.structure"] = g
  for (ell in c(2)){
    file.in = paste("results-petricoin-filter-2-model-FCMM-dimred-union-nbclust-2-Gamma2-",CCO@Gamma2.structure,".RData",sep="")
    load(paste(file.in,sep=""))
    label0 = c(rep("control",91),rep("cancer",162))
    EER[g] = sum(diag(table(label0,apply(CCR@Tau,1,which.max))))/n
  }
}

EER[EER>0.5]=1-EER[EER>0.5]


