/*
	CompilerSpecificationWin32.m
	Copyright 2006-2008 Damien Bobillot.
	Modified for a C/C++ cross-compiler by Manolo Gouy
	Distributed under the GPL v3 licence.
*/

#import "CompilerSpecificationWin32.h"
#import "XCPBuildSystem.h"
#import "XCPDependencyGraph.h"
#import "XCPSupport.h"
#import "INWin32Tools.h"
#include <stdlib.h>

@implementation CompilerSpecificationWin32
+ (void) initialize
{
	PBXFileType* type = (PBXFileType*)[PBXFileType specificationForIdentifier:@"sourcecode.cpp.cpp"];
	XCCompilerSpecification* spec = (XCCompilerSpecification*)[XCCompilerSpecification specificationForIdentifier:@"fr.inria.win32.compiler"];
	[PBXTargetBuildContext activateImportedFileType:type withCompiler:spec];
//make sure compiler messages are not translated by doing: putenv("LC_MESSAGES=C")
	putenv("LC_MESSAGES=C");
}

- (NSArray*) computeDependenciesForInputFile:(NSString*)input ofType:(PBXFileType*)type
    variant:(NSString*)variant architecture:(NSString*)arch
    outputDirectory:(NSString*)outputDir
    inTargetBuildContext:(PBXTargetBuildContext*)context
{
	[INWin32Tools setupWin32PathsWithSpecification:self context:context];
	// compute input path (for variable substitution)
    input = [context expandedValueForString:input];
    
    // compute output path
    NSString* output = [outputDir stringByAppendingPathComponent:[[[input lastPathComponent] stringByDeletingPathExtension] stringByAppendingPathExtension:@"w32o"]];
    output = [context expandedValueForString:output];
    
    // create dependency nodes
    XCDependencyNode* outputNode = [context dependencyNodeForName:output createIfNeeded:YES];
    XCDependencyNode* inputNode = [context dependencyNodeForName:input createIfNeeded:YES];
    
    // create compiler command
    XCDependencyCommand* dep = [context
        createCommandWithRuleInfo:[NSArray arrayWithObjects:@"Win32C/C++Compile",[context naturalPathForPath:input],nil]
        commandPath:[context expandedValueForString:[self Win32ExecutablePathInTargetBuildContext:context]]
        arguments:nil
        forNode:outputNode];
    [dep setToolSpecification:self];
    [dep addArgumentsFromArray:[self commandLineForAutogeneratedOptionsInTargetBuildContext:context]];
    [dep addArgumentsFromArray:[[context expandedValueForString:@"$(build_file_compiler_flags)"] arrayByParsingAsStringList]];
	[dep addArgument:@"-c"];
    [dep addArgument:@"-o"];
    [dep addArgument:output];
    [dep addArgument:input];
    
    // create dependency rules
    [outputNode addDependedNode:inputNode];

    // update source-compiled links
    [context setCompiledFilePath:output forSourceFilePath:input];
    	
	// add file to object files (used by linker)
#if XCODE_VERSION < 23
		NSString* object_files_variant_arch = [context expandedValueForString:@"object_files_$(variant)_$(arch)"];
#else
		NSString* object_files_variant_arch = [context expandedValueForString:@"object_files"];
#endif
		[context appendStringOrStringListValue:output toDynamicSetting:object_files_variant_arch];
		
    // return output object node (Xcode will automaticaly add .o files to $(object_files))
    return [NSArray arrayWithObject:outputNode];
}

- (NSArray*)importedFilesForPath:(NSString*)path ensureFilesExist:(BOOL)ensure inTargetBuildContext:(PBXTargetBuildContext*)context
{
	return nil;
}

- (XCPropertyDomainSpecification*) specificationToShowInUserInterface
{
	XCPropertyDomainSpecification* spec = [[XCPropertyDomainSpecification specificationRegistry] objectForKey:@"fr.inria.win32.buildsettings.compiler-linker"];
	return (XCPropertyDomainSpecification*)[spec loadedSpecification];
}

@end
