/*
	INLinkerSpecificationWin32.m - Win32Plugin
	Copyright 2005-2006 Damien Bobillot.
	Modified for a C/C++ cross-compiler by Manolo Gouy
	Distributed under the GPL licence.
	*/

#import "INLinkerSpecificationWin32.h"
#import "INWin32Tools.h"
#import "XCPBuildSystem.h"
#import "XCPSupport.h"
#import "XCPDependencyGraph.h"

@implementation INLinkerSpecificationWin32
- (NSArray*)createCommandsInBuildContext:(PBXTargetBuildContext*)context
{
	NSArray* inputs = [[context expandedValueForString:@"$(Inputs)"] arrayByParsingAsStringList];
	NSString* output = [context expandedValueForString:@"$(Output)"];
	return [self computeDependenciesForFilePaths:inputs outputPath:output inTargetBuildContext:context];
}

- (NSArray*)computeDependenciesForFilePaths:(NSArray*)inputs outputPath:(NSString*)output inTargetBuildContext:(PBXTargetBuildContext*)context
{
	[INWin32Tools setupWin32PathsWithSpecification:self context:context];

	// compute output path
	output = [context expandedValueForString:output];
	
	// create linker command
	XCDependencyNode* outputNode = [context dependencyNodeForName:output createIfNeeded:YES];
	XCDependencyCommand* dep = [context
		createCommandWithRuleInfo:[NSArray arrayWithObjects:@"Win32Linker",[context naturalPathForPath:output],nil]
		commandPath:[context expandedValueForString:[self Win32ExecutablePathInTargetBuildContext:context]]
		arguments:nil
		forNode:outputNode];
	[dep setToolSpecification:self];
	[dep addArgument:@"-o"];
	[dep addArgument:output];
		
	// create dependency rules for compiled object
	NSEnumerator* objectEnum = [inputs objectEnumerator];
	NSString* input;
	while((input = [objectEnum nextObject]) != nil) {
		input = [context expandedValueForString:input];
		PBXFileType* type = [PBXFileType fileTypeForFileName:[input lastPathComponent]];
		
		if([type isKindOfSpecification:[PBXFileType specificationForIdentifier:@"compiled.win32.objfile"]] ) { 
			XCDependencyNode* inputNode = [context dependencyNodeForName:input createIfNeeded:YES];
			[outputNode addDependedNode:inputNode];
			[dep addArgument:input];
			
		} else {
			[context addDependencyAnalysisWarningMessageFormat:
				@"warning: skipping file '%@' (unexpected file type '%@' in link phase)",
				input, [type identifier]];
		}
	}

	// create dependency rules for libraries
	NSEnumerator* libraryEnum = [[context linkedLibraryPaths] objectEnumerator];
	NSString* library;
	while((library = [libraryEnum nextObject]) != nil) {
		library = [context expandedValueForString:library];
				
		// check if file is a library file
		PBXFileType* type = [PBXFileType fileTypeForFileName:[library lastPathComponent]];
		if([type isKindOfSpecification:[PBXFileType specificationForIdentifier:@"archive.ar"]])
		{
			XCDependencyNode* libraryNode = [context dependencyNodeForName:library createIfNeeded:YES];
			[outputNode addDependedNode:libraryNode];
			// creates "-Lpath-to-library-file"
			NSString* libdir = [[library stringByDeletingLastPathComponent] stringByStandardizingPath];
			[dep addArgument: [@"-L" stringByAppendingString: libdir ]];
			// creates "-llibrary-name"
			NSString* shortlib = [library lastPathComponent];
			shortlib = [shortlib stringByDeletingPathExtension];
			shortlib = [shortlib substringFromIndex:3];
			[dep addArgument: [@"-l" stringByAppendingString: shortlib ]];
			continue;
		}
		// file type is not supported
		[context addDependencyAnalysisWarningMessageFormat:
			@"warning: skipping file '%@' (unexpected file type '%@' in Frameworks & Libraries build phase)",
			library, [type identifier]];		
	}
	
//linker options
	[dep addArgumentsFromArray:[self commandLineForAutogeneratedOptionsInTargetBuildContext:context]];
	
	return [NSArray arrayWithObject:outputNode];
}
@end


@implementation INLibtoolSpecificationWin32
- (NSArray*)computeDependenciesForFilePaths:(NSArray*)inputs outputPath:(NSString*)output inTargetBuildContext:(PBXTargetBuildContext*)context
{
	[INWin32Tools setupWin32PathsWithSpecification:self context:context];

	// compute output path
	output = [context expandedValueForString:output];
	
	// create linker command
	XCDependencyNode* outputNode = [context dependencyNodeForName:output createIfNeeded:YES];
	XCDependencyCommand* dep = [context
		createCommandWithRuleInfo:[NSArray arrayWithObjects:@"Win32Libtool",[context naturalPathForPath:output],nil]
		commandPath:[context expandedValueForString:[self Win32ExecutablePathInTargetBuildContext:context]]
		arguments:nil
		forNode:outputNode];
	[dep setToolSpecification:self];
	[dep addArgument:@"rcf"];
	[dep addArgument:output];
		
	// create dependency rules for compiled object
	NSEnumerator* objectEnum = [inputs objectEnumerator];
	NSString* input;
	while((input = [objectEnum nextObject]) != nil) {
		input = [context expandedValueForString:input];
		PBXFileType* type = [PBXFileType fileTypeForFileName:[input lastPathComponent]];
		
		if([type isKindOfSpecification:[PBXFileType specificationForIdentifier:@"compiled.win32.objfile"]] ) { 
			XCDependencyNode* inputNode = [context dependencyNodeForName:input createIfNeeded:YES];
			[outputNode addDependedNode:inputNode];
			[dep addArgument:input];
			
		} else {
			[context addDependencyAnalysisWarningMessageFormat:
				@"warning: skipping file '%@' (unexpected file type '%@' in link phase)",
				input, [type identifier]];
		}
	}

	
//linker options
	[dep addArgumentsFromArray:[self commandLineForAutogeneratedOptionsInTargetBuildContext:context]];
	
	return [NSArray arrayWithObject:outputNode];
}
@end
