/*
	INWin32ProductType.m - Win32Plugin
	Copyright 2005-2006 Damien Bobillot.
	Modified for a C/C++ cross-compiler by Manolo Gouy
	Distributed under the GPL licence.
	
	History:
	- 26/09/05: created by Damien Bobillot (damien.bobillot.2002_ocamlplugin@m4x.org)
*/

#import "INWin32ProductType.h"
#import "XCPBuildSystem.h"

@implementation INWin32ProductType
- (void) computeProductDependenciesInTargetBuildContext:(PBXTargetBuildContext*)context
{
	NSString* productPath = [context expandedValueForString:@"$(TARGET_BUILD_DIR)/$(EXECUTABLE_PATH)"];

	XCDependencyNode* productNode = [context dependencyNodeForName:productPath createIfNeeded:YES];
	[context addProductNode:productNode];
}

- (XCLinkerSpecification*) linkerSpecificationForObjectFilesInTargetBuildContext:(PBXTargetBuildContext*)context
{
	XCSpecification* spec = [XCLinkerSpecification specificationForIdentifier:@"fr.inria.win32.linker"];
	return [[spec class] isSubclassOfClass:[XCLinkerSpecification class]] ? (XCLinkerSpecification*)spec : nil;
}
@end


@implementation INWin32ProductTypeLib
- (void) computeProductDependenciesInTargetBuildContext:(PBXTargetBuildContext*)context
{
	NSString* productPath = [context expandedValueForString:@"$(TARGET_BUILD_DIR)/$(EXECUTABLE_PATH)"];
	XCDependencyNode* productNode = [context dependencyNodeForName:productPath createIfNeeded:YES];
	[context addProductNode:productNode];
}

- (XCLinkerSpecification*) linkerSpecificationForObjectFilesInTargetBuildContext:(PBXTargetBuildContext*)context
{
	XCSpecification* spec = [XCLinkerSpecification specificationForIdentifier:@"fr.inria.win32.libtool"];
	return [[spec class] isSubclassOfClass:[XCLinkerSpecification class]] ? (XCLinkerSpecification*)spec : nil;
}
@end
