/*
	INWin32Tools.m - Win32Plugin
	Copyright 2005-2006 Damien Bobillot.
	Modified for a C/C++ cross-compiler by Manolo Gouy
	Distributed under the GPL licence.
	
	History:
	- 02/10/05: created by Damien Bobillot (damien.bobillot.2002_ocamlplugin@m4x.org)
*/

#import "INWin32Tools.h"
#import "XCPBuildSystem.h"
#import "XCPSpecifications.h"

@implementation XCCommandLineToolSpecification (INWin32Tools)
- (NSString*)Win32ExecutablePathInTargetBuildContext:(PBXTargetBuildContext*)context
{
	return [self stringForKey:@"ExecPath"];
}
@end

@implementation INWin32Tools
+ (void)setupWin32PathsWithSpecification:(id)spec context:(PBXTargetBuildContext*)context
{
	// Setup Win32 base path
	NSString* win32gxx = [[NSUserDefaults standardUserDefaults] stringForKey:@"win32gxxpath"];
	if(win32gxx == nil) win32gxx = @"/usr/local/cross/bin/mingw32-g++";
	[context setStringValue:win32gxx forDynamicSetting:@"WIN32GXX_PATH"];

	NSString* win32gcc = [[NSUserDefaults standardUserDefaults] stringForKey:@"win32gccpath"];
	if(win32gcc == nil) win32gcc = @"/usr/local/cross/bin/mingw32-gcc";
	[context setStringValue:win32gcc forDynamicSetting:@"WIN32GCC_PATH"];

	NSString* win32ar = [[NSUserDefaults standardUserDefaults] stringForKey:@"win32arpath"];
	if(win32ar == nil) win32ar = @"/usr/local/cross/bin/mingw32-ar";
	[context setStringValue:win32ar forDynamicSetting:@"WIN32LIBTOOL_PATH"];
}
@end
