/*
	CompilerSpecificationWin32.m
	Copyright 2006-2008 Damien Bobillot.
	Modified for a C/C++ cross-compiler by Manolo Gouy
	Distributed under the GPL v3 licence.
*/

#import "XCPSpecifications.h"
#import "XCPBuildSystem.h"
#import "XCPDependencyGraph.h"
#import "XCPSupport.h"
#import "INWin32Tools.h"
#include <stdlib.h>

@interface CompilerSpecificationWin32 : XCCompilerSpecification
@end

@implementation CompilerSpecificationWin32 
+ (void) initialize
{
// to avoid compiler messages from being translated
	putenv("LC_MESSAGES=C");
}

- (NSArray*) computeDependenciesForInputFile:(NSString*)input ofType:(PBXFileType*)type
    variant:(NSString*)variant architecture:(NSString*)arch
    outputDirectory:(NSString*)outputDir
    inTargetBuildContext:(PBXTargetBuildContext*)context
{
	[INWin32Tools setupWin32PathsWithSpecification:self context:context];	
//receive from the package-type the ID of the adequate link tool
	NSString *linkerid = [context expandedValueForString:@"$(LinkerID)"];
	[context setStringValue:linkerid forDynamicSetting:@"compiler_mandated_linker"];
	
	// compute input path (for variable substitution)
    input = [context expandedValueForString:input];
    
    // compute output path
    NSString* output = [outputDir stringByAppendingPathComponent:[[[input lastPathComponent] stringByDeletingPathExtension] stringByAppendingPathExtension:@"w32o"]];
    output = [context expandedValueForString:output];
    
    // create dependency nodes
    XCDependencyNode* outputNode = [context dependencyNodeForName:output createIfNeeded:YES];
    XCDependencyNode* inputNode = [context dependencyNodeForName:input createIfNeeded:YES];
    
    // create compiler command
    XCDependencyCommand* dep = [context
        createCommandWithRuleInfo:[NSArray arrayWithObjects:@"Win32C/C++Compile",[context naturalPathForPath:input],nil]
        commandPath:[context expandedValueForString:[self Win32ExecutablePathInTargetBuildContext:context]]
        arguments:nil
        forNode:outputNode];
    [dep setToolSpecification:self];
    [dep addArgumentsFromArray:[self commandLineForAutogeneratedOptionsInTargetBuildContext:context]];
    [dep addArgumentsFromArray:[[context expandedValueForString:@"$(build_file_compiler_flags)"] arrayByParsingAsStringList]];
	[dep addArgument:@"-c"];
    [dep addArgument:@"-o"];
    [dep addArgument:output];
    [dep addArgument:input];
    
    // create dependency rules
    [outputNode addDependedNode:inputNode];

    // update source-compiled links
    [context setCompiledFilePath:output forSourceFilePath:input];
    	
	// add file to object files (used by linker)
		NSString* object_files_variant_arch = [context expandedValueForString:@"object_files"];
		[context appendStringOrStringListValue:output toDynamicSetting:object_files_variant_arch];
		
    // return output object node (Xcode will automaticaly add .o files to $(object_files))
    return [NSArray arrayWithObject:outputNode];
}
@end
