/*
 * Decompiled with CFR 0.152.
 */
package converter;

import converter.Converter;
import java.util.logging.Level;
import java.util.logging.Logger;
import parser.ParseException;
import reader.Reader;
import types.MSA;
import writer.Writer;

public class DefaultConverter
implements Converter {
    private boolean collapse;
    private boolean gapsAsMissing;
    private boolean countMissing;
    private int limit;
    private Logger logger;
    private Reader reader;
    private Writer writer;

    public DefaultConverter(Reader reader, Writer writer, boolean bl, boolean bl2, boolean bl3, int n, String string) {
        this.reader = reader;
        this.writer = writer;
        this.collapse = bl;
        this.gapsAsMissing = bl2;
        this.countMissing = bl3;
        this.limit = n;
        this.logger = Logger.getLogger(string);
    }

    @Override
    public String convert(String string) throws ParseException {
        MSA mSA = this.reader.read(string);
        if (this.collapse) {
            this.logger.log(Level.INFO, "*** haplotype collapse begin ***");
            mSA = mSA.collapse(this.gapsAsMissing, this.countMissing, this.limit, this.logger.getName());
            this.logger.log(Level.INFO, "*** haplotype collapse end ***");
        }
        return this.writer.write(mSA);
    }
}

