/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;

public class ConvertPanel
extends JPanel {
    private JCheckBox collapse;
    private JCheckBox collapseGaps;
    private JSpinner collapseLimit;
    private JLabel collapseLimitLabel;
    private JCheckBox collapseMissing;
    private JPanel collapsePanel;
    private JCheckBox inputAutodetect;
    private JComboBox inputFormat;
    private JLabel inputFormatLabel;
    private JComboBox inputOS;
    private JLabel inputOSLabel;
    private JPanel inputPanel;
    private JComboBox inputProgram;
    private JLabel inputProgramLabel;
    private JComboBox outputFormat;
    private JLabel outputFormatLabel;
    private JCheckBox outputLowerCase;
    private JCheckBox outputMatch;
    private JComboBox outputOS;
    private JLabel outputOSLabel;
    private JPanel outputPanel;
    private JComboBox outputProgram;
    private JLabel outputProgramLabel;
    private JCheckBox outputResidueNumbers;
    private JCheckBox outputSequential;

    public ConvertPanel() {
        this.initComponents();
    }

    public String getInputOS() {
        return (String)this.inputOS.getItemAt(this.inputOS.getSelectedIndex());
    }

    public String getInputProgram() {
        return (String)this.inputProgram.getItemAt(this.inputProgram.getSelectedIndex());
    }

    public String getInputFormat() {
        return (String)this.inputFormat.getItemAt(this.inputFormat.getSelectedIndex());
    }

    public boolean getInputAutodetect() {
        return this.inputAutodetect.isSelected();
    }

    public boolean getCollapse() {
        return this.collapse.isSelected();
    }

    public int getCollapseLimit() {
        return (Integer)this.collapseLimit.getModel().getValue();
    }

    public boolean getCollapseGaps() {
        return this.collapseGaps.isSelected();
    }

    public boolean getCollapseMissing() {
        return this.collapseMissing.isSelected();
    }

    public String getOutputOS() {
        return (String)this.outputOS.getItemAt(this.outputOS.getSelectedIndex());
    }

    public String getOutputProgram() {
        return (String)this.outputProgram.getItemAt(this.outputProgram.getSelectedIndex());
    }

    public String getOutputFormat() {
        return (String)this.outputFormat.getItemAt(this.outputFormat.getSelectedIndex());
    }

    public boolean getOutputLowerCase() {
        return this.outputLowerCase.isSelected();
    }

    public boolean getOutputResidueNumbers() {
        return this.outputResidueNumbers.isSelected();
    }

    public boolean getOutputSequential() {
        return this.outputSequential.isSelected();
    }

    public boolean getOutputMatch() {
        return this.outputMatch.isSelected();
    }

    private void initComponents() {
        this.inputPanel = new JPanel();
        this.inputOS = new JComboBox();
        this.inputOSLabel = new JLabel();
        this.inputProgramLabel = new JLabel();
        this.inputProgram = new JComboBox();
        this.inputFormatLabel = new JLabel();
        this.inputFormat = new JComboBox();
        this.inputAutodetect = new JCheckBox();
        this.outputPanel = new JPanel();
        this.outputProgramLabel = new JLabel();
        this.outputProgram = new JComboBox();
        this.outputFormatLabel = new JLabel();
        this.outputFormat = new JComboBox();
        this.outputLowerCase = new JCheckBox();
        this.outputResidueNumbers = new JCheckBox();
        this.outputOSLabel = new JLabel();
        this.outputOS = new JComboBox();
        this.outputSequential = new JCheckBox();
        this.outputMatch = new JCheckBox();
        this.collapsePanel = new JPanel();
        this.collapse = new JCheckBox();
        this.collapseGaps = new JCheckBox();
        this.collapseLimit = new JSpinner();
        this.collapseLimitLabel = new JLabel();
        this.collapseMissing = new JCheckBox();
        this.setName("Convert MSA");
        this.inputPanel.setBorder(BorderFactory.createTitledBorder("Input"));
        this.inputOS.setModel(new DefaultComboBoxModel<String>(new String[]{"Linux", "MacOS", "Windows"}));
        this.inputOS.setEnabled(false);
        this.inputOSLabel.setText("OS");
        this.inputOSLabel.setEnabled(false);
        this.inputProgramLabel.setText("Program");
        this.inputProgramLabel.setEnabled(false);
        this.inputProgram.setModel(new DefaultComboBoxModel<String>(new String[]{"Clustal", "MAFFT", "MUSCLE", "PROBCONS", "TCoffee"}));
        this.inputProgram.setEnabled(false);
        this.inputProgram.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConvertPanel.this.inputProgramActionPerformed(actionEvent);
            }
        });
        this.inputFormatLabel.setText("Format");
        this.inputFormatLabel.setEnabled(false);
        this.inputFormat.setModel(new DefaultComboBoxModel<String>(new String[]{"ALN", "FASTA", "GDE", "MSF", "NEXUS", "PHYLIP", "PIR"}));
        this.inputFormat.setEnabled(false);
        this.inputAutodetect.setSelected(true);
        this.inputAutodetect.setText("Autodetect");
        this.inputAutodetect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConvertPanel.this.inputAutodetectActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.inputPanel);
        this.inputPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.inputOSLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.inputOS, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inputProgramLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.inputProgram, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inputFormatLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.inputFormat, -2, -1, -2)).addComponent(this.inputAutodetect)).addContainerGap(29, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.inputOSLabel).addComponent(this.inputOS, -2, -1, -2).addComponent(this.inputProgramLabel).addComponent(this.inputProgram, -2, -1, -2).addComponent(this.inputFormatLabel).addComponent(this.inputFormat, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 7, Short.MAX_VALUE).addComponent(this.inputAutodetect)));
        this.outputPanel.setBorder(BorderFactory.createTitledBorder("Output"));
        this.outputProgramLabel.setText("Program");
        this.outputProgram.setModel(new DefaultComboBoxModel<String>(new String[]{"GENERAL", "Clustal", "MAFFT", "MUSCLE", "PROBCONS", "TCoffee", "BioEdit", "Se-Al", "Gblocks", "trimAl", "jModelTest", "ProtTest", "MEGA", "Mesquite", "MrBayes", "PAML", "PAUP", "PhyML", "RAxML", "SeaView", "SplitsTree", "TCS", "dnaSP"}));
        this.outputProgram.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConvertPanel.this.outputProgramActionPerformed(actionEvent);
            }
        });
        this.outputFormatLabel.setText("Format");
        this.outputFormat.setModel(new DefaultComboBoxModel<String>(new String[]{"ALN", "FASTA", "GDE", "MEGA", "MSF", "NEXUS", "PHYLIP", "PIR"}));
        this.outputFormat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConvertPanel.this.outputFormatActionPerformed(actionEvent);
            }
        });
        this.outputLowerCase.setText("Lower case");
        this.outputResidueNumbers.setText("Residue numbers");
        this.outputOSLabel.setText("OS");
        this.outputOS.setModel(new DefaultComboBoxModel<String>(new String[]{"Linux", "MacOS", "Windows"}));
        this.outputSequential.setText("Sequential");
        this.outputSequential.setEnabled(false);
        this.outputMatch.setText("Match first");
        GroupLayout groupLayout2 = new GroupLayout(this.outputPanel);
        this.outputPanel.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addComponent(this.outputOSLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.outputOS, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.outputProgramLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.outputProgram, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.outputFormatLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.outputFormat, -2, -1, -2)).addGroup(groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.outputResidueNumbers).addComponent(this.outputLowerCase)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.outputMatch).addComponent(this.outputSequential)))).addContainerGap(28, Short.MAX_VALUE)));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.outputOSLabel).addComponent(this.outputOS, -2, -1, -2).addComponent(this.outputProgramLabel).addComponent(this.outputProgram, -2, -1, -2).addComponent(this.outputFormatLabel).addComponent(this.outputFormat, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.outputLowerCase).addComponent(this.outputMatch)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.outputResidueNumbers).addComponent(this.outputSequential))));
        this.collapsePanel.setBorder(BorderFactory.createTitledBorder("Collapse"));
        this.collapse.setText("Collapse sequences to haplotypes");
        this.collapse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConvertPanel.this.collapseActionPerformed(actionEvent);
            }
        });
        this.collapseGaps.setText("Treat gaps as missing data");
        this.collapseGaps.setEnabled(false);
        this.collapseLimit.setModel(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        this.collapseLimit.setEnabled(false);
        this.collapseLimitLabel.setText("Limit");
        this.collapseLimitLabel.setEnabled(false);
        this.collapseMissing.setSelected(true);
        this.collapseMissing.setText("Count missing data as differences");
        this.collapseMissing.setEnabled(false);
        GroupLayout groupLayout3 = new GroupLayout(this.collapsePanel);
        this.collapsePanel.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addComponent(this.collapse).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.collapseLimitLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.collapseLimit, -1, 125, Short.MAX_VALUE).addGap(93, 93, 93)).addGroup(groupLayout3.createSequentialGroup().addComponent(this.collapseGaps).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.collapseMissing))).addContainerGap()));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.collapse).addComponent(this.collapseLimitLabel).addComponent(this.collapseLimit, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.collapseGaps).addComponent(this.collapseMissing))));
        GroupLayout groupLayout4 = new GroupLayout(this);
        this.setLayout(groupLayout4);
        groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.inputPanel, -1, -1, Short.MAX_VALUE).addComponent(this.outputPanel, -1, -1, Short.MAX_VALUE).addComponent(this.collapsePanel, -1, -1, Short.MAX_VALUE));
        groupLayout4.setVerticalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addComponent(this.inputPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.collapsePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.outputPanel, -2, -1, -2)));
    }

    private void outputProgramActionPerformed(ActionEvent actionEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String string = (String)ConvertPanel.this.outputProgram.getItemAt(ConvertPanel.this.outputProgram.getSelectedIndex());
                if (string.equals("GENERAL")) {
                    ConvertPanel.this.outputFormat.setModel(new DefaultComboBoxModel<String>(new String[]{"ALN", "FASTA", "GDE", "MEGA", "MSF", "NEXUS", "PHYLIP", "PIR"}));
                } else if (string.equals("jModelTest")) {
                    ConvertPanel.this.outputFormat.setModel(new DefaultComboBoxModel<String>(new String[]{"ALN", "FASTA", "MSF", "NEXUS", "PHYLIP", "PIR"}));
                } else if (string.equals("MrBayes")) {
                    ConvertPanel.this.outputFormat.setModel(new DefaultComboBoxModel<String>(new String[]{"NEXUS"}));
                } else if (string.equals("PAML")) {
                    ConvertPanel.this.outputFormat.setModel(new DefaultComboBoxModel<String>(new String[]{"NEXUS", "PHYLIP"}));
                } else if (string.equals("PAUP")) {
                    ConvertPanel.this.outputFormat.setModel(new DefaultComboBoxModel<String>(new String[]{"MEGA", "MSF", "NEXUS", "PHYLIP", "PIR"}));
                } else if (string.equals("PhyML")) {
                    ConvertPanel.this.outputFormat.setModel(new DefaultComboBoxModel<String>(new String[]{"PHYLIP"}));
                } else if (string.equals("ProtTest")) {
                    ConvertPanel.this.outputFormat.setModel(new DefaultComboBoxModel<String>(new String[]{"NEXUS", "PHYLIP"}));
                } else if (string.equals("RAxML")) {
                    ConvertPanel.this.outputFormat.setModel(new DefaultComboBoxModel<String>(new String[]{"PHYLIP"}));
                } else if (string.equals("RAxML")) {
                    ConvertPanel.this.outputFormat.setModel(new DefaultComboBoxModel<String>(new String[]{"NEXUS", "PHYLIP"}));
                } else if (string.equals("TCS")) {
                    ConvertPanel.this.outputFormat.setModel(new DefaultComboBoxModel<String>(new String[]{"NEXUS", "PHYLIP"}));
                } else if (string.equals("BioEdit")) {
                    ConvertPanel.this.outputFormat.setModel(new DefaultComboBoxModel<String>(new String[]{"ALN", "FASTA", "MSF", "NEXUS", "PHYLIP", "PIR"}));
                } else if (string.equals("MEGA")) {
                    ConvertPanel.this.outputFormat.setModel(new DefaultComboBoxModel<String>(new String[]{"ALN", "FASTA", "MEGA", "MSF", "NEXUS", "PHYLIP", "PIR"}));
                } else if (string.equals("dnaSP")) {
                    ConvertPanel.this.outputFormat.setModel(new DefaultComboBoxModel<String>(new String[]{"FASTA", "MEGA", "NEXUS", "PHYLIP", "PIR"}));
                } else if (string.equals("Se-Al")) {
                    ConvertPanel.this.outputFormat.setModel(new DefaultComboBoxModel<String>(new String[]{"FASTA", "GDE", "NEXUS", "PHYLIP", "PIR"}));
                } else if (string.equals("Mesquite")) {
                    ConvertPanel.this.outputFormat.setModel(new DefaultComboBoxModel<String>(new String[]{"NEXUS"}));
                } else if (string.equals("SplitsTree")) {
                    ConvertPanel.this.outputFormat.setModel(new DefaultComboBoxModel<String>(new String[]{"ALN", "FASTA", "NEXUS", "PHYLIP"}));
                } else if (string.equals("Clustal")) {
                    ConvertPanel.this.outputFormat.setModel(new DefaultComboBoxModel<String>(new String[]{"ALN", "FASTA", "GDE", "MSF", "PIR"}));
                } else if (string.equals("MAFFT")) {
                    ConvertPanel.this.outputFormat.setModel(new DefaultComboBoxModel<String>(new String[]{"FASTA"}));
                } else if (string.equals("MUSCLE")) {
                    ConvertPanel.this.outputFormat.setModel(new DefaultComboBoxModel<String>(new String[]{"FASTA"}));
                } else if (string.equals("PROBCONS")) {
                    ConvertPanel.this.outputFormat.setModel(new DefaultComboBoxModel<String>(new String[]{"FASTA"}));
                } else if (string.equals("TCoffee")) {
                    ConvertPanel.this.outputFormat.setModel(new DefaultComboBoxModel<String>(new String[]{"ALN", "FASTA", "MSF", "PIR"}));
                } else if (string.equals("Gblocks")) {
                    ConvertPanel.this.outputFormat.setModel(new DefaultComboBoxModel<String>(new String[]{"FASTA", "PIR"}));
                } else if (string.equals("SeaView")) {
                    ConvertPanel.this.outputFormat.setModel(new DefaultComboBoxModel<String>(new String[]{"ALN", "FASTA", "MSF", "NEXUS", "PHYLIP"}));
                } else if (string.equals("trimAl")) {
                    ConvertPanel.this.outputFormat.setModel(new DefaultComboBoxModel<String>(new String[]{"ALN", "FASTA", "MEGA", "NEXUS", "PHYLIP", "PIR"}));
                }
            }
        });
        this.outputFormatActionPerformed(actionEvent);
    }

    private void outputFormatActionPerformed(ActionEvent actionEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String string = (String)ConvertPanel.this.outputFormat.getItemAt(ConvertPanel.this.outputFormat.getSelectedIndex());
                String string2 = (String)ConvertPanel.this.outputProgram.getItemAt(ConvertPanel.this.outputProgram.getSelectedIndex());
                if (string.equals("ALN")) {
                    ConvertPanel.this.outputResidueNumbers.setEnabled(true);
                } else {
                    ConvertPanel.this.outputResidueNumbers.setSelected(false);
                    ConvertPanel.this.outputResidueNumbers.setEnabled(false);
                }
                if (string.equals("PHYLIP")) {
                    if (string2.equals("TCS")) {
                        ConvertPanel.this.outputSequential.setSelected(true);
                        ConvertPanel.this.outputSequential.setEnabled(false);
                    } else if (string2.equals("SeaView")) {
                        ConvertPanel.this.outputSequential.setSelected(false);
                        ConvertPanel.this.outputSequential.setEnabled(false);
                    } else {
                        ConvertPanel.this.outputSequential.setEnabled(true);
                    }
                } else if (string.equals("NEXUS")) {
                    if (string2.equals("PAML") || string2.equals("ProtTest") || string2.equals("TCS")) {
                        ConvertPanel.this.outputSequential.setSelected(true);
                        ConvertPanel.this.outputSequential.setEnabled(false);
                    } else if (string2.equals("MEGA") || string2.equals("trimAl")) {
                        ConvertPanel.this.outputSequential.setSelected(false);
                        ConvertPanel.this.outputSequential.setEnabled(false);
                    } else {
                        ConvertPanel.this.outputSequential.setEnabled(true);
                    }
                } else {
                    ConvertPanel.this.outputSequential.setSelected(false);
                    ConvertPanel.this.outputSequential.setEnabled(false);
                }
                if (string.equals("MSF") || string2.equals("MrBayes") || string2.equals("SplitsTree") || string2.equals("Clustal") || string2.equals("MAFFT") || string2.equals("Gblocks") || string2.equals("dnaSP") && string.equals("NEXUS")) {
                    ConvertPanel.this.outputMatch.setSelected(false);
                    ConvertPanel.this.outputMatch.setEnabled(false);
                } else {
                    ConvertPanel.this.outputMatch.setEnabled(true);
                }
            }
        });
    }

    private void inputAutodetectActionPerformed(ActionEvent actionEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ConvertPanel.this.inputAutodetect.isSelected()) {
                    ConvertPanel.this.inputOSLabel.setEnabled(false);
                    ConvertPanel.this.inputOS.setEnabled(false);
                    ConvertPanel.this.inputProgramLabel.setEnabled(false);
                    ConvertPanel.this.inputProgram.setEnabled(false);
                    ConvertPanel.this.inputFormatLabel.setEnabled(false);
                    ConvertPanel.this.inputFormat.setEnabled(false);
                } else {
                    ConvertPanel.this.inputOSLabel.setEnabled(true);
                    ConvertPanel.this.inputOS.setEnabled(true);
                    ConvertPanel.this.inputProgramLabel.setEnabled(true);
                    ConvertPanel.this.inputProgram.setEnabled(true);
                    ConvertPanel.this.inputFormatLabel.setEnabled(true);
                    ConvertPanel.this.inputFormat.setEnabled(true);
                }
            }
        });
    }

    private void collapseActionPerformed(ActionEvent actionEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ConvertPanel.this.collapse.isSelected()) {
                    ConvertPanel.this.collapseLimitLabel.setEnabled(true);
                    ConvertPanel.this.collapseLimit.setEnabled(true);
                    ConvertPanel.this.collapseGaps.setEnabled(true);
                    ConvertPanel.this.collapseMissing.setEnabled(true);
                } else {
                    ConvertPanel.this.collapseLimitLabel.setEnabled(false);
                    ConvertPanel.this.collapseLimit.setEnabled(false);
                    ConvertPanel.this.collapseGaps.setEnabled(false);
                    ConvertPanel.this.collapseMissing.setEnabled(false);
                }
            }
        });
    }

    private void inputProgramActionPerformed(ActionEvent actionEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String string = (String)ConvertPanel.this.inputProgram.getItemAt(ConvertPanel.this.inputProgram.getSelectedIndex());
                if (string.equals("Clustal")) {
                    ConvertPanel.this.inputFormat.setModel(new DefaultComboBoxModel<String>(new String[]{"ALN", "FASTA", "GDE", "MSF", "NEXUS", "PHYLIP", "PIR"}));
                } else if (string.equals("MAFFT")) {
                    ConvertPanel.this.inputFormat.setModel(new DefaultComboBoxModel<String>(new String[]{"ALN", "FASTA"}));
                } else if (string.equals("MUSCLE")) {
                    ConvertPanel.this.inputFormat.setModel(new DefaultComboBoxModel<String>(new String[]{"ALN", "FASTA", "MSF", "PHYLIP"}));
                } else if (string.equals("PROBCONS")) {
                    ConvertPanel.this.inputFormat.setModel(new DefaultComboBoxModel<String>(new String[]{"ALN", "FASTA"}));
                } else if (string.equals("TCoffee")) {
                    ConvertPanel.this.inputFormat.setModel(new DefaultComboBoxModel<String>(new String[]{"ALN", "FASTA", "MSF", "PHYLIP", "PIR"}));
                }
            }
        });
    }
}

