/*
 * Decompiled with CFR 0.152.
 */
package gui;

import converter.Converter;
import converter.DefaultFactory;
import gui.ConvertPanel;
import gui.GUILogHandler;
import gui.HelpPanel;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import parser.ParseException;

public class MainFrame
extends JFrame {
    private Logger logger;
    private File inputFile = null;
    private File outputFile = null;
    private File inputCurDir = null;
    private File outputCurDir = null;
    private AboutAction aboutAction;
    private HelpAction helpAction;
    private LoadMsaAction loadMsaAction;
    private SaveInputAction saveInputAction;
    private SaveInputAsAction saveInputAsAction;
    private SaveOutputAction saveOutputAction;
    private SaveOutputAsAction saveOutputAsAction;
    private SaveAllAction saveAllAction;
    private ConvertAction convertAction;
    private ExitAction exitAction;
    ConvertPanel convertPanel;
    private JMenuItem about;
    private JButton convertButton;
    private JMenuItem convertMenu;
    private JMenuItem exitMenu;
    private JMenu fileMenu;
    private JMenuItem helpContents;
    private JMenu helpMenu;
    private JTextArea input;
    private JPanel inputPanel;
    private JLabel inputPosition;
    private JScrollPane inputScroll;
    private JButton loadMsaButton;
    private JMenuItem loadMsaMenu;
    private JTextArea log;
    private JPanel logPanel;
    private JScrollPane logScroll;
    private JMenuBar menu;
    private JTextArea output;
    private JPanel outputPanel;
    private JLabel outputPosition;
    private JScrollPane outputScroll;
    private JMenuItem saveAllMenu;
    private JButton saveInputAsButton;
    private JMenuItem saveInputAsMenu;
    private JButton saveInputButton;
    private JMenuItem saveInputMenu;
    private JButton saveOutputAsButton;
    private JMenuItem saveOutputAsMenu;
    private JButton saveOutputButton;
    private JMenuItem saveOutputMenu;
    private JSeparator separator1;
    private JSeparator separator2;
    private JSeparator separator3;

    public MainFrame() {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        this.convertPanel = new ConvertPanel();
        this.aboutAction = new AboutAction("About", null, "Information about ALTER", 65);
        this.helpAction = new HelpAction("Help Contents", null, "", 67);
        this.loadMsaAction = new LoadMsaAction("Load...", null, "Load a new input MSA", 76);
        this.saveInputAction = new SaveInputAction("Save", null, "Save input MSA", 83);
        this.saveInputAsAction = new SaveInputAsAction("Save As...", null, "Save input MSA as...", 73);
        this.saveOutputAction = new SaveOutputAction("Save", null, "Save output MSA", 86);
        this.saveOutputAsAction = new SaveOutputAsAction("Save As...", null, "Save output MSA as...", 79);
        this.saveAllAction = new SaveAllAction("Save All", null, "Save both input and output MSAs", 65);
        this.convertAction = new ConvertAction("Convert...", null, "Convert MSA", 67);
        this.exitAction = new ExitAction("Exit", null, "Exit ALTER", 69);
        this.initComponents();
        this.about.setAction(this.aboutAction);
        this.helpContents.setAction(this.helpAction);
        this.loadMsaButton.setAction(this.loadMsaAction);
        this.loadMsaMenu.setAction(this.loadMsaAction);
        this.loadMsaMenu.setText("Load Input MSA...");
        this.loadMsaMenu.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        this.saveInputMenu.setAction(this.saveInputAction);
        this.saveInputMenu.setText("Save Input MSA");
        this.saveInputMenu.setAccelerator(KeyStroke.getKeyStroke(73, 3));
        this.saveInputButton.setAction(this.saveInputAction);
        this.saveInputAsMenu.setAction(this.saveInputAsAction);
        this.saveInputAsMenu.setText("Save Input MSA As...");
        this.saveInputAsButton.setAction(this.saveInputAsAction);
        this.saveOutputMenu.setAction(this.saveOutputAction);
        this.saveOutputMenu.setText("Save Output MSA");
        this.saveOutputMenu.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.saveOutputButton.setAction(this.saveOutputAction);
        this.saveOutputAsMenu.setAction(this.saveOutputAsAction);
        this.saveOutputAsMenu.setText("Save Output MSA As...");
        this.saveOutputAsButton.setAction(this.saveOutputAsAction);
        this.saveAllMenu.setAction(this.saveAllAction);
        this.saveAllMenu.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        this.convertMenu.setAction(this.convertAction);
        this.convertMenu.setText("Convert MSA...");
        this.convertMenu.setAccelerator(KeyStroke.getKeyStroke(67, 3));
        this.convertButton.setAction(this.convertAction);
        this.exitMenu.setAction(this.exitAction);
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.setMaximizedBounds(graphicsEnvironment.getMaximumWindowBounds());
        this.setExtendedState(this.getExtendedState() | 6);
        this.logger = Logger.getLogger("alter" + System.currentTimeMillis());
        this.logger.addHandler(new GUILogHandler(this.log));
    }

    private void initComponents() {
        this.inputPanel = new JPanel();
        this.inputScroll = new JScrollPane();
        this.input = new JTextArea();
        this.loadMsaButton = new JButton();
        this.saveInputButton = new JButton();
        this.convertButton = new JButton();
        this.inputPosition = new JLabel();
        this.saveInputAsButton = new JButton();
        this.outputPanel = new JPanel();
        this.saveOutputButton = new JButton();
        this.outputScroll = new JScrollPane();
        this.output = new JTextArea();
        this.outputPosition = new JLabel();
        this.saveOutputAsButton = new JButton();
        this.logPanel = new JPanel();
        this.logScroll = new JScrollPane();
        this.log = new JTextArea();
        this.menu = new JMenuBar();
        this.fileMenu = new JMenu();
        this.loadMsaMenu = new JMenuItem();
        this.separator1 = new JSeparator();
        this.convertMenu = new JMenuItem();
        this.separator2 = new JSeparator();
        this.saveInputMenu = new JMenuItem();
        this.saveInputAsMenu = new JMenuItem();
        this.saveOutputMenu = new JMenuItem();
        this.saveOutputAsMenu = new JMenuItem();
        this.saveAllMenu = new JMenuItem();
        this.separator3 = new JSeparator();
        this.exitMenu = new JMenuItem();
        this.helpMenu = new JMenu();
        this.helpContents = new JMenuItem();
        this.about = new JMenuItem();
        this.setDefaultCloseOperation(0);
        this.setTitle("ALTER (ALignment Transformation EnviRonment) v1.1");
        this.setCursor(new Cursor(0));
        this.setLocationByPlatform(true);
        this.setName("mainFrame");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                MainFrame.this.formWindowClosing(windowEvent);
            }
        });
        this.inputPanel.setBorder(BorderFactory.createTitledBorder("Input"));
        this.input.setColumns(Integer.MAX_VALUE);
        this.input.setFont(new Font("Lucida Console", 0, 11));
        this.input.setRows(5);
        this.input.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                MainFrame.this.inputCaretUpdate(caretEvent);
            }
        });
        this.inputScroll.setViewportView(this.input);
        this.loadMsaButton.setText("Load...");
        this.saveInputButton.setText("Save");
        this.convertButton.setText("Convert...");
        this.inputPosition.setHorizontalAlignment(4);
        this.inputPosition.setText("Ln: 1 Col: 1");
        this.saveInputAsButton.setText("Save As...");
        GroupLayout groupLayout = new GroupLayout(this.inputPanel);
        this.inputPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.inputScroll, -1, 410, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.loadMsaButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.saveInputButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.saveInputAsButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.convertButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.inputPosition, -1, 98, Short.MAX_VALUE)))));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent(this.inputScroll, -1, 418, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.loadMsaButton).addComponent(this.saveInputButton).addComponent(this.inputPosition).addComponent(this.saveInputAsButton).addComponent(this.convertButton))));
        this.outputPanel.setBorder(BorderFactory.createTitledBorder("Output"));
        this.saveOutputButton.setText("Save");
        this.output.setColumns(Integer.MAX_VALUE);
        this.output.setFont(new Font("Lucida Console", 0, 11));
        this.output.setRows(5);
        this.output.setEnabled(false);
        this.output.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                MainFrame.this.outputCaretUpdate(caretEvent);
            }
        });
        this.outputScroll.setViewportView(this.output);
        this.outputPosition.setHorizontalAlignment(4);
        this.outputPosition.setText("Ln: 0 Col:0");
        this.outputPosition.setEnabled(false);
        this.saveOutputAsButton.setText("Save As...");
        GroupLayout groupLayout2 = new GroupLayout(this.outputPanel);
        this.outputPanel.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addComponent(this.saveOutputButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.saveOutputAsButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.outputPosition, -1, 260, Short.MAX_VALUE)).addComponent(this.outputScroll, -1, 410, Short.MAX_VALUE)).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addComponent(this.outputScroll, -1, 418, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.saveOutputButton).addComponent(this.saveOutputAsButton)).addComponent(this.outputPosition))));
        this.logPanel.setBorder(BorderFactory.createTitledBorder("Log"));
        this.log.setColumns(Integer.MAX_VALUE);
        this.log.setEditable(false);
        this.log.setFont(new Font("Lucida Console", 0, 11));
        this.log.setRows(5);
        this.logScroll.setViewportView(this.log);
        GroupLayout groupLayout3 = new GroupLayout(this.logPanel);
        this.logPanel.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.logScroll, GroupLayout.Alignment.TRAILING, -1, 858, Short.MAX_VALUE));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.logScroll, GroupLayout.Alignment.TRAILING, -1, 129, Short.MAX_VALUE));
        this.fileMenu.setText("File");
        this.loadMsaMenu.setText("Load Input MSA...");
        this.fileMenu.add(this.loadMsaMenu);
        this.fileMenu.add(this.separator1);
        this.convertMenu.setText("Convert");
        this.fileMenu.add(this.convertMenu);
        this.fileMenu.add(this.separator2);
        this.saveInputMenu.setText("Save Input MSA");
        this.fileMenu.add(this.saveInputMenu);
        this.saveInputAsMenu.setText("Save Input MSA As...");
        this.fileMenu.add(this.saveInputAsMenu);
        this.saveOutputMenu.setText("Save Output MSA");
        this.fileMenu.add(this.saveOutputMenu);
        this.saveOutputAsMenu.setText("Save Output MSA As...");
        this.fileMenu.add(this.saveOutputAsMenu);
        this.saveAllMenu.setText("Save Both");
        this.fileMenu.add(this.saveAllMenu);
        this.fileMenu.add(this.separator3);
        this.exitMenu.setText("Exit");
        this.fileMenu.add(this.exitMenu);
        this.menu.add(this.fileMenu);
        this.helpMenu.setText("Help");
        this.helpContents.setText("Help Contents");
        this.helpMenu.add(this.helpContents);
        this.about.setAction(new AboutAction("About...", null, "Information about Corpus Administrator", null));
        this.about.setText("About");
        this.helpMenu.add(this.about);
        this.menu.add(this.helpMenu);
        this.setJMenuBar(this.menu);
        GroupLayout groupLayout4 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout4);
        groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addComponent(this.inputPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.outputPanel, -1, -1, Short.MAX_VALUE)).addComponent(this.logPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        groupLayout4.setVerticalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.inputPanel, -1, -1, Short.MAX_VALUE).addComponent(this.outputPanel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.logPanel, -1, -1, Short.MAX_VALUE)));
        this.pack();
    }

    private void formWindowClosing(WindowEvent windowEvent) {
        this.exitAction.actionPerformed(null);
    }

    private void inputCaretUpdate(CaretEvent caretEvent) {
        try {
            int n = this.input.getCaretPosition();
            int n2 = this.input.getLineOfOffset(n);
            int n3 = n - this.input.getLineStartOffset(n2);
            this.inputPosition.setText("Ln: " + ++n2 + " Col: " + ++n3);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void outputCaretUpdate(CaretEvent caretEvent) {
        try {
            int n = this.output.getCaretPosition();
            int n2 = this.output.getLineOfOffset(n);
            int n3 = n - this.output.getLineStartOffset(n2);
            this.outputPosition.setText("Ln: " + ++n2 + " Col: " + ++n3);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public static void main(String[] stringArray) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainFrame mainFrame = new MainFrame();
                mainFrame.setVisible(true);
            }
        });
    }

    private class ExitAction
    extends AbstractAction {
        public ExitAction(String string, ImageIcon imageIcon, String string2, Integer n) {
            super(string, imageIcon);
            this.putValue("ShortDescription", string2);
            this.putValue("MnemonicKey", n);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = JOptionPane.showConfirmDialog(new JFrame(), "Are you sure you want to exit ALTER?", "Exit", 0, 3);
            if (n == 0) {
                System.exit(0);
            }
        }
    }

    private class ConvertAction
    extends AbstractAction {
        public ConvertAction(String string, ImageIcon imageIcon, String string2, Integer n) {
            super(string, imageIcon);
            this.putValue("ShortDescription", string2);
            this.putValue("MnemonicKey", n);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = JOptionPane.showConfirmDialog(new JFrame(), MainFrame.this.convertPanel, "Convert MSA", 2, -1);
            if (n == 0) {
                String string = MainFrame.this.input.getText();
                String string2 = MainFrame.this.convertPanel.getInputOS();
                String string3 = MainFrame.this.convertPanel.getInputProgram();
                String string4 = MainFrame.this.convertPanel.getInputFormat();
                boolean bl = MainFrame.this.convertPanel.getInputAutodetect();
                boolean bl2 = MainFrame.this.convertPanel.getCollapse();
                boolean bl3 = MainFrame.this.convertPanel.getCollapseGaps();
                boolean bl4 = MainFrame.this.convertPanel.getCollapseMissing();
                int n2 = MainFrame.this.convertPanel.getCollapseLimit();
                String string5 = "";
                String string6 = MainFrame.this.convertPanel.getOutputOS();
                String string7 = MainFrame.this.convertPanel.getOutputProgram();
                String string8 = MainFrame.this.convertPanel.getOutputFormat();
                boolean bl5 = MainFrame.this.convertPanel.getOutputLowerCase();
                boolean bl6 = MainFrame.this.convertPanel.getOutputResidueNumbers();
                boolean bl7 = MainFrame.this.convertPanel.getOutputSequential();
                boolean bl8 = MainFrame.this.convertPanel.getOutputMatch();
                DefaultFactory defaultFactory = new DefaultFactory();
                try {
                    Converter converter = defaultFactory.getConverter(string2, string3, string4, bl, bl2, bl3, bl4, n2, string6, string7, string8, bl5, bl6, bl7, bl8, MainFrame.this.logger.getName());
                    string5 = converter.convert(string);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    MainFrame.this.logger.log(Level.SEVERE, unsupportedOperationException.getMessage());
                    return;
                }
                catch (ParseException parseException) {
                    MainFrame.this.logger.log(Level.SEVERE, "Failure parsing input file: \n" + parseException.getMessage());
                    return;
                }
                MainFrame.this.output.setText(string5);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MainFrame.this.output.setEnabled(true);
                        MainFrame.this.outputPosition.setEnabled(true);
                        MainFrame.this.outputScroll.getVerticalScrollBar().setValue(0);
                        MainFrame.this.outputScroll.getHorizontalScrollBar().setValue(0);
                        MainFrame.this.saveOutputAsAction.setEnabled(true);
                        MainFrame.this.saveOutputAction.setEnabled(true);
                        MainFrame.this.saveAllAction.setEnabled(true);
                    }
                });
            }
        }
    }

    private class SaveAllAction
    extends AbstractAction {
        public SaveAllAction(String string, ImageIcon imageIcon, String string2, Integer n) {
            super(string, imageIcon);
            this.putValue("ShortDescription", string2);
            this.putValue("MnemonicKey", n);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MainFrame.this.saveInputAction.actionPerformed(actionEvent);
            MainFrame.this.saveOutputAction.actionPerformed(actionEvent);
        }
    }

    private class SaveOutputAsAction
    extends AbstractAction {
        public SaveOutputAsAction(String string, ImageIcon imageIcon, String string2, Integer n) {
            super(string, imageIcon);
            this.putValue("ShortDescription", string2);
            this.putValue("MnemonicKey", n);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileSelectionMode(0);
            jFileChooser.setMultiSelectionEnabled(false);
            jFileChooser.setDialogTitle("Save Output MSA As...");
            jFileChooser.setDialogType(1);
            if (MainFrame.this.outputCurDir != null) {
                jFileChooser.setCurrentDirectory(MainFrame.this.outputCurDir);
            }
            if ((n = jFileChooser.showOpenDialog(new JFrame())) == 0) {
                MainFrame.this.outputFile = jFileChooser.getSelectedFile();
                if (!MainFrame.this.outputFile.exists()) {
                    MainFrame.this.outputFile = new File(MainFrame.this.outputFile.getPath());
                }
                MainFrame.this.outputCurDir = MainFrame.this.outputFile.getParentFile();
                try {
                    FileWriter fileWriter = new FileWriter(MainFrame.this.outputFile);
                    fileWriter.write(MainFrame.this.output.getText());
                    fileWriter.close();
                }
                catch (IOException iOException) {
                    MainFrame.this.logger.log(Level.SEVERE, "Failure saving output MSA file:\n" + iOException.getMessage());
                    return;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ((TitledBorder)MainFrame.this.outputPanel.getBorder()).setTitle("Output - " + MainFrame.this.outputFile.getName());
                        MainFrame.this.outputPanel.repaint();
                    }
                });
                MainFrame.this.logger.log(Level.INFO, "Output MSA saved to " + MainFrame.this.outputFile.getAbsolutePath());
            }
        }
    }

    private class SaveOutputAction
    extends AbstractAction {
        public SaveOutputAction(String string, ImageIcon imageIcon, String string2, Integer n) {
            super(string, imageIcon);
            this.putValue("ShortDescription", string2);
            this.putValue("MnemonicKey", n);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (MainFrame.this.outputFile == null) {
                MainFrame.this.saveOutputAsAction.actionPerformed(actionEvent);
            } else {
                try {
                    FileWriter fileWriter = new FileWriter(MainFrame.this.outputFile);
                    fileWriter.write(MainFrame.this.output.getText());
                    fileWriter.close();
                }
                catch (IOException iOException) {
                    MainFrame.this.logger.log(Level.SEVERE, "Failure saving output MSA file:\n" + iOException.getMessage());
                    return;
                }
                MainFrame.this.logger.log(Level.INFO, "Output MSA saved to " + MainFrame.this.outputFile.getAbsolutePath());
            }
        }
    }

    private class SaveInputAsAction
    extends AbstractAction {
        public SaveInputAsAction(String string, ImageIcon imageIcon, String string2, Integer n) {
            super(string, imageIcon);
            this.putValue("ShortDescription", string2);
            this.putValue("MnemonicKey", n);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileSelectionMode(0);
            jFileChooser.setMultiSelectionEnabled(false);
            jFileChooser.setDialogTitle("Save Input MSA As...");
            jFileChooser.setDialogType(1);
            int n = jFileChooser.showOpenDialog(new JFrame());
            if (n == 0) {
                MainFrame.this.inputFile = jFileChooser.getSelectedFile();
                if (!MainFrame.this.inputFile.exists()) {
                    MainFrame.this.inputFile = new File(MainFrame.this.inputFile.getPath());
                }
                MainFrame.this.inputCurDir = MainFrame.this.inputFile.getParentFile();
                try {
                    FileWriter fileWriter = new FileWriter(MainFrame.this.inputFile);
                    fileWriter.write(MainFrame.this.input.getText());
                    fileWriter.close();
                }
                catch (IOException iOException) {
                    MainFrame.this.logger.log(Level.SEVERE, "Failure saving input MSA file:\n" + iOException.getMessage());
                    return;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ((TitledBorder)MainFrame.this.inputPanel.getBorder()).setTitle("Input - " + MainFrame.this.inputFile.getName());
                        MainFrame.this.inputPanel.repaint();
                    }
                });
                MainFrame.this.logger.log(Level.INFO, "Input MSA saved to " + MainFrame.this.inputFile.getAbsolutePath());
            }
        }
    }

    private class SaveInputAction
    extends AbstractAction {
        public SaveInputAction(String string, ImageIcon imageIcon, String string2, Integer n) {
            super(string, imageIcon);
            this.putValue("ShortDescription", string2);
            this.putValue("MnemonicKey", n);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (MainFrame.this.inputFile == null) {
                MainFrame.this.saveInputAsAction.actionPerformed(actionEvent);
            } else {
                try {
                    FileWriter fileWriter = new FileWriter(MainFrame.this.inputFile);
                    fileWriter.write(MainFrame.this.input.getText());
                    fileWriter.close();
                }
                catch (IOException iOException) {
                    MainFrame.this.logger.log(Level.SEVERE, "Failure saving input MSA file:\n" + iOException.getMessage());
                    return;
                }
                MainFrame.this.logger.log(Level.INFO, "Input MSA saved to " + MainFrame.this.inputFile.getAbsolutePath());
            }
        }
    }

    private class LoadMsaAction
    extends AbstractAction {
        public LoadMsaAction(String string, ImageIcon imageIcon, String string2, Integer n) {
            super(string, imageIcon);
            this.putValue("ShortDescription", string2);
            this.putValue("MnemonicKey", n);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileSelectionMode(0);
            jFileChooser.setMultiSelectionEnabled(false);
            jFileChooser.setDialogTitle("Load Input MSA");
            jFileChooser.setDialogType(0);
            if (MainFrame.this.inputCurDir != null) {
                jFileChooser.setCurrentDirectory(MainFrame.this.inputCurDir);
            }
            if ((n = jFileChooser.showOpenDialog(new JFrame())) == 0) {
                MainFrame.this.inputFile = jFileChooser.getSelectedFile();
                MainFrame.this.inputCurDir = MainFrame.this.inputFile.getParentFile();
                StringBuffer stringBuffer = new StringBuffer();
                try {
                    String string;
                    BufferedReader bufferedReader = new BufferedReader(new FileReader(MainFrame.this.inputFile));
                    while ((string = bufferedReader.readLine()) != null) {
                        stringBuffer.append(string + "\r\n");
                    }
                    bufferedReader.close();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    MainFrame.this.logger.log(Level.SEVERE, "Input MSA file not found.");
                    return;
                }
                catch (IOException iOException) {
                    MainFrame.this.logger.log(Level.SEVERE, "Failure reading input MSA file:\n" + iOException.getMessage());
                    return;
                }
                MainFrame.this.input.setText(stringBuffer.toString());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ((TitledBorder)MainFrame.this.inputPanel.getBorder()).setTitle("Input - " + MainFrame.this.inputFile.getName());
                        MainFrame.this.inputPanel.repaint();
                        MainFrame.this.inputScroll.getVerticalScrollBar().setValue(0);
                        MainFrame.this.inputScroll.getHorizontalScrollBar().setValue(0);
                    }
                });
                MainFrame.this.logger.log(Level.INFO, "MSA loaded from " + MainFrame.this.inputFile.getAbsolutePath() + ".");
            }
        }
    }

    private class HelpAction
    extends AbstractAction {
        public HelpAction(String string, ImageIcon imageIcon, String string2, Integer n) {
            super(string, imageIcon);
            this.putValue("ShortDescription", string2);
            this.putValue("MnemonicKey", n);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JFrame jFrame = new JFrame("ALTER Help");
            jFrame.setLocationByPlatform(true);
            HelpPanel helpPanel = new HelpPanel();
            jFrame.add(helpPanel);
            jFrame.pack();
            jFrame.setVisible(true);
            helpPanel.scrollUp();
        }
    }

    private class AboutAction
    extends AbstractAction {
        public AboutAction(String string, ImageIcon imageIcon, String string2, Integer n) {
            super(string, imageIcon);
            this.putValue("ShortDescription", string2);
            this.putValue("MnemonicKey", n);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JOptionPane.showMessageDialog(new JFrame(), "ALTER (ALlignment Transformation EnviRonment)\nDeveloped by Daniel Gomez Blanco\n\nEmail: nanodgb@gmail.com\n", "About ALTER", -1);
        }
    }
}

