/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.args4j;

import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.ExampleMode;
import org.kohsuke.args4j.FieldSetter;
import org.kohsuke.args4j.IllegalAnnotationError;
import org.kohsuke.args4j.MapSetter;
import org.kohsuke.args4j.Messages;
import org.kohsuke.args4j.MethodSetter;
import org.kohsuke.args4j.MultiValueFieldSetter;
import org.kohsuke.args4j.NamedOptionDef;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.spi.BooleanOptionHandler;
import org.kohsuke.args4j.spi.ByteOptionHandler;
import org.kohsuke.args4j.spi.CharOptionHandler;
import org.kohsuke.args4j.spi.DoubleOptionHandler;
import org.kohsuke.args4j.spi.EnumOptionHandler;
import org.kohsuke.args4j.spi.FileOptionHandler;
import org.kohsuke.args4j.spi.FloatOptionHandler;
import org.kohsuke.args4j.spi.IntOptionHandler;
import org.kohsuke.args4j.spi.LongOptionHandler;
import org.kohsuke.args4j.spi.MapOptionHandler;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Parameters;
import org.kohsuke.args4j.spi.Setter;
import org.kohsuke.args4j.spi.ShortOptionHandler;
import org.kohsuke.args4j.spi.StringOptionHandler;

public class CmdLineParser {
    private final Object bean;
    private final List<OptionHandler> options = new ArrayList<OptionHandler>();
    private final List<OptionHandler> arguments = new ArrayList<OptionHandler>();
    private boolean parsingOptions = true;
    private OptionHandler currentOptionHandler = null;
    private int usageWidth = 80;
    private static final Map<Class, Constructor<? extends OptionHandler>> handlerClasses = Collections.synchronizedMap(new HashMap());

    public CmdLineParser(Object object) {
        this.bean = object;
        for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Argument argument;
            Option option;
            for (Method method : clazz.getDeclaredMethods()) {
                option = method.getAnnotation(Option.class);
                if (option != null) {
                    this.addOption(new MethodSetter(object, method), option);
                }
                if ((argument = method.getAnnotation(Argument.class)) == null) continue;
                this.addArgument(new MethodSetter(object, method), argument);
            }
            for (AccessibleObject accessibleObject : clazz.getDeclaredFields()) {
                option = ((Field)accessibleObject).getAnnotation(Option.class);
                if (option != null) {
                    this.addOption(this.createFieldSetter((Field)accessibleObject), option);
                }
                if ((argument = ((Field)accessibleObject).getAnnotation(Argument.class)) == null) continue;
                this.addArgument(this.createFieldSetter((Field)accessibleObject), argument);
            }
        }
        for (int i = 0; i < this.arguments.size(); ++i) {
            if (this.arguments.get(i) != null) continue;
            throw new IllegalAnnotationError("No argument annotation for index " + i);
        }
        Collections.sort(this.options, new Comparator<OptionHandler>(){

            @Override
            public int compare(OptionHandler optionHandler, OptionHandler optionHandler2) {
                return optionHandler.option.toString().compareTo(optionHandler2.option.toString());
            }
        });
    }

    private Setter createFieldSetter(Field field) {
        if (List.class.isAssignableFrom(field.getType())) {
            return new MultiValueFieldSetter(this.bean, field);
        }
        if (Map.class.isAssignableFrom(field.getType())) {
            return new MapSetter(this.bean, field);
        }
        return new FieldSetter(this.bean, field);
    }

    private void addArgument(Setter setter, Argument argument) {
        OptionHandler optionHandler = this.createOptionHandler(new OptionDef(argument, setter.isMultiValued()), setter);
        int n = argument.index();
        while (n >= this.arguments.size()) {
            this.arguments.add(null);
        }
        if (this.arguments.get(n) != null) {
            throw new IllegalAnnotationError("Argument with index " + n + " is used more than once");
        }
        this.arguments.set(n, optionHandler);
    }

    private void addOption(Setter setter, Option option) {
        OptionHandler optionHandler = this.createOptionHandler(new NamedOptionDef(option, setter.isMultiValued()), setter);
        this.checkOptionNotInMap(option.name());
        for (String string : option.aliases()) {
            this.checkOptionNotInMap(string);
        }
        this.options.add(optionHandler);
    }

    private void checkOptionNotInMap(String string) throws IllegalAnnotationError {
        if (this.findOptionByName(string) != null) {
            throw new IllegalAnnotationError("Option name " + string + " is used more than once");
        }
    }

    protected OptionHandler createOptionHandler(OptionDef optionDef, Setter setter) {
        Constructor<? extends OptionHandler> constructor;
        Class<? extends OptionHandler> clazz = optionDef.handler();
        if (clazz == OptionHandler.class) {
            Class clazz2 = setter.getType();
            if (Enum.class.isAssignableFrom(clazz2)) {
                return new EnumOptionHandler(this, optionDef, setter, clazz2);
            }
            constructor = handlerClasses.get(clazz2);
            if (constructor == null) {
                throw new IllegalAnnotationError("No OptionHandler is registered to handle " + clazz2);
            }
        } else {
            constructor = CmdLineParser.getConstructor(clazz);
        }
        try {
            return constructor.newInstance(this, optionDef, setter);
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalAnnotationError(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalAnnotationError(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IllegalAnnotationError(invocationTargetException);
        }
    }

    public String printExample(ExampleMode exampleMode) {
        return this.printExample(exampleMode, null);
    }

    public String printExample(ExampleMode exampleMode, ResourceBundle resourceBundle) {
        StringBuilder stringBuilder = new StringBuilder();
        for (OptionHandler optionHandler : this.options) {
            OptionDef optionDef = optionHandler.option;
            if (optionDef.usage().length() == 0 || !exampleMode.print(optionDef)) continue;
            stringBuilder.append(' ');
            stringBuilder.append(optionHandler.getNameAndMeta(resourceBundle));
        }
        return stringBuilder.toString();
    }

    public void printUsage(OutputStream outputStream) {
        this.printUsage(new OutputStreamWriter(outputStream), null);
    }

    public void printUsage(Writer writer, ResourceBundle resourceBundle) {
        int n;
        PrintWriter printWriter = new PrintWriter(writer);
        int n2 = 0;
        for (OptionHandler optionHandler : this.arguments) {
            n = this.getPrefixLen(optionHandler, resourceBundle);
            n2 = Math.max(n2, n);
        }
        for (OptionHandler optionHandler : this.options) {
            n = this.getPrefixLen(optionHandler, resourceBundle);
            n2 = Math.max(n2, n);
        }
        for (OptionHandler optionHandler : this.arguments) {
            this.printOption(printWriter, optionHandler, n2, resourceBundle);
        }
        for (OptionHandler optionHandler : this.options) {
            this.printOption(printWriter, optionHandler, n2, resourceBundle);
        }
        printWriter.flush();
    }

    private void printOption(PrintWriter printWriter, OptionHandler optionHandler, int n, ResourceBundle resourceBundle) {
        int n2;
        int n3 = this.usageWidth - n - 4;
        String string = optionHandler.option.usage();
        if (string.length() == 0) {
            return;
        }
        String string2 = optionHandler.getNameAndMeta(resourceBundle);
        printWriter.print(' ');
        printWriter.print(string2);
        for (n2 = string2.length(); n2 < n; ++n2) {
            printWriter.print(' ');
        }
        printWriter.print(" : ");
        if (resourceBundle != null) {
            string = resourceBundle.getString(string);
        }
        while (string != null && string.length() > 0) {
            n2 = string.indexOf(10);
            if (n2 >= 0 && n2 <= n3) {
                printWriter.println(string.substring(0, n2));
                if ((string = string.substring(n2 + 1)).length() <= 0) continue;
                this.indent(printWriter, n + 4);
                continue;
            }
            if (string.length() <= n3) {
                printWriter.println(string);
                break;
            }
            printWriter.println(string.substring(0, n3));
            string = string.substring(n3);
            this.indent(printWriter, n + 4);
        }
    }

    private int getPrefixLen(OptionHandler optionHandler, ResourceBundle resourceBundle) {
        if (optionHandler.option.usage().length() == 0) {
            return 0;
        }
        return optionHandler.getNameAndMeta(resourceBundle).length();
    }

    private void indent(PrintWriter printWriter, int n) {
        while (n > 0) {
            printWriter.print(' ');
            --n;
        }
    }

    private String getOptionName() {
        return this.currentOptionHandler.option.toString();
    }

    public void parseArgument(String ... stringArray) throws CmdLineException {
        CmdLineImpl cmdLineImpl = new CmdLineImpl(stringArray);
        HashSet<OptionHandler> hashSet = new HashSet<OptionHandler>();
        int n = 0;
        while (cmdLineImpl.hasMore()) {
            int n2;
            String string = cmdLineImpl.getCurrentToken();
            if (this.isOption(string)) {
                n2 = string.indexOf(61) != -1 ? 1 : 0;
                OptionHandler optionHandler = this.currentOptionHandler = n2 != 0 ? this.findOptionHandler(string) : this.findOptionByName(string);
                if (this.currentOptionHandler == null) {
                    throw new CmdLineException(Messages.UNDEFINED_OPTION.format(string));
                }
                cmdLineImpl.proceed(1);
            } else {
                if (n >= this.arguments.size()) {
                    Messages messages = this.arguments.size() == 0 ? Messages.NO_ARGUMENT_ALLOWED : Messages.TOO_MANY_ARGUMENTS;
                    throw new CmdLineException(messages.format(string));
                }
                this.currentOptionHandler = this.arguments.get(n);
                if (!this.currentOptionHandler.option.isMultiValued()) {
                    ++n;
                }
            }
            n2 = this.currentOptionHandler.parseArguments(cmdLineImpl);
            cmdLineImpl.proceed(n2);
            hashSet.add(this.currentOptionHandler);
        }
        for (OptionHandler optionHandler : this.options) {
            if (!optionHandler.option.required() || hashSet.contains(optionHandler)) continue;
            throw new CmdLineException(Messages.REQUIRED_OPTION_MISSING.format(optionHandler.option.toString()));
        }
        for (OptionHandler optionHandler : this.arguments) {
            if (!optionHandler.option.required() || hashSet.contains(optionHandler)) continue;
            throw new CmdLineException(Messages.REQUIRED_ARGUMENT_MISSING.format(optionHandler.option.toString()));
        }
    }

    private OptionHandler findOptionHandler(String string) {
        OptionHandler optionHandler = this.findOptionByName(string);
        if (optionHandler == null) {
            for (int i = string.length(); i > 1; --i) {
                String string2 = string.substring(0, i);
                Map<String, OptionHandler> map = this.filter(this.options, string2);
                optionHandler = map.get(string2);
                if (optionHandler == null) continue;
                return optionHandler;
            }
        }
        return optionHandler;
    }

    private OptionHandler findOptionByName(String string) {
        for (OptionHandler optionHandler : this.options) {
            NamedOptionDef namedOptionDef = (NamedOptionDef)optionHandler.option;
            if (string.equals(namedOptionDef.name())) {
                return optionHandler;
            }
            for (String string2 : namedOptionDef.aliases()) {
                if (!string.equals(string2)) continue;
                return optionHandler;
            }
        }
        return null;
    }

    private Map<String, OptionHandler> filter(List<OptionHandler> list, String string) {
        TreeMap<String, OptionHandler> treeMap = new TreeMap<String, OptionHandler>();
        for (OptionHandler optionHandler : list) {
            if (!list.toString().startsWith(string)) continue;
            treeMap.put(list.toString(), optionHandler);
        }
        return treeMap;
    }

    protected boolean isOption(String string) {
        return this.parsingOptions && string.startsWith("-");
    }

    public static void registerHandler(Class clazz, Class<? extends OptionHandler> clazz2) {
        if (clazz == null || clazz2 == null) {
            throw new IllegalArgumentException();
        }
        if (!OptionHandler.class.isAssignableFrom(clazz2)) {
            throw new IllegalArgumentException("Not an OptionHandler class");
        }
        Constructor<? extends OptionHandler> constructor = CmdLineParser.getConstructor(clazz2);
        handlerClasses.put(clazz, constructor);
    }

    private static Constructor<? extends OptionHandler> getConstructor(Class<? extends OptionHandler> clazz) {
        try {
            return clazz.getConstructor(CmdLineParser.class, OptionDef.class, Setter.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException(clazz + " does not have the proper constructor");
        }
    }

    public void setUsageWidth(int n) {
        this.usageWidth = n;
    }

    public void stopOptionParsing() {
        this.parsingOptions = false;
    }

    public void printSingleLineUsage(OutputStream outputStream) {
        this.printSingleLineUsage(new OutputStreamWriter(outputStream), null);
    }

    public void printSingleLineUsage(Writer writer, ResourceBundle resourceBundle) {
        PrintWriter printWriter = new PrintWriter(writer);
        for (OptionHandler optionHandler : this.arguments) {
            this.printSingleLineOption(printWriter, optionHandler, resourceBundle);
        }
        for (OptionHandler optionHandler : this.options) {
            this.printSingleLineOption(printWriter, optionHandler, resourceBundle);
        }
        printWriter.flush();
    }

    private void printSingleLineOption(PrintWriter printWriter, OptionHandler optionHandler, ResourceBundle resourceBundle) {
        printWriter.print(' ');
        if (!optionHandler.option.required()) {
            printWriter.print('[');
        }
        printWriter.print(optionHandler.getNameAndMeta(resourceBundle));
        if (optionHandler.option.isMultiValued()) {
            printWriter.print(" ...");
        }
        if (!optionHandler.option.required()) {
            printWriter.print(']');
        }
    }

    static {
        CmdLineParser.registerHandler(Boolean.class, BooleanOptionHandler.class);
        CmdLineParser.registerHandler(Boolean.TYPE, BooleanOptionHandler.class);
        CmdLineParser.registerHandler(File.class, FileOptionHandler.class);
        CmdLineParser.registerHandler(Integer.class, IntOptionHandler.class);
        CmdLineParser.registerHandler(Integer.TYPE, IntOptionHandler.class);
        CmdLineParser.registerHandler(Double.class, DoubleOptionHandler.class);
        CmdLineParser.registerHandler(Double.TYPE, DoubleOptionHandler.class);
        CmdLineParser.registerHandler(String.class, StringOptionHandler.class);
        CmdLineParser.registerHandler(Byte.class, ByteOptionHandler.class);
        CmdLineParser.registerHandler(Byte.TYPE, ByteOptionHandler.class);
        CmdLineParser.registerHandler(Character.class, CharOptionHandler.class);
        CmdLineParser.registerHandler(Character.TYPE, CharOptionHandler.class);
        CmdLineParser.registerHandler(Float.class, FloatOptionHandler.class);
        CmdLineParser.registerHandler(Float.TYPE, FloatOptionHandler.class);
        CmdLineParser.registerHandler(Long.class, LongOptionHandler.class);
        CmdLineParser.registerHandler(Long.TYPE, LongOptionHandler.class);
        CmdLineParser.registerHandler(Short.class, ShortOptionHandler.class);
        CmdLineParser.registerHandler(Short.TYPE, ShortOptionHandler.class);
        CmdLineParser.registerHandler(Map.class, MapOptionHandler.class);
    }

    private class CmdLineImpl
    implements Parameters {
        private final String[] args;
        private int pos;

        CmdLineImpl(String[] stringArray) {
            this.args = stringArray;
            this.pos = 0;
        }

        protected boolean hasMore() {
            return this.pos < this.args.length;
        }

        protected String getCurrentToken() {
            return this.args[this.pos];
        }

        private void proceed(int n) {
            this.pos += n;
        }

        @Override
        public String getParameter(int n) throws CmdLineException {
            if (this.pos + n >= this.args.length) {
                throw new CmdLineException(Messages.MISSING_OPERAND.format(CmdLineParser.this.getOptionName()));
            }
            return this.args[this.pos + n];
        }
    }
}

