/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.args4j;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.IllegalAnnotationError;
import org.kohsuke.args4j.Messages;
import org.kohsuke.args4j.spi.Setter;

final class MethodSetter
implements Setter {
    private final Object bean;
    private final Method m;

    public MethodSetter(Object object, Method method) {
        this.bean = object;
        this.m = method;
        if (method.getParameterTypes().length != 1) {
            throw new IllegalAnnotationError(Messages.ILLEGAL_METHOD_SIGNATURE.format(method));
        }
    }

    public Class getType() {
        return this.m.getParameterTypes()[0];
    }

    @Override
    public boolean isMultiValued() {
        return false;
    }

    public void addValue(Object object) throws CmdLineException {
        try {
            try {
                this.m.invoke(this.bean, object);
            }
            catch (IllegalAccessException illegalAccessException) {
                this.m.setAccessible(true);
                try {
                    this.m.invoke(this.bean, object);
                }
                catch (IllegalAccessException illegalAccessException2) {
                    throw new IllegalAccessError(illegalAccessException2.getMessage());
                }
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            if (throwable instanceof CmdLineException) {
                throw (CmdLineException)throwable;
            }
            if (throwable != null) {
                throw new CmdLineException(throwable);
            }
            throw new CmdLineException(invocationTargetException);
        }
    }
}

