/*
 * Decompiled with CFR 0.152.
 */
package reader;

import java.util.logging.Level;
import java.util.logging.Logger;
import parser.AlnParser;
import parser.ParseException;
import reader.Reader;
import reader.ReaderUtils;
import types.Aln;
import types.MSA;
import types.Sequence;

public class AlnReader
implements Reader {
    Logger logger;

    public AlnReader(String string) {
        this.logger = Logger.getLogger(string);
    }

    @Override
    public MSA read(String string) throws ParseException {
        Aln aln = AlnParser.parseMSA(string);
        Sequence sequence = (Sequence)aln.getSeqs().elementAt(0);
        for (int i = 0; i < aln.getSeqs().size(); ++i) {
            Sequence sequence2 = (Sequence)aln.getSeqs().elementAt(i);
            if (sequence2.getData().length() != sequence.getData().length()) {
                throw new ParseException("Sequence lengths are not equal.");
            }
            ReaderUtils.replaceMatch(sequence2, sequence);
        }
        this.logger.log(Level.INFO, "MSA read in ALN format (Taxa = " + aln.getSeqs().size() + ", " + "Length =  " + ((Sequence)aln.getSeqs().elementAt(0)).getData().length() + ").");
        return aln;
    }
}

