/*
 * Decompiled with CFR 0.152.
 */
package reader;

import java.util.logging.Level;
import java.util.logging.Logger;
import parser.NexusParser;
import parser.ParseException;
import reader.Reader;
import reader.ReaderUtils;
import types.MSA;
import types.Nexus;
import types.Sequence;

public class NexusReader
implements Reader {
    Logger logger;

    public NexusReader(String string) {
        this.logger = Logger.getLogger(string);
    }

    @Override
    public MSA read(String string) throws ParseException {
        Nexus nexus = NexusParser.parseMSA(string);
        if (nexus.getSeqs().size() != nexus.getTaxa()) {
            throw new ParseException("Number of sequences is not equal to the given number.");
        }
        Sequence sequence = (Sequence)nexus.getSeqs().elementAt(0);
        for (int i = 0; i < nexus.getSeqs().size(); ++i) {
            Sequence sequence2 = (Sequence)nexus.getSeqs().elementAt(i);
            if (sequence2.getData().length() != nexus.getLength()) {
                throw new ParseException("Sequence lengths are not equal to the given length.");
            }
            ReaderUtils.replaceMatch(sequence2, sequence);
        }
        this.logger.log(Level.INFO, "MSA read in NEXUS format (Taxa = " + nexus.getSeqs().size() + ", " + "Length =  " + ((Sequence)nexus.getSeqs().elementAt(0)).getData().length() + ").");
        return nexus;
    }
}

