/*
 * Decompiled with CFR 0.152.
 */
package reader;

import java.util.logging.Level;
import java.util.logging.Logger;
import parser.ParseException;
import parser.PhylipParser;
import reader.Reader;
import reader.ReaderUtils;
import types.MSA;
import types.Phylip;
import types.Sequence;

public class PhylipReader
implements Reader {
    Logger logger;

    public PhylipReader(String string) {
        this.logger = Logger.getLogger(string);
    }

    @Override
    public MSA read(String string) throws ParseException {
        Phylip phylip = PhylipParser.parseMSA(string);
        if (phylip.getSeqs().size() != phylip.getTaxa()) {
            throw new ParseException("Number of sequences is not equal to the given number.");
        }
        Sequence sequence = (Sequence)phylip.getSeqs().elementAt(0);
        for (int i = 0; i < phylip.getSeqs().size(); ++i) {
            Sequence sequence2 = (Sequence)phylip.getSeqs().elementAt(i);
            if (sequence2.getData().length() != phylip.getLength()) {
                throw new ParseException("Sequence lengths are not equal to the given length.");
            }
            ReaderUtils.replaceMatch(sequence2, sequence);
        }
        this.logger.log(Level.INFO, "MSA read in PHYLIP format (Taxa = " + phylip.getSeqs().size() + ", " + "Length =  " + ((Sequence)phylip.getSeqs().elementAt(0)).getData().length() + ").");
        return phylip;
    }
}

