/*
 * Decompiled with CFR 0.152.
 */
package types;

import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import types.DNA;
import types.Lengthable;
import types.MSA;
import types.NexusSequence;
import types.Nucleotide;
import types.Protein;
import types.RNA;
import types.Sequence;
import types.Taxable;
import types.Type;
import types.Typeable;

public class Nexus
extends MSA
implements Lengthable,
Typeable,
Taxable {
    private int taxa;
    private int length;
    private Type type;

    public Nexus(int n, int n2, String string, Vector<NexusSequence> vector) {
        super(vector);
        this.taxa = n;
        this.length = n2;
        this.type = string.equals("PROTEIN") ? new Protein() : (string.equals("NUCLEOTIDE") ? new Nucleotide() : (string.equals("DNA") ? new DNA() : (string.equals("RNA") ? new RNA() : null)));
    }

    public Nexus(int n, int n2, Type type, Vector<NexusSequence> vector) {
        super(vector);
        this.taxa = n;
        this.length = n2;
        this.type = type;
    }

    @Override
    public int getTaxa() {
        return this.taxa;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public MSA collapse(boolean bl, boolean bl2, int n, String string) {
        Logger logger = Logger.getLogger(string);
        Vector<NexusSequence> vector = new Vector<NexusSequence>();
        vector.add((NexusSequence)this.seqs.firstElement());
        for (int i = 1; i < this.seqs.size(); ++i) {
            NexusSequence nexusSequence = (NexusSequence)this.seqs.elementAt(i);
            Sequence sequence = this.isUnique(nexusSequence, vector, bl, bl2, n);
            if (sequence != null) {
                logger.log(Level.INFO, "Sequence \"" + nexusSequence.getId() + "\" is equal" + " to sequence \"" + sequence.getId() + "\". Sequence removed.");
                continue;
            }
            vector.add(nexusSequence);
        }
        return new Nexus(vector.size(), this.length, this.type, vector);
    }
}

