/*
 * Decompiled with CFR 0.152.
 */
package writer;

import java.util.LinkedHashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import types.Describable;
import types.MSA;
import types.Nucleotide;
import types.Sequence;
import types.Type;
import types.Typeable;
import writer.Writer;
import writer.WriterUtils;

public class GdeWriter
implements Writer {
    String nl;
    boolean lowerCase;
    boolean match;
    Logger logger;

    public GdeWriter(String string, boolean bl, boolean bl2, String string2) {
        this.nl = string.equals("macos") ? "\r" : (string.equals("linux") ? "\n" : "\r\n");
        this.lowerCase = bl;
        this.match = bl2;
        this.logger = Logger.getLogger(string2);
    }

    @Override
    public String write(MSA mSA) {
        StringBuffer stringBuffer = new StringBuffer(10000);
        char c = this.getStart(mSA);
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(mSA.getSeqs().size());
        for (int i = 0; i < mSA.getSeqs().size(); ++i) {
            Sequence sequence = (Sequence)mSA.getSeqs().elementAt(i);
            String string = this.getId(sequence, linkedHashSet);
            linkedHashSet.add(string);
            String string2 = this.getData(sequence, (Sequence)mSA.getSeqs().firstElement());
            stringBuffer.append(this.writeSequence(string, string2, c));
        }
        this.logger.log(Level.INFO, "MSA successfully converted to GDE format!");
        return stringBuffer.toString();
    }

    protected String getId(Sequence sequence, LinkedHashSet<String> linkedHashSet) {
        String string = sequence.getId();
        if (sequence instanceof Describable) {
            string = string + " " + ((Describable)((Object)sequence)).getDesc();
        }
        return WriterUtils.getUniqueId(linkedHashSet, string, this.logger.getName());
    }

    protected String getData(Sequence sequence, Sequence sequence2) {
        String string = this.match ? WriterUtils.writeMatch(sequence, sequence2) : sequence.getData();
        if (this.lowerCase) {
            return string.toLowerCase();
        }
        return string;
    }

    protected char getStart(MSA mSA) {
        Type type = null;
        if (mSA instanceof Typeable) {
            type = ((Typeable)((Object)mSA)).getType();
        }
        if (type == null) {
            type = WriterUtils.inferType(mSA);
            if (type instanceof Nucleotide) {
                this.logger.log(Level.INFO, "Nucleotide MSA type inferred.");
            } else {
                this.logger.log(Level.INFO, "Protein MSA type inferred.");
            }
        }
        if (type instanceof Nucleotide) {
            return '#';
        }
        return '%';
    }

    protected String writeSequence(String string, String string2, char c) {
        StringBuffer stringBuffer = new StringBuffer(2000);
        stringBuffer.append(c + string + this.nl);
        while (!string2.isEmpty()) {
            if (string2.length() > 60) {
                stringBuffer.append(string2.substring(0, 60));
                string2 = string2.substring(60);
            } else {
                stringBuffer.append(string2);
                string2 = "";
            }
            stringBuffer.append(this.nl);
        }
        return stringBuffer.toString();
    }
}

