/*
 * Decompiled with CFR 0.152.
 */
package writer;

import java.util.LinkedHashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import types.MSA;
import types.Sequence;
import writer.Writer;
import writer.WriterUtils;

public class MegaWriter
implements Writer {
    String nl;
    boolean lowerCase;
    boolean match;
    Logger logger;

    public MegaWriter(String string, boolean bl, boolean bl2, String string2) {
        this.nl = string.equals("macos") ? "\r" : (string.equals("linux") ? "\n" : "\r\n");
        this.lowerCase = bl;
        this.match = bl2;
        this.logger = Logger.getLogger(string2);
        this.logger.setLevel(Level.ALL);
    }

    @Override
    public String write(MSA mSA) {
        int n;
        StringBuffer stringBuffer = new StringBuffer(10000);
        stringBuffer.append(this.writeHeader());
        String[] stringArray = new String[mSA.getSeqs().size()];
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(mSA.getSeqs().size());
        int n2 = 0;
        for (n = 0; n < mSA.getSeqs().size(); ++n) {
            Sequence sequence = (Sequence)mSA.getSeqs().elementAt(n);
            stringArray[n] = this.getData(sequence, (Sequence)mSA.getSeqs().firstElement());
            String string = this.getId(sequence, linkedHashSet);
            linkedHashSet.add(string);
            if (string.length() <= n2) continue;
            n2 = string.length();
        }
        while (!stringArray[0].isEmpty()) {
            n = 0;
            for (String string : linkedHashSet) {
                stringBuffer.append(this.writeLine(string, n2, stringArray, n));
                ++n;
            }
            stringBuffer.append(this.nl);
        }
        this.logger.log(Level.INFO, "MSA successfully converted to MEGA format!");
        return stringBuffer.toString();
    }

    protected String getId(Sequence sequence, LinkedHashSet<String> linkedHashSet) {
        String string = sequence.getId();
        return WriterUtils.getUniqueId(linkedHashSet, string, this.logger.getName());
    }

    protected String getData(Sequence sequence, Sequence sequence2) {
        String string = this.match ? WriterUtils.writeMatch(sequence, sequence2) : sequence.getData();
        if (this.lowerCase) {
            return string.toLowerCase();
        }
        return string;
    }

    protected String writeHeader() {
        return "#mega" + this.nl + "TITLE: MSA converted with ALTER 1.3" + this.nl + this.nl;
    }

    protected String writeLine(String string, int n, String[] stringArray, int n2) {
        StringBuffer stringBuffer = new StringBuffer(2000);
        stringBuffer.append("#" + string + WriterUtils.align(string.length(), n) + WriterUtils.align(n, 10) + "  ");
        for (int i = 0; i < 5; ++i) {
            if (stringArray[n2].length() > 10) {
                stringBuffer.append(stringArray[n2].substring(0, 10) + " ");
                stringArray[n2] = stringArray[n2].substring(10);
            } else {
                stringBuffer.append(stringArray[n2]);
                stringArray[n2] = "";
            }
            if (stringArray[n2].isEmpty()) break;
        }
        stringBuffer.append(this.nl);
        return stringBuffer.toString();
    }
}

