/*
 * Decompiled with CFR 0.152.
 */
package writer;

import java.util.logging.Level;
import types.MSA;
import types.Protein;
import types.Type;
import types.Typeable;
import writer.PirWriter;
import writer.WriterUtils;

public class PirJModelTestWriter
extends PirWriter {
    public PirJModelTestWriter(String string, boolean bl, boolean bl2, String string2) {
        super(string, bl, bl2, string2);
    }

    @Override
    public String write(MSA mSA) {
        if (mSA.getSeqs().size() < 4) {
            this.logger.log(Level.WARNING, "MSA contains less than 4 sequences. It will not be processed by jModelTest.");
        }
        Type type = null;
        if (mSA instanceof Typeable) {
            type = ((Typeable)((Object)mSA)).getType();
        }
        if (type == null) {
            type = WriterUtils.inferType(mSA);
        }
        if (type instanceof Protein) {
            this.logger.log(Level.WARNING, "MSA is an amino acids MSA. It will not be processed by jModelTest (only DNA is processed).");
        }
        return super.write(mSA);
    }
}

