/*
 * Decompiled with CFR 0.152.
 */
package writer;

import java.util.LinkedHashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import types.DNA;
import types.DNACircular;
import types.DNALinear;
import types.Describable;
import types.MSA;
import types.Nucleotide;
import types.Protein;
import types.ProteinComplete;
import types.ProteinFragment;
import types.RNA;
import types.RNACircular;
import types.RNALinear;
import types.RNAOther;
import types.RNAt;
import types.Sequence;
import types.Type;
import types.Typeable;
import writer.Writer;
import writer.WriterUtils;

public class PirWriter
implements Writer {
    String nl;
    boolean lowerCase;
    boolean match;
    Logger logger;

    public PirWriter(String string, boolean bl, boolean bl2, String string2) {
        this.nl = string.equals("macos") ? "\r" : (string.equals("linux") ? "\n" : "\r\n");
        this.lowerCase = bl;
        this.match = bl2;
        this.logger = Logger.getLogger(string2);
    }

    @Override
    public String write(MSA mSA) {
        StringBuffer stringBuffer = new StringBuffer(10000);
        String string = this.getType(mSA);
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(mSA.getSeqs().size());
        for (int i = 0; i < mSA.getSeqs().size(); ++i) {
            Sequence sequence = (Sequence)mSA.getSeqs().elementAt(i);
            String string2 = this.getId(sequence, linkedHashSet);
            linkedHashSet.add(string2);
            String string3 = this.getData(sequence, (Sequence)mSA.getSeqs().firstElement());
            String string4 = this.getDesc(sequence);
            stringBuffer.append(this.writeSequence(string, string2, string4, string3));
        }
        this.logger.log(Level.INFO, "MSA successfully converted to PIR format!");
        return stringBuffer.toString();
    }

    protected String getId(Sequence sequence, LinkedHashSet<String> linkedHashSet) {
        String string = sequence.getId();
        return WriterUtils.getUniqueId(linkedHashSet, string, this.logger.getName());
    }

    protected String getData(Sequence sequence, Sequence sequence2) {
        String string = this.match ? WriterUtils.writeMatch(sequence, sequence2) : sequence.getData();
        if (this.lowerCase) {
            return string.toLowerCase();
        }
        return string;
    }

    protected String getDesc(Sequence sequence) {
        if (sequence instanceof Describable) {
            return ((Describable)((Object)sequence)).getDesc();
        }
        return "";
    }

    protected String getType(MSA mSA) {
        Type type = null;
        if (mSA instanceof Typeable) {
            type = ((Typeable)((Object)mSA)).getType();
        }
        if (type == null) {
            type = WriterUtils.inferType(mSA);
            if (type instanceof Nucleotide) {
                this.logger.log(Level.INFO, "Nucleotide MSA type inferred.");
            } else {
                this.logger.log(Level.INFO, "Protein MSA type inferred.");
            }
        }
        if (type instanceof Nucleotide) {
            if (type instanceof DNA) {
                if (type instanceof DNALinear) {
                    return "DL";
                }
                if (type instanceof DNACircular) {
                    return "DC";
                }
                return "DL";
            }
            if (type instanceof RNA) {
                if (type instanceof RNALinear) {
                    return "RL";
                }
                if (type instanceof RNACircular) {
                    return "RC";
                }
                if (type instanceof RNAt) {
                    return "N3";
                }
                if (type instanceof RNAOther) {
                    return "N1";
                }
                return "RL";
            }
            return "DL";
        }
        if (type instanceof Protein) {
            if (type instanceof ProteinComplete) {
                return "P1";
            }
            if (type instanceof ProteinFragment) {
                return "F1";
            }
            return "P1";
        }
        return "XX";
    }

    protected String writeSequence(String string, String string2, String string3, String string4) {
        String string5 = "";
        string5 = string5 + ">" + string + ";" + string2 + this.nl;
        string5 = string5 + string3 + this.nl;
        while (string4.length() > 0) {
            if (string4.length() > 60) {
                string5 = string5 + string4.substring(0, 60);
                string4 = string4.substring(60);
            } else {
                string5 = string5 + string4;
                string4 = "";
            }
            string5 = string5 + this.nl;
        }
        string5 = string5 + "*" + this.nl;
        return string5;
    }
}

