/*
 * Decompiled with CFR 0.152.
 */
package writer;

import java.util.LinkedHashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import types.MSA;
import types.Nucleotide;
import types.Protein;
import types.Sequence;
import types.Type;

public class WriterUtils {
    public static String align(int n, int n2) {
        String string = "";
        for (int i = n; i < n2; ++i) {
            string = string.concat(" ");
        }
        return string;
    }

    public static Type inferType(MSA mSA) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < mSA.getSeqs().size(); ++i) {
            String string = ((Sequence)mSA.getSeqs().elementAt(i)).getData();
            for (int j = 0; j < string.length(); ++j) {
                if (string.charAt(j) == '-' || string.charAt(j) == '?') continue;
                ++n;
                if (string.charAt(j) != 'A' && string.charAt(j) != 'C' && string.charAt(j) != 'G' && string.charAt(j) != 'T' && string.charAt(j) != 'U') continue;
                ++n2;
            }
        }
        if (100 * n2 / n >= 85) {
            return new Nucleotide();
        }
        return new Protein();
    }

    public static boolean isIUPAC(MSA mSA, Type type) {
        boolean bl;
        block5: {
            block4: {
                bl = false;
                if (!(type instanceof Protein)) break block4;
                for (int i = 0; i < mSA.getSeqs().size(); ++i) {
                    String string = ((Sequence)mSA.getSeqs().elementAt(i)).getData();
                    for (int j = 0; j < string.length(); ++j) {
                        if (string.charAt(j) != 'B' && string.charAt(j) != 'Z' && string.charAt(j) != 'X') continue;
                        bl = true;
                    }
                }
                break block5;
            }
            if (!(type instanceof Nucleotide)) break block5;
            for (int i = 0; i < mSA.getSeqs().size(); ++i) {
                String string = ((Sequence)mSA.getSeqs().elementAt(i)).getData();
                for (int j = 0; j < string.length(); ++j) {
                    if (string.charAt(j) != 'R' && string.charAt(j) != 'Y' && string.charAt(j) != 'M' && string.charAt(j) != 'K' && string.charAt(j) != 'W' && string.charAt(j) != 'S' && string.charAt(j) != 'B' && string.charAt(j) != 'D' && string.charAt(j) != 'H' && string.charAt(j) != 'V' && string.charAt(j) != 'N') continue;
                    bl = true;
                }
            }
        }
        return bl;
    }

    public static String writeMatch(Sequence sequence, Sequence sequence2) {
        if (sequence != sequence2) {
            StringBuffer stringBuffer = new StringBuffer();
            String string = sequence.getData();
            String string2 = sequence2.getData();
            for (int i = 0; i < string.length(); ++i) {
                if (string2.charAt(i) != '-' && string2.charAt(i) != '?' && string.charAt(i) == string2.charAt(i)) {
                    stringBuffer.append(".");
                    continue;
                }
                stringBuffer.append(string.charAt(i));
            }
            return stringBuffer.toString();
        }
        return sequence.getData();
    }

    public static String getUniqueId(LinkedHashSet<String> linkedHashSet, String string, String string2) {
        String string3 = string;
        int n = 0;
        while (linkedHashSet.contains(string)) {
            int n2 = String.valueOf(n).length();
            string = string.substring(0, string.length() - n2 - 1) + "_" + n;
            ++n;
        }
        if (!string3.equals(string)) {
            Logger.getLogger(string2).log(Level.WARNING, "ID for sequence \"" + string3 + "\" renamed to \"" + string + "\".");
        }
        return string;
    }
}

