/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.jmodeltest;

import es.uvigo.darwin.jmodeltest.ModelTest;
import es.uvigo.darwin.jmodeltest.ModelTestConfiguration;
import es.uvigo.darwin.jmodeltest.ModelTestService;
import es.uvigo.darwin.jmodeltest.exception.AlignmentParseException;
import es.uvigo.darwin.jmodeltest.io.AlignmentReader;
import es.uvigo.darwin.jmodeltest.io.TextOutputStream;
import es.uvigo.darwin.jmodeltest.model.Model;
import es.uvigo.darwin.jmodeltest.model.ModelConstants;
import es.uvigo.darwin.jmodeltest.utilities.Utilities;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.PushbackReader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Vector;
import pal.alignment.Alignment;
import pal.datatype.DataType;
import pal.tree.TreeParseException;

public class ApplicationOptions
implements Serializable {
    private static final long serialVersionUID = -3961572952922591321L;
    private static final int AMBIGUOUS_DATATYPE_STATE = 4;
    private static ApplicationOptions instance;
    private static Vector<String> testOrder;
    private File inputDataFile;
    private File inputTreeFile;
    private File alignmentFile;
    private File treeFile;
    private File ckpFile;
    private File logFile;
    private Alignment alignment;
    private boolean isAmbiguous;
    private boolean forceCheckULnL = false;
    private double unconstrainedLnL = 0.0;
    private int numPatterns = 0;
    private String userTree;
    private int numberOfThreads = Runtime.getRuntime().availableProcessors();
    private File machinesFile;
    public boolean threadScheduling = false;
    public boolean doAIC = false;
    public boolean doAICc = false;
    public boolean doBIC = false;
    public boolean doDT = false;
    public boolean doDLRT = false;
    public boolean doHLRT = false;
    public boolean doF = false;
    public boolean doI = false;
    public boolean doG = false;
    public int numGammaCat = 4;
    public boolean backwardHLRTSelection = false;
    public double confidenceLevelHLRT = 0.01;
    public boolean writePAUPblock = false;
    public boolean doImportances = false;
    public boolean doModelAveraging = false;
    public boolean doAveragedPhylogeny = false;
    public double confidenceInterval = 1.0;
    public boolean doingSimulations = false;
    public String simulationsName = "";
    public boolean userTopologyExists = false;
    public boolean fixedTopology = false;
    public boolean optimizeMLTopology = true;
    public TreeSearch treeSearchOperations = TreeSearch.BEST;
    private double guidedSearchThreshold = 0.0;
    private boolean doClusteringSearch = false;
    private int heuristicInformationCriterion = 3;
    private int numSites;
    private int numTaxa;
    private int numBranches;
    private int numInvariableSites;
    private int numModels;
    private String executionName;
    public String consensusType = "50% majority rule";
    public boolean countBLasParameters = true;
    private int substTypeCode = 0;

    private ApplicationOptions() {
    }

    public void createCkpFile() {
        if (this.ckpFile != null && this.ckpFile.exists()) {
            return;
        }
        try {
            if (this.executionName == null) {
                this.executionName = Utilities.getCurrentTime("yyyyMMddHHmmss");
            }
            if (ModelTestConfiguration.isCkpEnabled() && this.getInputFile() != null) {
                this.ckpFile = new File(ModelTestConfiguration.getLogDir() + File.separator + this.getInputFile().getName() + "." + this.executionName + ".ckp");
            } else {
                this.ckpFile = File.createTempFile("jmodeltest", ".ckp");
                this.ckpFile.deleteOnExit();
            }
        }
        catch (IOException iOException) {
            System.err.println("Error creating checkpointing file");
        }
    }

    public void createLogFile() {
        try {
            if (this.executionName == null) {
                this.executionName = Utilities.getCurrentTime("yyyyMMddHHmmss");
            }
            if (ModelTestConfiguration.isPhymlLogEnabled() && this.getInputFile() != null) {
                this.logFile = new File(ModelTestConfiguration.getLogDir() + File.separator + this.getInputFile().getName() + ".phyml." + this.executionName + ".log");
                if (!this.logFile.canWrite()) {
                    this.logFile = null;
                }
            }
            if (this.logFile == null) {
                this.logFile = File.createTempFile("jmodeltest-phyml", ".log");
                this.logFile.deleteOnExit();
            }
        }
        catch (IOException iOException) {
            System.err.println("Error creating PhyML log file");
        }
    }

    public void deleteLogFile() {
        if (!ModelTestConfiguration.isPhymlLogEnabled()) {
            this.logFile.delete();
        }
    }

    public void buildWorkFiles() throws IOException {
        Closeable closeable;
        Object object;
        File file = this.getAlignmentFile();
        if (!file.exists()) {
            file.createNewFile();
            file.deleteOnExit();
        }
        try {
            object = ModelTestService.readAlignment(this.inputDataFile, this.alignmentFile);
            closeable = new PushbackReader(new StringReader((String)object));
            this.setAlignment(AlignmentReader.createAlignment(new PrintWriter(System.err), (PushbackReader)closeable, true));
        }
        catch (AlignmentParseException alignmentParseException) {
            alignmentParseException.printStackTrace();
        }
        if (this.userTree != null) {
            object = this.getTreeFile();
            if (!((File)object).exists()) {
                ((File)object).createNewFile();
                ((File)object).deleteOnExit();
            }
            closeable = new TextOutputStream(this.getTreeFile().getAbsolutePath());
            ((TextOutputStream)closeable).print(this.getUserTree());
            ((TextOutputStream)closeable).close();
        }
    }

    public static ApplicationOptions getInstance() {
        if (instance == null) {
            instance = new ApplicationOptions();
        }
        return instance;
    }

    public void setCandidateModels() {
        ModelTest.setCandidateModels(new Model[this.getNumModels()]);
        if (this.substTypeCode < 4) {
            int n = 0;
            for (int i = 0; i < 88; ++i) {
                boolean bl = true;
                if (ModelConstants.substType[i] > this.substTypeCode) {
                    bl = false;
                }
                if (!this.doF && !ModelConstants.equalBaseFrequencies[i]) {
                    bl = false;
                }
                if (!(this.doI || ModelConstants.rateVariation[i] != 1 && ModelConstants.rateVariation[i] != 3)) {
                    bl = false;
                }
                if (!(this.doG || ModelConstants.rateVariation[i] != 2 && ModelConstants.rateVariation[i] != 3)) {
                    bl = false;
                }
                if (!bl) continue;
                this.loadModelConstraints(ModelTest.getCandidateModel(n), n, i);
                ++n;
            }
        } else {
            int n = 0;
            for (int i = 1; i <= 6; ++i) {
                for (String string : ModelConstants.fullModelSet.get(i)) {
                    for (int j = 0; j < 8; ++j) {
                        boolean bl = j / 4 == 1;
                        int n2 = j % 4;
                        boolean bl2 = true;
                        if (!this.doF && bl) {
                            bl2 = false;
                        }
                        if (!(this.doI || n2 != 1 && n2 != 3)) {
                            bl2 = false;
                        }
                        if (!(this.doG || n2 != 2 && n2 != 3)) {
                            bl2 = false;
                        }
                        if (!bl2) continue;
                        this.loadModelConstraints(ModelTest.getCandidateModel(n), n, string, bl, n2, i);
                        ++n;
                    }
                }
            }
        }
        if (ModelTest.buildGUI || ModelTest.testingOrder == null) {
            testOrder = new Vector();
            testOrder.removeAllElements();
            if (this.doF) {
                testOrder.add("freq");
            }
            switch (this.substTypeCode) {
                case 0: {
                    testOrder.add("titv");
                    testOrder.add("2ti4tv");
                    break;
                }
                case 1: {
                    testOrder.add("titv");
                    testOrder.add("2ti");
                    testOrder.add("2tv");
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    testOrder.add("titv");
                    testOrder.add("2ti");
                    testOrder.add("2tv");
                    testOrder.add("4tv");
                }
            }
            if (this.doI) {
                testOrder.add("pinv");
            }
            if (this.doG) {
                testOrder.add("gamma");
            }
            ModelTest.testingOrder = testOrder;
        }
    }

    public void loadModelConstraints(Model model, int n, int n2) {
        boolean bl;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = bl = !ModelConstants.equalBaseFrequencies[n2];
        if (ModelConstants.numTransitions[n2] == 1 && ModelConstants.numTransversions[n2] == 1) {
            bl6 = true;
        } else if (ModelConstants.numTransitions[n2] > 1 || ModelConstants.numTransversions[n2] > 1) {
            bl4 = true;
        }
        switch (ModelConstants.rateVariation[n2]) {
            case 1: {
                bl3 = true;
                break;
            }
            case 2: {
                bl2 = true;
                break;
            }
            case 3: {
                bl3 = true;
                bl2 = true;
            }
        }
        int n3 = this.countBLasParameters ? this.getNumBranches() : 0;
        int n4 = this.optimizeMLTopology ? ModelConstants.freeParameters[n2] + n3 + 1 : ModelConstants.freeParameters[n2] + n3;
        ModelTest.getCandidateModels()[n] = new Model(n + 1, ModelConstants.modelName[n2], ModelConstants.modelCode[n2], n4, bl, bl6, bl5, bl4, bl3, bl2, ModelConstants.numTransitions[n2], ModelConstants.numTransversions[n2]);
        if (ModelTest.getLoadedModels() != null && ModelTest.getLoadedModels().length > 0) {
            for (Model model2 : ModelTest.getLoadedModels()) {
                if (!model2.getName().equals(ModelTest.getCandidateModels()[n].getName()) || !(model2.getLnL() > 0.0)) continue;
                Model model3 = ModelTest.getCandidateModels()[n];
                model3.setLnL(model2.getLnL());
                model3.setLnLIgnoringGaps(model2.getLnLIgnoringGaps());
                model3.setShape(model2.getShape());
                model3.setfA(model2.getfA());
                model3.setfC(model2.getfC());
                model3.setfG(model2.getfG());
                model3.setfT(model2.getfT());
                model3.setRa(model2.getRa());
                model3.setRb(model2.getRb());
                model3.setRc(model2.getRc());
                model3.setRd(model2.getRd());
                model3.setRe(model2.getRe());
                model3.setRf(model2.getRf());
                model3.setPinv(model2.getPinv());
                model3.setKappa(model2.getKappa());
                model3.setTitv(model2.getTitv());
                try {
                    model3.setTreeString(model2.getTreeString());
                }
                catch (TreeParseException treeParseException) {
                    treeParseException.printStackTrace();
                }
                model2.setLnL(0.0);
                break;
            }
        }
    }

    public void loadModelConstraints(Model model, int n, String string, boolean bl, int n2, int n3) {
        int n4;
        int n5;
        String string2;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = bl;
        switch (n2) {
            case 1: {
                bl3 = true;
                break;
            }
            case 2: {
                bl2 = true;
                break;
            }
            case 3: {
                bl3 = true;
                bl2 = true;
            }
        }
        int n6 = this.countBLasParameters ? this.getNumBranches() : 0;
        int n7 = n3 - 1 + (bl7 ? 3 : 0) + (bl3 ? 1 : 0) + (bl2 ? 1 : 0) + n6 + (this.optimizeMLTopology ? 1 : 0);
        if (ModelConstants.codeList.contains(string)) {
            int n8 = ModelConstants.codeList.indexOf(string);
            if (bl7) {
                n8 += 4;
            }
            if (bl3) {
                ++n8;
            }
            if (bl2) {
                n8 += 2;
            }
            string2 = ModelConstants.modelName[n8];
            n5 = ModelConstants.numTransitions[n8];
            n4 = ModelConstants.numTransversions[n8];
            if (n5 == 1 && n4 == 1) {
                bl6 = true;
            } else if (n5 > 1 || n4 > 1) {
                bl4 = true;
            }
        } else {
            string2 = string + (bl3 ? "+I" : "") + (bl2 ? "+G" : "") + (bl7 ? "+F" : "");
            n5 = 0;
            n4 = 0;
            bl6 = false;
            bl4 = true;
        }
        ModelTest.getCandidateModels()[n] = new Model(n + 1, string2, string, n7, bl7, bl6, bl5, bl4, bl3, bl2, 0, 0);
        if (ModelTest.getLoadedModels() != null && ModelTest.getLoadedModels().length > 0) {
            for (Model model2 : ModelTest.getLoadedModels()) {
                if (!model2.getName().equals(ModelTest.getCandidateModels()[n].getName()) || !(model2.getLnL() > 0.0)) continue;
                Model model3 = ModelTest.getCandidateModels()[n];
                model3.setLnL(model2.getLnL());
                model3.setLnLIgnoringGaps(model2.getLnLIgnoringGaps());
                model3.setShape(model2.getShape());
                model3.setfA(model2.getfA());
                model3.setfC(model2.getfC());
                model3.setfG(model2.getfG());
                model3.setfT(model2.getfT());
                model3.setRa(model2.getRa());
                model3.setRb(model2.getRb());
                model3.setRc(model2.getRc());
                model3.setRd(model2.getRd());
                model3.setRe(model2.getRe());
                model3.setRf(model2.getRf());
                model3.setPinv(model2.getPinv());
                model3.setKappa(model2.getKappa());
                model3.setTitv(model2.getTitv());
                try {
                    model3.setTreeString(model2.getTreeString());
                }
                catch (TreeParseException treeParseException) {
                    treeParseException.printStackTrace();
                }
                model2.setLnL(0.0);
                break;
            }
        }
    }

    public File getInputFile() {
        return this.inputDataFile;
    }

    public File getInputTreeFile() {
        return this.inputTreeFile;
    }

    public void setInputFile(File file) {
        this.inputDataFile = file;
    }

    public void setInputTreeFile(File file) {
        this.inputTreeFile = file;
    }

    public File getAlignmentFile() {
        if (this.alignmentFile == null) {
            try {
                this.alignmentFile = File.createTempFile("jmodeltest", ".phy");
                this.alignmentFile.deleteOnExit();
            }
            catch (IOException iOException) {
                this.alignmentFile = this.inputDataFile;
            }
        }
        return this.alignmentFile;
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    public void setAlignment(Alignment alignment) {
        this.alignment = alignment;
        this.setNumTaxa(alignment.getSequenceCount());
        this.setNumSites(alignment.getSiteCount());
        this.setNumBranches(2 * this.numTaxa - 3);
        this.setNumInvariableSites(Utilities.calculateInvariableSites(alignment));
        DataType dataType = alignment.getDataType();
        this.isAmbiguous = false;
        if (alignment.getDataType().isAmbiguous()) {
            this.isAmbiguous = true;
        } else {
            block0: for (int i = 0; i < this.numTaxa; ++i) {
                String string = alignment.getAlignedSequenceString(i);
                if (string.indexOf(45) >= 0) {
                    this.isAmbiguous = true;
                    break;
                }
                for (int j = 0; j < string.length(); ++j) {
                    if (dataType.getState(string.charAt(j)) != 4) continue;
                    this.isAmbiguous = true;
                    continue block0;
                }
            }
        }
    }

    public boolean isForceCheckULnL() {
        return this.forceCheckULnL;
    }

    public void setForceCheckULnL(boolean bl) {
        this.forceCheckULnL = bl;
    }

    public double getUnconstrainedLnL() {
        return this.unconstrainedLnL;
    }

    public void setUnconstrainedLnL(double d) {
        this.unconstrainedLnL = d;
    }

    public int getNumPatterns() {
        return this.numPatterns;
    }

    public void setNumPatterns(int n) {
        this.numPatterns = n;
    }

    public boolean isAmbiguous() {
        return this.isAmbiguous;
    }

    public String getExecutionName() {
        return this.executionName;
    }

    public void setExecutionName(String string) {
        this.executionName = string;
    }

    public File getTreeFile() {
        if (this.treeFile == null) {
            try {
                this.treeFile = File.createTempFile("jmodeltest", ".tree");
                this.treeFile.deleteOnExit();
            }
            catch (IOException iOException) {
                this.treeFile = this.inputTreeFile;
            }
        }
        return this.treeFile;
    }

    public File getCkpFile() {
        return this.ckpFile;
    }

    public File getLogFile() {
        return this.logFile;
    }

    public String getUserTree() {
        return this.userTree;
    }

    public void setUserTree(String string) {
        this.userTree = string;
    }

    public void setSubstTypeCode(int n) {
        this.substTypeCode = n;
        this.doClusteringSearch = n == 4;
    }

    public int getSubstTypeCode() {
        return this.substTypeCode;
    }

    public double getSampleSize() {
        return this.numSites;
    }

    public static void setInstance(ApplicationOptions applicationOptions) {
        File file = ApplicationOptions.instance.alignmentFile;
        File file2 = ApplicationOptions.instance.treeFile;
        instance = applicationOptions;
        ApplicationOptions.instance.alignmentFile = file;
        ApplicationOptions.instance.treeFile = file2;
    }

    public int getNumberOfThreads() {
        return this.numberOfThreads;
    }

    public void setNumberOfThreads(int n) {
        this.numberOfThreads = n;
    }

    public boolean isGuidedSearch() {
        return this.guidedSearchThreshold > 1.0E-6;
    }

    public double getGuidedSearchThreshold() {
        return this.guidedSearchThreshold;
    }

    public void setGuidedSearchThreshold(double d) {
        this.guidedSearchThreshold = d;
    }

    public void setMachinesFile(File file) throws FileNotFoundException {
        if (ModelTest.HOSTS_TABLE.containsKey(ModelTest.getHostname())) {
            this.setNumberOfThreads(ModelTest.HOSTS_TABLE.get(ModelTest.getHostname()));
        } else {
            System.err.println("");
            System.err.println("WARNING: Machines File format is wrong.");
            System.err.println("         This host: " + ModelTest.getHostname() + " does not exist");
            System.err.println("         Using a single thread");
            System.err.println("");
            this.numberOfThreads = 1;
        }
    }

    public File getMachinesFile() {
        return this.machinesFile;
    }

    public boolean isClusteringSearch() {
        return this.doClusteringSearch;
    }

    public void setClusteringSearch(boolean bl) {
        this.doClusteringSearch = bl;
    }

    public int getHeuristicInformationCriterion() {
        return this.heuristicInformationCriterion;
    }

    public void setHeuristicInformationCriterion(int n) {
        this.heuristicInformationCriterion = n;
    }

    public int getNumSites() {
        return this.numSites;
    }

    public void setNumSites(int n) {
        this.numSites = n;
    }

    public int getNumTaxa() {
        return this.numTaxa;
    }

    public void setNumTaxa(int n) {
        this.numTaxa = n;
    }

    public int getNumBranches() {
        return this.numBranches;
    }

    public void setNumBranches(int n) {
        this.numBranches = n;
    }

    public int getNumInvariableSites() {
        return this.numInvariableSites;
    }

    public void setNumInvariableSites(int n) {
        this.numInvariableSites = n;
    }

    public int getNumModels() {
        return this.numModels;
    }

    public void setNumModels(int n) {
        this.numModels = n;
    }

    public static enum TreeSearch {
        NNI,
        SPR,
        BEST;

    }
}

