/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.jmodeltest;

import es.uvigo.darwin.jmodeltest.ApplicationOptions;
import es.uvigo.darwin.jmodeltest.InvalidArgumentException;
import es.uvigo.darwin.jmodeltest.ModelTestConfiguration;
import es.uvigo.darwin.jmodeltest.ModelTestService;
import es.uvigo.darwin.jmodeltest.WeakStateException;
import es.uvigo.darwin.jmodeltest.exe.RunConsense;
import es.uvigo.darwin.jmodeltest.exe.RunPhyml;
import es.uvigo.darwin.jmodeltest.exe.RunPhymlHybrid;
import es.uvigo.darwin.jmodeltest.exe.RunPhymlMPJ;
import es.uvigo.darwin.jmodeltest.exe.RunPhymlThread;
import es.uvigo.darwin.jmodeltest.gui.XManager;
import es.uvigo.darwin.jmodeltest.io.AlignmentReader;
import es.uvigo.darwin.jmodeltest.io.HtmlReporter;
import es.uvigo.darwin.jmodeltest.io.TextInputStream;
import es.uvigo.darwin.jmodeltest.io.TextOutputStream;
import es.uvigo.darwin.jmodeltest.model.Model;
import es.uvigo.darwin.jmodeltest.observer.ConsoleProgressObserver;
import es.uvigo.darwin.jmodeltest.selection.AIC;
import es.uvigo.darwin.jmodeltest.selection.AICc;
import es.uvigo.darwin.jmodeltest.selection.BIC;
import es.uvigo.darwin.jmodeltest.selection.DT;
import es.uvigo.darwin.jmodeltest.selection.HLRT;
import es.uvigo.darwin.jmodeltest.selection.InformationCriterion;
import es.uvigo.darwin.jmodeltest.tree.TreeSummary;
import es.uvigo.darwin.jmodeltest.tree.TreeUtilities;
import es.uvigo.darwin.jmodeltest.utilities.Simulation;
import es.uvigo.darwin.jmodeltest.utilities.Utilities;
import java.awt.GraphicsEnvironment;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.PushbackReader;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import mpi.MPI;
import mpi.MPIException;
import pal.tree.Tree;
import pal.tree.TreeParseException;

public class ModelTest {
    private ApplicationOptions options = ApplicationOptions.getInstance();
    public static int MPJ_ME;
    public static int MPJ_SIZE;
    public static boolean MPJ_RUN;
    public static final Properties USERDEF_PROPERTIES;
    public static final int PRECISION = 4;
    public static final double INFINITY = 9999.0;
    public static final int MAX_NUM_MODELS = 88;
    public static final int MAX_NAME = 60;
    public static final String CURRENT_VERSION = "2.1.10 v20160303";
    public static final String programName = "jModeltest";
    public static final String URL = "https://github.com/ddarriba/jmodeltest2";
    public static final String WIKI = "https://github.com/ddarriba/jmodeltest2";
    public static final String DISCUSSION_GROUP = "http://groups.google.com/group/jmodeltest";
    public static String CONFIG_FILE;
    public static final String UNKNOWN_HOSTNAME = "UNKNOWN";
    private static TextOutputStream MAIN_CONSOLE;
    private static TextOutputStream PHYML_CONSOLE;
    private static TextOutputStream CURRENT_OUT_STREAM;
    public static String[] arguments;
    private static boolean AICwasCalculated;
    private static boolean AICcwasCalculated;
    private static boolean BICwasCalculated;
    private static boolean DTwasCalculated;
    public static Vector<String> testingOrder;
    public static String averagedTreeString;
    public static ExecMode execMode;
    private static AIC myAIC;
    private static AICc myAICc;
    private static BIC myBIC;
    private static DT myDT;
    private static HLRT myHLRT;
    private static RunConsense consensusAIC;
    private static RunConsense consensusAICc;
    private static RunConsense consensusBIC;
    private static RunConsense consensusDT;
    private static Model[] candidateModels;
    private static Model[] loadedModels;
    private static Model minAIC;
    private static Model minAICc;
    private static Model minBIC;
    private static Model minDT;
    private static Model minHLRT;
    private static Model minDLRT;
    private static String hostname;
    public static Hashtable<String, Integer> HOSTS_TABLE;
    public static boolean buildGUI;

    public ModelTest() {
        if (!GraphicsEnvironment.isHeadless()) {
            this.options.createLogFile();
            execMode = ExecMode.GUI;
            XManager.getInstance();
            RunPhyml.checkBinary();
        } else {
            System.err.println("");
            System.err.println("ERROR: You are trying to run a GUI interface in a headless server.");
            ModelTest.finalize(-1);
        }
    }

    public ModelTest(String[] stringArray) {
        try {
            MAIN_CONSOLE = new TextOutputStream(System.out);
            execMode = ExecMode.CONSOLE;
            this.ParseArguments();
            if (MPJ_ME == 0) {
                ModelTest.printHeader(MAIN_CONSOLE);
                ModelTest.printCitation(MAIN_CONSOLE);
                ModelTest.printNotice(MAIN_CONSOLE);
            }
            if (!RunPhyml.checkBinary()) {
                ModelTest.finalize(-1);
            }
            this.options.createLogFile();
            this.options.createCkpFile();
            if (this.options.doingSimulations) {
                Simulation simulation = new Simulation(this.options);
                simulation.run();
            } else {
                this.runCommandLine();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        ModelTest.finalize(0);
    }

    public static boolean loadCheckpoint(File file) {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            ObjectInputStream objectInputStream = new ObjectInputStream(bufferedInputStream);
            loadedModels = (Model[])objectInputStream.readObject();
            int n = 0;
            for (Model model : loadedModels) {
                if (!(model.getLnL() > 0.0)) continue;
                ++n;
            }
            MAIN_CONSOLE.println(" ok!");
            MAIN_CONSOLE.println("Loaded " + n + " models");
            ApplicationOptions.getInstance().setNumModels(loadedModels.length);
            objectInputStream.close();
        }
        catch (ClassNotFoundException classNotFoundException) {
            MAIN_CONSOLE.println(" cannot perform input.");
            return false;
        }
        catch (IOException iOException) {
            MAIN_CONSOLE.println(" cannot perform input.");
            return false;
        }
        return true;
    }

    public static void main(String[] stringArray) {
        System.err.println("[MPI] Testing MPI environment... (" + hostname + ")");
        try {
            arguments = MPI.Init(stringArray);
            System.err.println("[MPI] ... OK! [" + hostname + " (" + MPJ_ME + ")]");
            MPJ_ME = MPI.COMM_WORLD.Rank();
            MPJ_SIZE = MPI.COMM_WORLD.Size();
            MPJ_RUN = true;
        }
        catch (MPIException mPIException) {
            System.err.println("[MPI] Proceed without MPI");
            MPJ_ME = 0;
            MPJ_SIZE = 1;
            MPJ_RUN = false;
            arguments = stringArray;
        }
        catch (Exception exception) {
            System.err.println("[MPI] Proceed without MPI");
            MPJ_ME = 0;
            MPJ_SIZE = 1;
            MPJ_RUN = false;
            arguments = stringArray;
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            System.err.println("[MPI] Initializer error!");
            System.err.println(exceptionInInitializerError.getMessage());
            System.exit(-1);
            MPJ_ME = 0;
            MPJ_SIZE = 1;
            MPJ_RUN = false;
            arguments = stringArray;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            System.err.println("[MPI] Proceed without MPI");
            MPJ_ME = 0;
            MPJ_SIZE = 1;
            MPJ_RUN = false;
            arguments = stringArray;
        }
        if (arguments.length < 1) {
            buildGUI = true;
            new ModelTest();
        } else {
            buildGUI = false;
            new ModelTest(arguments);
        }
        ApplicationOptions.getInstance().getLogFile().delete();
    }

    public void runCommandLine() {
        if (MPJ_ME == 0) {
            MAIN_CONSOLE.println(" ");
            MAIN_CONSOLE.print("Arguments =");
            for (int i = 0; i < arguments.length; ++i) {
                MAIN_CONSOLE.print(" " + arguments[i]);
            }
            try {
                this.checkInputFiles();
            }
            catch (InvalidArgumentException.InvalidInputFileException invalidInputFileException) {
                MAIN_CONSOLE.println(invalidInputFileException.getMessage());
                ModelTest.finalize(-1);
            }
            if (this.options.getSubstTypeCode() == 0) {
                this.options.setNumModels(3);
            } else if (this.options.getSubstTypeCode() == 1) {
                this.options.setNumModels(5);
            } else if (this.options.getSubstTypeCode() == 2) {
                this.options.setNumModels(7);
            } else if (this.options.getSubstTypeCode() == 3) {
                this.options.setNumModels(11);
            } else {
                this.options.setNumModels(203);
            }
            if (this.options.doF) {
                this.options.setNumModels(this.options.getNumModels() * 2);
            }
            if (this.options.doI && this.options.doG) {
                this.options.setNumModels(this.options.getNumModels() * 4);
            } else if (this.options.doI || this.options.doG) {
                this.options.setNumModels(this.options.getNumModels() * 2);
            }
            this.options.setCandidateModels();
        }
        RunPhyml runPhyml = MPJ_RUN ? (this.options.threadScheduling && this.options.getNumberOfThreads() > 0 ? new RunPhymlHybrid(MPJ_ME, MPJ_SIZE, new ConsoleProgressObserver(this.options), this.options, ModelTest.getCandidateModels(), this.options.getNumberOfThreads()) : new RunPhymlMPJ(new ConsoleProgressObserver(this.options), this.options, ModelTest.getCandidateModels())) : new RunPhymlThread(new ConsoleProgressObserver(this.options), this.options, ModelTest.getCandidateModels());
        runPhyml.execute();
        if (MPJ_ME == 0) {
            Model model;
            ArrayList<Model> arrayList = new ArrayList<Model>();
            if (this.options.doAIC) {
                myAIC = new AIC(this.options.writePAUPblock, this.options.doImportances, this.options.doModelAveraging, this.options.confidenceInterval);
                myAIC.compute();
                minAIC = myAIC.getMinModel();
                AICwasCalculated = true;
                arrayList.add(minAIC);
            }
            if (this.options.doAICc) {
                myAICc = new AICc(this.options.writePAUPblock, this.options.doImportances, this.options.doModelAveraging, this.options.confidenceInterval);
                myAICc.compute();
                minAICc = myAICc.getMinModel();
                AICcwasCalculated = true;
                if (!arrayList.contains(minAICc)) {
                    arrayList.add(minAICc);
                }
            }
            if (this.options.doBIC) {
                myBIC = new BIC(this.options.writePAUPblock, this.options.doImportances, this.options.doModelAveraging, this.options.confidenceInterval);
                myBIC.compute();
                minBIC = myBIC.getMinModel();
                BICwasCalculated = true;
                if (!arrayList.contains(minBIC)) {
                    arrayList.add(minBIC);
                }
            }
            if (this.options.doDT) {
                myDT = new DT(this.options.writePAUPblock, this.options.doImportances, this.options.doModelAveraging, this.options.confidenceInterval);
                myDT.compute();
                minDT = myDT.getMinModel();
                DTwasCalculated = true;
            }
            if (this.options.isAmbiguous() && this.options.isForceCheckULnL()) {
                runPhyml.executeIgnoreGaps(arrayList.toArray(new Model[0]));
            }
            if (this.options.doAIC) {
                myAIC.print(MAIN_CONSOLE);
                if (this.options.doAveragedPhylogeny) {
                    consensusAIC = new RunConsense(myAIC, this.options.consensusType, this.options.confidenceInterval);
                }
            }
            if (this.options.doAICc) {
                myAICc.print(MAIN_CONSOLE);
                if (this.options.doAveragedPhylogeny) {
                    consensusAICc = new RunConsense(myAICc, this.options.consensusType, this.options.confidenceInterval);
                }
            }
            if (this.options.doBIC) {
                myBIC.print(MAIN_CONSOLE);
                if (this.options.doAveragedPhylogeny) {
                    consensusBIC = new RunConsense(myBIC, this.options.consensusType, this.options.confidenceInterval);
                }
            }
            if (this.options.doDT) {
                myDT.print(MAIN_CONSOLE);
                if (this.options.doAveragedPhylogeny) {
                    consensusDT = new RunConsense(myDT, this.options.consensusType, this.options.confidenceInterval);
                }
            }
            if (this.options.doHLRT) {
                myHLRT = new HLRT(this.options);
                myHLRT.compute(!this.options.backwardHLRTSelection, this.options.confidenceLevelHLRT, this.options.writePAUPblock);
            }
            if (this.options.doDLRT) {
                myHLRT = new HLRT(this.options);
                myHLRT.computeDynamical(!this.options.backwardHLRTSelection, this.options.confidenceLevelHLRT, this.options.writePAUPblock);
            }
            Tree tree = myAIC != null ? myAIC.getMinModel().getTree() : null;
            Tree tree2 = myAICc != null ? myAICc.getMinModel().getTree() : null;
            Tree tree3 = myBIC != null ? myBIC.getMinModel().getTree() : null;
            Tree tree4 = myDT != null ? myDT.getMinModel().getTree() : null;
            MAIN_CONSOLE.println(" ");
            MAIN_CONSOLE.println(" ");
            MAIN_CONSOLE.println(" ");
            MAIN_CONSOLE.println("---------------------------------------------------------------");
            MAIN_CONSOLE.println("*                                                             *");
            MAIN_CONSOLE.println("*                    SELECTION SUMMARY                        *");
            MAIN_CONSOLE.println("*                                                             *");
            MAIN_CONSOLE.println("---------------------------------------------------------------");
            MAIN_CONSOLE.println("");
            TreeSummary treeSummary = new TreeSummary(tree, tree2, tree3, tree4, candidateModels);
            treeSummary.print(MAIN_CONSOLE);
            MAIN_CONSOLE.println(" ");
            MAIN_CONSOLE.println(" ");
            MAIN_CONSOLE.println(" ");
            MAIN_CONSOLE.println("::Best Models::");
            MAIN_CONSOLE.println(" ");
            if (myAIC == null && myAICc == null && myBIC == null && myDT == null) {
                MAIN_CONSOLE.println("No information criterion was selected.");
            }
            MAIN_CONSOLE.println("\tModel \t\tf(a) \tf(c) \tf(g) \tf(t) \tkappa \ttitv \tRa\tRb\tRc\tRd\tRe\tRf\tpInv \tgamma");
            MAIN_CONSOLE.println("----------------------------------------------------------------------------------------------------------------------------------------");
            boolean bl = true;
            if (myAIC != null) {
                model = myAIC.getMinModel();
                MAIN_CONSOLE.println("AIC \t" + this.getModelRow(model));
                bl &= myAIC.isValid();
            }
            if (myBIC != null) {
                model = myBIC.getMinModel();
                MAIN_CONSOLE.println("BIC \t" + this.getModelRow(model));
                bl &= myBIC.isValid();
            }
            if (myAICc != null) {
                model = myAICc.getMinModel();
                MAIN_CONSOLE.println("AICc \t" + this.getModelRow(model));
                bl &= myAICc.isValid();
            }
            if (myDT != null) {
                model = myDT.getMinModel();
                MAIN_CONSOLE.println("DT \t" + this.getModelRow(model));
                bl &= myDT.isValid();
                MAIN_CONSOLE.println(" ");
                MAIN_CONSOLE.println("Program is done.");
            }
            if (!bl) {
                MAIN_CONSOLE.println("* There might not be information enough to achieve reliable results. Please inspect the results carefully.");
            }
            if (ModelTestConfiguration.isHtmlLogEnabled()) {
                HtmlReporter.buildReport(this.options, ModelTest.getCandidateModels(), null, treeSummary);
            }
        }
    }

    private String getModelRow(Model model) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(model.getName() + "\t");
        if (model.getName().length() < 8) {
            stringBuilder.append("\t");
        }
        stringBuilder.append(Utilities.format(model.getfA(), 4, 2, false) + "\t" + Utilities.format(model.getfC(), 4, 2, false) + "\t" + Utilities.format(model.getfG(), 4, 2, false) + "\t" + Utilities.format(model.getfT(), 4, 2, false) + "\t" + Utilities.format(model.getKappa(), 4, 2, false) + "\t" + Utilities.format(model.getTitv(), 4, 2, false) + "\t" + Utilities.format(model.getRa(), 7, 3, false) + " " + Utilities.format(model.getRb(), 7, 3, false) + " " + Utilities.format(model.getRc(), 7, 3, false) + " " + Utilities.format(model.getRd(), 7, 3, false) + " " + Utilities.format(model.getRe(), 7, 3, false) + " " + Utilities.format(model.getRf(), 7, 3, false) + " ");
        if (model.ispI()) {
            stringBuilder.append(Utilities.format(model.getPinv(), 7, 2, false));
        } else {
            stringBuilder.append("N/A");
        }
        stringBuilder.append("\t");
        if (model.ispG()) {
            stringBuilder.append(Utilities.format(model.getShape(), 7, 2, false));
        } else {
            stringBuilder.append("N/A");
        }
        return stringBuilder.toString();
    }

    private String getModelAverageRow(InformationCriterion informationCriterion) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Utilities.format(informationCriterion.getAfA(), 4, 2, false) + "\t");
        stringBuilder.append(Utilities.format(informationCriterion.getAfC(), 4, 2, false) + "\t");
        stringBuilder.append(Utilities.format(informationCriterion.getAfG(), 4, 2, false) + "\t");
        stringBuilder.append(Utilities.format(informationCriterion.getAfT(), 4, 2, false) + "\t");
        stringBuilder.append(Utilities.format(informationCriterion.getAkappa(), 4, 2, false) + "\t");
        stringBuilder.append(Utilities.format(informationCriterion.getAtitv(), 4, 2, false) + "\t");
        stringBuilder.append(Utilities.format(informationCriterion.getaRa(), 7, 3, false) + "\t");
        stringBuilder.append(Utilities.format(informationCriterion.getaRb(), 7, 3, false) + "\t");
        stringBuilder.append(Utilities.format(informationCriterion.getaRc(), 7, 3, false) + "\t");
        stringBuilder.append(Utilities.format(informationCriterion.getaRd(), 7, 3, false) + "\t");
        stringBuilder.append(Utilities.format(informationCriterion.getaRe(), 7, 3, false) + "\t");
        stringBuilder.append(Utilities.format(informationCriterion.getaRf(), 7, 3, false) + "\t");
        stringBuilder.append(Utilities.format(informationCriterion.getApinvI(), 7, 4, false) + "\t");
        stringBuilder.append(Utilities.format(informationCriterion.getApinvIG(), 7, 4, false) + "\t");
        stringBuilder.append(Utilities.format(informationCriterion.getAshapeG(), 7, 3, false) + "\t");
        stringBuilder.append(Utilities.format(informationCriterion.getAshapeIG(), 7, 3, false) + "\t");
        return stringBuilder.toString();
    }

    public void ParseArguments() {
        String string = "";
        String string2 = "\nCOMMAND LINE ERROR: ";
        File file = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            Object object;
            int n = 0;
            while (n < arguments.length) {
                Object object2;
                int n2;
                if (!arguments[n].startsWith("-")) {
                    System.err.println(string2 + "Arguments must start with \"-\". The ofending argument was: " + arguments[n] + ".");
                    System.err.print("      Arguments: ");
                    object = arguments;
                    n2 = ((String[])object).length;
                    for (int i = 0; i < n2; ++i) {
                        object2 = object[i];
                        System.err.print((String)object2 + " ");
                    }
                    System.err.println("");
                    ModelTest.CommandLineError();
                    System.exit(1);
                }
                if ((string = arguments[n++]).equals("-d")) {
                    if (n < arguments.length) {
                        this.options.setInputFile(new File(arguments[n++]));
                        bl = true;
                        continue;
                    }
                    System.err.println(string2 + "-d option requires an input filename.");
                    ModelTest.CommandLineError();
                    continue;
                }
                if (string.equals("-o")) {
                    object = arguments[n++];
                    try {
                        MAIN_CONSOLE = new TextOutputStream(new PrintStream((String)object));
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        System.err.println("An error has ocurred while trying to open the output file \"" + (String)object + "\" for writing");
                        fileNotFoundException.printStackTrace();
                        System.exit(-1);
                    }
                    continue;
                }
                if (string.equals("-s")) {
                    if (n < arguments.length) {
                        object = arguments[n++];
                        try {
                            n2 = Integer.parseInt((String)object);
                            switch (n2) {
                                case 3: {
                                    this.options.setSubstTypeCode(0);
                                    break;
                                }
                                case 5: {
                                    this.options.setSubstTypeCode(1);
                                    break;
                                }
                                case 7: {
                                    this.options.setSubstTypeCode(2);
                                    break;
                                }
                                case 11: {
                                    this.options.setSubstTypeCode(3);
                                    break;
                                }
                                case 203: {
                                    this.options.setSubstTypeCode(4);
                                    break;
                                }
                                default: {
                                    System.err.println(string2 + "-s substitution types have to be 3,5,7,11 only.");
                                    ModelTest.CommandLineError();
                                    break;
                                }
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            System.err.println(string2 + "-s option requires a number for the substitution types: 3,5,7,11.");
                            ModelTest.CommandLineError();
                        }
                        continue;
                    }
                    System.err.println(string2 + "-s option requires a number for the substitution types: 3,5,7,11.");
                    ModelTest.CommandLineError();
                    continue;
                }
                if (string.equals("-ckp")) {
                    if (n < arguments.length) {
                        file = new File(arguments[n++]);
                        continue;
                    }
                    System.err.println(string2 + "-ckp option requires a checkpoint filename.");
                    ModelTest.CommandLineError();
                    continue;
                }
                if (string.equals("-f")) {
                    this.options.doF = true;
                    continue;
                }
                if (string.equals("-i")) {
                    this.options.doI = true;
                    continue;
                }
                if (string.equals("-g")) {
                    if (n < arguments.length) {
                        try {
                            this.options.doG = true;
                            object = arguments[n++];
                            this.options.numGammaCat = Integer.parseInt((String)object);
                        }
                        catch (NumberFormatException numberFormatException) {
                            System.err.println(string2 + "-g option requires a number of gamma categories.");
                            ModelTest.CommandLineError();
                        }
                        continue;
                    }
                    System.err.println(string2 + "-g option requires a number of gamma categories.");
                    ModelTest.CommandLineError();
                    continue;
                }
                if (string.equals("-G")) {
                    if (n < arguments.length) {
                        try {
                            object = Double.parseDouble(arguments[n++]);
                            this.options.setGuidedSearchThreshold((Double)object);
                        }
                        catch (NumberFormatException numberFormatException) {
                            System.err.println(string2 + "-G option requires a threshold.");
                            ModelTest.CommandLineError();
                        }
                        continue;
                    }
                    System.err.println(string2 + "-G option requires a threshold.");
                    ModelTest.CommandLineError();
                    continue;
                }
                if (string.equals("-H")) {
                    if (n < arguments.length) {
                        if (((String)(object = arguments[n++])).equals("AIC")) {
                            this.options.setHeuristicInformationCriterion(1);
                        } else if (((String)object).equals("BIC")) {
                            this.options.setHeuristicInformationCriterion(3);
                        } else if (((String)object).equals("AICc")) {
                            this.options.setHeuristicInformationCriterion(2);
                        } else {
                            System.err.println(string2 + "-H argument is invalid (AIC, BIC, AICc).");
                            ModelTest.CommandLineError();
                        }
                        bl2 = true;
                        continue;
                    }
                    System.err.println(string2 + "-H option requires an argument (AIC, BIC, AICc).");
                    ModelTest.CommandLineError();
                    continue;
                }
                if (string.equals("-t")) {
                    if (n < arguments.length) {
                        if (((String)(object = arguments[n++])).equalsIgnoreCase("fixed")) {
                            this.options.fixedTopology = true;
                            this.options.optimizeMLTopology = false;
                            this.options.userTopologyExists = false;
                            continue;
                        }
                        if (((String)object).equalsIgnoreCase("BIONJ")) {
                            this.options.fixedTopology = false;
                            this.options.optimizeMLTopology = false;
                            this.options.userTopologyExists = false;
                            continue;
                        }
                        if (((String)object).equalsIgnoreCase("ML")) {
                            this.options.fixedTopology = false;
                            this.options.optimizeMLTopology = true;
                            this.options.userTopologyExists = false;
                            continue;
                        }
                        System.err.println(string2 + "-t option requires a type of base tree for likelihod calculations: " + "\"fixed\", \"BIONJ\" or \"ML\" only");
                        ModelTest.CommandLineError();
                        continue;
                    }
                    System.err.println(string2 + "-t option requires a type of base tree for likelihod calculations: " + "fixed, BIONJ or ML");
                    ModelTest.CommandLineError();
                    continue;
                }
                if (string.equals("-getPhylip")) {
                    bl3 = true;
                    continue;
                }
                if (string.equals("-u")) {
                    if (n < arguments.length) {
                        this.options.setInputTreeFile(new File(arguments[n++]));
                        this.options.fixedTopology = false;
                        this.options.optimizeMLTopology = false;
                        this.options.userTopologyExists = true;
                        continue;
                    }
                    System.err.println(string2 + "-u option requires an file name for the tree file");
                    ModelTest.CommandLineError();
                    continue;
                }
                if (string.equals("-n")) {
                    if (n < arguments.length) {
                        this.options.setExecutionName(arguments[n++]);
                        continue;
                    }
                    System.err.println(string2 + "-n option requires a name for the execution");
                    ModelTest.CommandLineError();
                    continue;
                }
                if (string.equals("-S")) {
                    if (n < arguments.length) {
                        if (((String)(object = arguments[n++])).equalsIgnoreCase("NNI")) {
                            this.options.treeSearchOperations = ApplicationOptions.TreeSearch.NNI;
                            continue;
                        }
                        if (((String)object).equalsIgnoreCase("SPR")) {
                            this.options.treeSearchOperations = ApplicationOptions.TreeSearch.SPR;
                            continue;
                        }
                        if (((String)object).equalsIgnoreCase("BEST")) {
                            this.options.treeSearchOperations = ApplicationOptions.TreeSearch.BEST;
                            continue;
                        }
                        System.err.println(string2 + "-S option requires a type of tree topology search operation: " + "\"NNI\", \"SPR\" or \"BEST\" only");
                        ModelTest.CommandLineError();
                        continue;
                    }
                    System.err.println(string2 + "-S option requires a type of tree topology search operation: " + "\"NNI\", \"SPR\", \"BEST\"");
                    ModelTest.CommandLineError();
                    continue;
                }
                if (string.equals("-AIC")) {
                    this.options.doAIC = true;
                    continue;
                }
                if (string.equals("-AICc")) {
                    this.options.doAICc = true;
                    continue;
                }
                if (string.equals("-BIC")) {
                    this.options.doBIC = true;
                    continue;
                }
                if (string.equals("-DT")) {
                    this.options.doDT = true;
                    continue;
                }
                if (string.equals("-uLnL")) {
                    this.options.setForceCheckULnL(true);
                    continue;
                }
                if (string.equals("-p")) {
                    this.options.doImportances = true;
                    continue;
                }
                if (string.equals("-v")) {
                    this.options.doImportances = true;
                    this.options.doModelAveraging = true;
                    continue;
                }
                if (string.equals("-w")) {
                    this.options.writePAUPblock = true;
                    continue;
                }
                if (string.equals("-c")) {
                    if (n < arguments.length) {
                        try {
                            object = arguments[n++];
                            this.options.confidenceInterval = Double.parseDouble((String)object);
                        }
                        catch (NumberFormatException numberFormatException) {
                            System.err.println(string2 + "-c option requires a number (0-1) for the model selection confidence interval.");
                            ModelTest.CommandLineError();
                        }
                        continue;
                    }
                    System.err.println(string2 + "-c option requires a number (0-1) for the model selection confidence interval.");
                    ModelTest.CommandLineError();
                    continue;
                }
                if (string.equals("-help")) {
                    ModelTest.PrintUsage();
                    continue;
                }
                if (string.equals("-hLRT")) {
                    this.options.doHLRT = true;
                    continue;
                }
                if (string.equals("-O")) {
                    if (n >= arguments.length) continue;
                    object = arguments[n++];
                    char[] cArray = ((String)object).toCharArray();
                    Arrays.sort(cArray);
                    String string3 = "";
                    if (((String)object).length() == 5) {
                        string3 = "fgptv";
                    } else if (((String)object).length() == 6) {
                        string3 = "fgptvw";
                    } else if (((String)object).length() == 7) {
                        string3 = "fgptvwx";
                    } else {
                        System.err.println(string2 + "-O option requires a 5, 6 or 7 specific letter string with the order of tests (default is ftvwxgp)" + "\n            f=freq, t=titvi, v=2ti4tv(subst=3)/2ti(subst>3), w=2tv, x=4tv, g=gamma, p=pinv" + "\n            this argument is used only if -hLRT argument is set" + "\n            'f','t','v','g','p' are mandatory in any order. 'w' is optional, and 'x' requires 'w' to be present" + "\n            thus, length should be 5, 6 *including 'w') or 7 (including both 'w' and 'x')" + "\n            e.g., -hLRT -O gpfvwxt");
                        ModelTest.CommandLineError();
                    }
                    object2 = string3.toCharArray();
                    if (!Arrays.equals(cArray, (char[])object2)) {
                        System.err.println(String.valueOf(cArray) + " " + String.valueOf((char[])object2));
                        System.err.println(string2 + "-O option requires a 5, 6 or 7 specific letter string with the order of tests (default is ftvwxgp)" + "\n            f=freq, t=titvi, v=2ti4tv(subst=3)/2ti(subst>3), w=2tv, x=4tv, g=gamma, p=pinv" + "\n            this argument is used only if -hLRT argument is set" + "\n            'f','t','v','g','p' are mandatory in any order. 'w' is optional, and 'x' requires 'w' to be present" + "\n            thus, length should be 5, 6 *including 'w') or 7 (including both 'w' and 'x')" + "\n            e.g., -hLRT -O gpfvwxt");
                        ModelTest.CommandLineError();
                        continue;
                    }
                    testingOrder = new Vector();
                    for (int i = 0; i < ((String)object).length(); ++i) {
                        if (((String)object).charAt(i) == 'f') {
                            testingOrder.addElement("freq");
                            continue;
                        }
                        if (((String)object).charAt(i) == 't') {
                            testingOrder.addElement("titv");
                            continue;
                        }
                        if (((String)object).charAt(i) == 'v') {
                            if (this.options.getSubstTypeCode() == 0) {
                                testingOrder.addElement("2ti4tv");
                                continue;
                            }
                            if (this.options.getSubstTypeCode() < 1) continue;
                            testingOrder.addElement("2ti");
                            continue;
                        }
                        if (((String)object).charAt(i) == 'w') {
                            if (this.options.getSubstTypeCode() < 1) continue;
                            testingOrder.addElement("2tv");
                            continue;
                        }
                        if (((String)object).charAt(i) == 'x') {
                            if (this.options.getSubstTypeCode() <= 1) continue;
                            testingOrder.addElement("4tv");
                            continue;
                        }
                        if (((String)object).charAt(i) == 'g') {
                            testingOrder.addElement("gamma");
                            continue;
                        }
                        if (((String)object).charAt(i) != 'p') continue;
                        testingOrder.addElement("pinv");
                    }
                    continue;
                }
                if (string.equals("-dLRT")) {
                    this.options.doDLRT = true;
                    continue;
                }
                if (string.equals("-r")) {
                    this.options.backwardHLRTSelection = true;
                    continue;
                }
                if (string.equals("-h")) {
                    if (n < arguments.length) {
                        try {
                            object = arguments[n++];
                            this.options.confidenceLevelHLRT = Double.parseDouble((String)object);
                        }
                        catch (NumberFormatException numberFormatException) {
                            System.err.println(string2 + "-h option requires a number (0-1) for the hLRT confidence interval.");
                            ModelTest.CommandLineError();
                        }
                        continue;
                    }
                    System.err.println(string2 + "-h option requires a number (0-1) for the hLRT confidence interval.");
                    ModelTest.CommandLineError();
                    continue;
                }
                if (string.equals("-a")) {
                    this.options.doAveragedPhylogeny = true;
                    continue;
                }
                if (string.equals("-z")) {
                    this.options.consensusType = "strict";
                    continue;
                }
                if (string.equals("-sims")) {
                    if (n < arguments.length) {
                        this.options.simulationsName = arguments[n++];
                        this.options.doingSimulations = true;
                        continue;
                    }
                    System.err.println(string2 + "-sims option requires a name for the simulations files");
                    ModelTest.CommandLineError();
                    continue;
                }
                if (string.equals("-machinesfile")) {
                    if (n < arguments.length) {
                        if (!((File)(object = new File(arguments[n++]))).exists() || !((File)object).canRead()) {
                            if (MPJ_ME == 0) {
                                System.err.println(string2 + "Machines file does not exists or it is not readable");
                            }
                            ModelTest.CommandLineError();
                        }
                        n2 = 0;
                        try {
                            TextInputStream textInputStream = new TextInputStream(((File)object).getAbsolutePath());
                            HOSTS_TABLE = new Hashtable();
                            while ((object2 = textInputStream.readLine()) != null) {
                                block127: {
                                    String[] stringArray = ((String)object2).split(":");
                                    if (stringArray.length == 2) {
                                        try {
                                            int n3 = Integer.parseInt(stringArray[1]);
                                            HOSTS_TABLE.put(stringArray[0], new Integer(n3));
                                            break block127;
                                        }
                                        catch (NumberFormatException numberFormatException) {
                                            n2 = 1;
                                            break;
                                        }
                                    }
                                    n2 = 1;
                                }
                                if (n2 == 0) continue;
                                if (MPJ_ME == 0) {
                                    System.err.println("");
                                    System.err.println("WARNING: Machines File format is wrong.");
                                    System.err.println("         Each line should have the following format:");
                                    System.err.println("         HOSTNAME:NUMBER_OF_PROCESORS");
                                    System.err.println("Using a single thread");
                                    System.err.println("");
                                }
                                HOSTS_TABLE = null;
                                this.options.setNumberOfThreads(1);
                            }
                            this.options.setMachinesFile((File)object);
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            System.err.println(string2 + "Machines file does not exists or it is not readable");
                            ModelTest.CommandLineError();
                        }
                        continue;
                    }
                    System.err.println(string2 + "-machinesfile option requires a filename");
                    ModelTest.CommandLineError();
                    continue;
                }
                if (string.equals("-tr")) {
                    if (HOSTS_TABLE != null) {
                        object = arguments[n++];
                        System.err.println("WARNING: Machines File has been specified. -tr " + (String)object + " argument will be ignored.");
                        continue;
                    }
                    if (n < arguments.length) {
                        try {
                            object = arguments[n++];
                            this.options.setNumberOfThreads(Integer.parseInt((String)object));
                            this.options.threadScheduling = true;
                        }
                        catch (NumberFormatException numberFormatException) {
                            System.err.println(string2 + "-tr option requires the number of processors to compute.");
                            ModelTest.CommandLineError();
                        }
                        continue;
                    }
                    System.err.println(string2 + "-tr option requires the number of processors to compute.");
                    ModelTest.CommandLineError();
                    continue;
                }
                if (string.equals("--set-local-config")) {
                    if (n < arguments.length) {
                        File file2;
                        if (!(file2 = new File((String)(object = arguments[n++]))).exists() || !file2.canRead()) {
                            System.err.println(string2 + "Config file " + (String)object + " does not exist or cannot be read.");
                            ModelTest.CommandLineError();
                        }
                        CONFIG_FILE = file2.getAbsolutePath();
                        continue;
                    }
                    System.err.println(string2 + "--set-local-config option requires a config file.");
                    ModelTest.CommandLineError();
                    continue;
                }
                if (string.equals("--set-property")) {
                    if (n < arguments.length) {
                        if (((String)(object = arguments[n++])).indexOf("=") == -1) {
                            System.err.println(string2 + "--set-property option requires a property definition with the following format:");
                            System.err.println("                    --set-property <property_name>=<property_value>");
                            System.err.println("              e.g., --set-property log-dir=myHome/myLogDir");
                            ModelTest.CommandLineError();
                        }
                        String string4 = ((String)object).split("=")[0].trim();
                        String string5 = ((String)object).split("=")[1].trim();
                        USERDEF_PROPERTIES.setProperty(string4, string5);
                        continue;
                    }
                    System.err.println(string2 + "--set-property option requires a property definition.");
                    System.err.println(string2 + "e.g., --set-property log-dir=myHome/myLogDir");
                    ModelTest.CommandLineError();
                    continue;
                }
                System.err.println(string2 + "the argument \" " + string + "\" is unknown. Check its syntax.");
                ModelTest.CommandLineError();
            }
            if (!bl) {
                System.err.println(string2 + "Input File is required (-d argument)");
                ModelTest.CommandLineError();
            }
            if (bl3) {
                MAIN_CONSOLE.print("\n\nReading data file \"" + this.options.getInputFile().getName() + "\"...");
                if (this.options.getInputFile().exists()) {
                    try {
                        object = new File(this.options.getInputFile().getAbsolutePath() + ".phy");
                        ModelTestService.readAlignment(this.options.getInputFile(), (File)object, false);
                        MAIN_CONSOLE.println(" OK.");
                        MAIN_CONSOLE.println("Result written into " + ((File)object).getPath());
                        MAIN_CONSOLE.println("");
                    }
                    catch (Exception exception) {
                        System.err.println("\nThe specified file \"" + this.options.getInputFile().getAbsolutePath() + "\" cannot be read as an alignment");
                        MAIN_CONSOLE.println(" failed.\n" + exception.getMessage());
                        throw new InvalidArgumentException.InvalidAlignmentFileException(this.options.getInputFile());
                    }
                } else {
                    System.err.println("\nThe specified file \"" + this.options.getInputFile().getAbsolutePath() + "\" cannot be found");
                    throw new InvalidArgumentException.UnexistentAlignmentFileException(this.options.getInputFile());
                }
                ModelTest.finalize(0);
            }
            if (file != null && !ModelTest.loadCheckpoint(file)) {
                System.err.println("\nThe specified checkpoint file \"" + this.options.getInputFile().getAbsolutePath() + "\" cannot be read");
                ModelTest.finalize(0);
            }
            if (testingOrder != null && !this.options.doHLRT) {
                System.err.println("\nWARNING: Hypothesis testing order has been set, but hierarchical Likelihood Ratio Test was not selected with '-hLRT' parameter");
                System.err.println("         Thus, this option has no effect\n");
            }
            if (bl2 && this.options.getSubstTypeCode() != 4) {
                System.err.println("\nWARNING: Information Criterion for hierarchical clustering has been specified, but hierarchical clustering applies only for 203 substitution schemes");
                System.err.println("         Thus, this option has no effect\n");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.options.doBIC = this.options.doBIC | (!this.options.doAIC && !this.options.doAICc && !this.options.doDT);
    }

    public static void CommandLineError() {
        System.err.println("\nPlease run with -help argument for info about the usage\n");
        System.exit(1);
    }

    public static void PrintUsage() {
        if (MPJ_ME == 0) {
            System.err.println("\njModelTest command usage");
            System.err.println("java -jar jModelTest.jar -d sequenceFileName\n                        [-getPhylip]\n                        [-ckp checkpointFileName.ckp]\n                        [-n executionName]\n                        [-t fixed|BIONJ|ML] [-u userTreeFileName] [-o outputFileName]\n                        [-S NNI|SPR|BEST]\n                        [-AIC] [-AICc] [-BIC] [-DT] [-c confidenceInterval]\n                        [-s 3|5|7|11|203]\n                        [-f] [-i] [-g numberOfCategories]\n                        [-uLNL]\n                        [-dLRT] [-h confidenceInterval] [-hLRT] [-O {ftvwxgp}]\n                        [-a] [-z] [-p] [-v] [-w]\n                        [-tr numberOfThreads] [-machinesfile machinesFileName]");
            String string = "\n     -a\n         estimate model-averaged phylogeny for each active criterion (e.g., -a) (default is false)\n\n     -AIC\n         calculate the Akaike Information Criterion (e.g., -AIC) (default is false)\n\n     -AICc\n         calculate the corrected Akaike Information Criterion (e.g., -AICc) (default is false)\n\n     -BIC\n         calculate the Bayesian Information Criterion (e.g., -BIC) (default is false)\n\n     -DT\n         calculate the decision theory criterion (e.g., -DT) (default is false)\n\n     -c confidenceInterval\n         confidence interval (e.g., -c 90) (default is 100)\n\n     -ckp checkpointFileName\n         Loads a checkpointing file\n\n     -d sequenceFileName\n         input data file (e.g., -d data.phy)\n\n     -dLRT\n         do dynamical likelihood ratio tests (e.g., -dLRT)(default is false)\n\n     -f\n         include models with unequals base frecuencies (e.g., -f) (default is false)\n\n     -g numberOfCategories\n         include models with rate variation among sites and number of categories (e.g., -g 8) (default is false & 4 categories)\n\n     -G threshold\n         heuristic search. Requires a threshold > 0 (e.g., -G 0.1)\n\n     -getPhylip\n         converts the input file into phylip format\n\n     -h confidenceInterval\n         confidence level for the hLRTs (e.g., -a0.002) (default is 0.01)\n\n     -H informationCriterion\n         information criterion for clustering search (AIC, AICc, BIC). (default is BIC)\n         this argument applies only for 203 substitution schemes (e.g., -s 203 -H AIC)\n\n     -help\n         displays this help message\n\n     -hLRT\n         do hierarchical likelihood ratio tests (default is false)\n         hypothesis testing order can be specified with -O argument\n\n     -i\n         include models with a proportion invariable sites (e.g., -i) (default is false)\n\n     -machinesfile manchinesFileName\n         gets the processors per host from a machines file\n\n     -n executionName\n         execution name for appending to the log filenames (default: current time yyyyMMddhhmmss)\n\n     -o outputFileName\n         set output file (e.g., -o jmodeltest.out)\n\n     -O hypothesisOrder\n         hypothesis order for the hLRTs (e.g., -hLRT -O gpftv) (default is ftvwxgp)\n            f=freq, t=titvi, v=2ti4tv(subst=3)/2ti(subst>3), w=2tv, x=4tv, g=gamma, p=pinv\n            this argument is used only if -hLRT argument is set\n            'f','t','v','g','p' are mandatory in any order. 'w' is optional, and 'x' requires 'w' to be present\n            thus, length should be 5, 6 *including 'w') or 7 (including both 'w' and 'x')\n            e.g., -hLRT -O gpfvwxt\n\n     -p\n         calculate parameter importances (e.g., -p) (default is false)\n\n     -r\n         backward selection for the hLRT (e.g., -r) (default is forward)\n\n     -s numberOfSubstitutionSchemes\n         number of substitution schemes (e.g., -s 11) (it has to be 3,5,7,11,203; default is 3)\n\n     --set-local-config localConfigurationFile\n         set a local configuration file in replacement of conf/jmodeltest.conf\n\n     --set-property propertyName=propertyValue\n         set a new value for a property contained in the configuration file (conf/jmodeltest.conf)\n\n     -S NNI|SPR|BEST\n         tree topology search operation option (NNI (fast), SPR (a bit slower), BEST (best of NNI and SPR)) (default is BEST)\n\n     -t fixed|BIONJ|ML\n             base tree for likelihood calculations (e.g., -t BIONJ)\n             fixed  (common BIONJ-JC topology)\n             BIONJ  (Neighbor-Joining topology)\n             ML     (Maximum Likelihood topology) (default)\n\n     -tr numberOfThreads\n         number of threads to execute (default is " + Runtime.getRuntime().availableProcessors() + ")" + "\n\n     -u treeFileName" + "\n         user tree for likelihood calculations  (e.g., -u data.tre)" + "\n\n     -uLnL" + "\n         calculate delta AIC,AICc,BIC against unconstrained likelihood (e.g., -uLnL)" + "\n\n        (default is false if the input alignment has gaps or ambiguous characters)" + "\n\n     -v" + "\n         do model averaging and parameter importances (e.g., -v) (default is false)" + "\n\n     -w" + "\n         write PAUP block (e.g., -w) (default is false)" + "\n\n     -z" + "\n         strict consensus type for model-averaged phylogeny (e.g., -z) (default is majority rule)" + "\n\n Command line: java -jar jModeltest.jar -d sequenceFileName [arguments]" + "\n\n Example: java -jar jModeltest.jar -d sequenceFileName -i -f -g 4 -BIC -AIC -AICc -DT -v -a -w";
            System.err.println(string);
            System.err.println(" ");
        }
        System.exit(0);
    }

    public static void printHeader(TextOutputStream textOutputStream) {
        textOutputStream.print("-------------------------- ");
        textOutputStream.print("jModeltest 2.1.10 v20160303");
        textOutputStream.println(" --------------------------");
        textOutputStream.println("(c) 2011-onwards D. Darriba, G.L. Taboada, R. Doallo and D. Posada,");
        textOutputStream.println("(1) Department of Biochemistry, Genetics and Immunology");
        textOutputStream.println("    University of Vigo, 36310 Vigo, Spain.");
        textOutputStream.println("(2) Department of Electronics and Systems");
        textOutputStream.println("    University of A Coruna, 15071 A Coruna, Spain.");
        textOutputStream.println("e-mail: ddarriba@udc.es, dposada@uvigo.es");
        textOutputStream.println("--------------------------------------------------------------------------------");
        textOutputStream.println(" ");
        Date date = new Date();
        textOutputStream.println(date.toString());
        textOutputStream.println(System.getProperty("os.name") + " " + System.getProperty("os.version") + ", arch: " + System.getProperty("os.arch") + ", bits: " + System.getProperty("sun.arch.data.model") + ", numcores: " + Runtime.getRuntime().availableProcessors());
        textOutputStream.println(" ");
    }

    public static void printNotice(TextOutputStream textOutputStream) {
        textOutputStream.println("jModelTest 2.1.10 v20160303");
        textOutputStream.println("Copyright (C) 2011 D. Darriba, G.L. Taboada, R. Doallo and D. Posada");
        textOutputStream.println("This program comes with ABSOLUTELY NO WARRANTY");
        textOutputStream.println("This is free software, and you are welcome to redistribute it under certain");
        textOutputStream.println("conditions");
        textOutputStream.println(" ");
        textOutputStream.println("Notice: This program may contain errors. Please inspect results carefully.");
        textOutputStream.println(" ");
    }

    public static void printCitation(TextOutputStream textOutputStream) {
        textOutputStream.println("--------------------------------------------------------------------------------");
        textOutputStream.println("Citation: Darriba D, Taboada GL, Doallo R and Posada D. 2012.");
        textOutputStream.println("          \"jModelTest 2: more models, new heuristics and parallel computing\".");
        textOutputStream.println("          Nature Methods 9(8), 772.");
        textOutputStream.println("--------------------------------------------------------------------------------");
        textOutputStream.println(" ");
    }

    public static void WritePaupBlock(TextOutputStream textOutputStream, String string, Model model) {
        try {
            textOutputStream.println("\n--\nPAUP* Commands Block:");
            textOutputStream.println(" If you want to load the selected model and associated estimates in PAUP*,");
            textOutputStream.println(" attach the next block of commands after the data in your PAUP file:");
            textOutputStream.print("\n[!\nLikelihood settings from best-fit model (");
            textOutputStream.printf("%s", model.getName());
            textOutputStream.print(") selected by ");
            textOutputStream.printf("%s", string);
            textOutputStream.print("\nwith ");
            textOutputStream.printf("%s", programName);
            textOutputStream.print(" ");
            textOutputStream.printf("%s", CURRENT_VERSION);
            textOutputStream.print(" on ");
            Date date = new Date();
            textOutputStream.print(date.toString());
            textOutputStream.println("]");
            textOutputStream.print("\nBEGIN PAUP;");
            textOutputStream.print("\nLset");
            textOutputStream.print(" base=");
            if (model.ispF()) {
                textOutputStream.print("(");
                textOutputStream.printf("%.4f ", model.getfA());
                textOutputStream.printf("%.4f ", model.getfC());
                textOutputStream.printf("%.4f ", model.getfG());
                textOutputStream.print(")");
            } else {
                textOutputStream.print("equal");
            }
            if (!model.ispT() && !model.ispR()) {
                textOutputStream.print(" nst=1");
            } else if (model.ispT()) {
                textOutputStream.print(" nst=2 tratio=");
                textOutputStream.printf("%.4f", model.getTitv());
            } else if (model.ispR()) {
                textOutputStream.print(" nst=6  rmat=(");
                textOutputStream.printf("%.4f ", model.getRa());
                textOutputStream.printf("%.4f ", model.getRb());
                textOutputStream.printf("%.4f ", model.getRc());
                textOutputStream.printf("%.4f ", model.getRd());
                textOutputStream.printf("%.4f)", model.getRe());
            }
            textOutputStream.print(" rates=");
            if (model.ispG()) {
                textOutputStream.print("gamma shape=");
                textOutputStream.printf("%.4f", model.getShape());
                textOutputStream.print(" ncat=");
                textOutputStream.printf("%d", model.getNumGammaCat());
            } else {
                textOutputStream.print("equal");
            }
            textOutputStream.print(" pinvar=");
            if (model.ispI()) {
                textOutputStream.printf("%.4f", model.getPinv());
            } else {
                textOutputStream.print("0");
            }
            textOutputStream.print(";\nEND;");
            textOutputStream.print("\n--\n");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void checkInputFiles() {
        Object object;
        Object object2;
        File file = this.options.getInputFile();
        MAIN_CONSOLE.print("\n\nReading data file \"" + file.getName() + "\"...");
        if (file.exists()) {
            try {
                object2 = ModelTestService.readAlignment(file, this.options.getAlignmentFile());
                object = new PushbackReader(new StringReader((String)object2));
                this.options.setAlignment(AlignmentReader.createAlignment(new PrintWriter(System.err), (PushbackReader)object, true));
                MAIN_CONSOLE.println(" OK.");
                MAIN_CONSOLE.println("  number of sequences: " + this.options.getNumTaxa());
                MAIN_CONSOLE.println("  number of sites: " + this.options.getNumSites());
            }
            catch (Exception exception) {
                System.err.println("\nThe specified file \"" + file.getAbsolutePath() + "\" cannot be read as an alignment");
                MAIN_CONSOLE.println(" failed.\n" + exception.getMessage());
                throw new InvalidArgumentException.InvalidAlignmentFileException(file);
            }
        } else {
            System.err.println("\nThe specified file \"" + file.getAbsolutePath() + "\" cannot be found");
            MAIN_CONSOLE.println(" failed.\n");
            throw new InvalidArgumentException.UnexistentAlignmentFileException(file);
        }
        if (this.options.userTopologyExists) {
            object2 = this.options.getInputTreeFile();
            MAIN_CONSOLE.print("Reading tree file \"" + ((File)object2).getName() + "\"...");
            object = null;
            try {
                object = TreeUtilities.readTree(((File)object2).getAbsolutePath());
            }
            catch (IOException iOException) {
                System.err.println("\nThe specified tree file \"" + ((File)object2).getName() + "\" cannot be found");
                MAIN_CONSOLE.println(" failed.\n");
                throw new InvalidArgumentException.UnexistentTreeFileException(((File)object2).getAbsolutePath());
            }
            catch (TreeParseException treeParseException) {
                System.err.println("\nCannot parse tree file \"" + ((File)object2).getName() + "\"");
                MAIN_CONSOLE.println(" failed.\n");
                throw new InvalidArgumentException.InvalidTreeFileException(((File)object2).getAbsolutePath());
            }
            if (object != null) {
                this.options.setUserTree(TreeUtilities.toNewick((Tree)object, true, false, false));
                TextOutputStream textOutputStream = new TextOutputStream(this.options.getTreeFile().getAbsolutePath());
                textOutputStream.print(this.options.getUserTree());
                textOutputStream.close();
                MAIN_CONSOLE.println(" OK.");
            } else {
                System.err.println("\nUnexpected error parsing \"" + ((File)object2).getName() + "\"");
                MAIN_CONSOLE.println(" failed.\n");
                throw new InvalidArgumentException.InvalidTreeFileException(((File)object2).getAbsolutePath());
            }
        }
    }

    public static TextOutputStream setMainConsole(TextOutputStream textOutputStream) {
        MAIN_CONSOLE = textOutputStream;
        return textOutputStream;
    }

    public static TextOutputStream getMainConsole() {
        return MAIN_CONSOLE;
    }

    public static TextOutputStream setPhymlConsole(TextOutputStream textOutputStream) {
        PHYML_CONSOLE = textOutputStream;
        return textOutputStream;
    }

    public static TextOutputStream getPhymlConsole() {
        return PHYML_CONSOLE;
    }

    public static TextOutputStream getCurrentOutStream() {
        return CURRENT_OUT_STREAM;
    }

    public static void setCurrentOutStream(TextOutputStream textOutputStream) {
        CURRENT_OUT_STREAM = textOutputStream;
    }

    public static AIC getMyAIC() {
        if (!AICwasCalculated) {
            throw new WeakStateException.UninitializedCriterionException("AIC");
        }
        return myAIC;
    }

    public static void setMyAIC(AIC aIC) {
        myAIC = aIC;
        minAIC = aIC != null ? aIC.getMinModel() : null;
        AICwasCalculated = aIC != null;
    }

    public static boolean testAIC() {
        return AICwasCalculated;
    }

    public static AICc getMyAICc() {
        if (!AICcwasCalculated) {
            throw new WeakStateException.UninitializedCriterionException("AICc");
        }
        return myAICc;
    }

    public static void setMyAICc(AICc aICc) {
        myAICc = aICc;
        minAICc = aICc != null ? aICc.getMinModel() : null;
        AICcwasCalculated = aICc != null;
    }

    public static boolean testAICc() {
        return AICcwasCalculated;
    }

    public static BIC getMyBIC() {
        if (!BICwasCalculated) {
            throw new WeakStateException.UninitializedCriterionException("BIC");
        }
        return myBIC;
    }

    public static void setMyBIC(BIC bIC) {
        myBIC = bIC;
        minBIC = bIC != null ? bIC.getMinModel() : null;
        BICwasCalculated = bIC != null;
    }

    public static boolean testBIC() {
        return BICwasCalculated;
    }

    public static DT getMyDT() {
        if (!DTwasCalculated) {
            throw new WeakStateException.UninitializedCriterionException("DT");
        }
        return myDT;
    }

    public static void setMyDT(DT dT) {
        myDT = dT;
        minDT = dT != null ? dT.getMinModel() : null;
        DTwasCalculated = dT != null;
    }

    public static boolean testDT() {
        return DTwasCalculated;
    }

    public static RunConsense getConsensusAIC() {
        return consensusAIC;
    }

    public static RunConsense getConsensusAICc() {
        return consensusAICc;
    }

    public static RunConsense getConsensusBIC() {
        return consensusBIC;
    }

    public static RunConsense getConsensusDT() {
        return consensusDT;
    }

    public static void setConsensusAIC(RunConsense runConsense) {
        consensusAIC = runConsense;
    }

    public static void setConsensusAICc(RunConsense runConsense) {
        consensusAICc = runConsense;
    }

    public static void setConsensusBIC(RunConsense runConsense) {
        consensusBIC = runConsense;
    }

    public static void setConsensusDT(RunConsense runConsense) {
        consensusDT = runConsense;
    }

    public static void finalize(int n) {
        if (n != 0 && MPJ_RUN) {
            MPI.COMM_WORLD.Abort(n);
        }
        if (MPJ_RUN) {
            MPI.Finalize();
        }
        System.exit(n);
    }

    public static void setMinDLRT(Model model) {
        minDLRT = model;
    }

    public static Model getMinDLRT() {
        return minDLRT;
    }

    public static void setMinHLRT(Model model) {
        minHLRT = model;
    }

    public static Model getMinHLRT() {
        return minHLRT;
    }

    public static Model getMinDT() {
        return minDT;
    }

    public static Model getMinBIC() {
        return minBIC;
    }

    public static Model getMinAICc() {
        return minAICc;
    }

    public static Model getMinAIC() {
        return minAIC;
    }

    public static void setCandidateModels(Model[] modelArray) {
        ApplicationOptions.getInstance().setNumModels(modelArray.length);
        candidateModels = modelArray;
    }

    public static Model[] getLoadedModels() {
        return loadedModels;
    }

    public static Model[] getCandidateModels() {
        return candidateModels;
    }

    public static Model getCandidateModel(int n) {
        return candidateModels[n];
    }

    public static String getHostname() {
        return hostname;
    }

    public static void purgeModels() {
        ArrayList<Model> arrayList = new ArrayList<Model>();
        for (Model model : candidateModels) {
            if (!(model.getLnL() > 0.0)) continue;
            arrayList.add(model);
        }
        candidateModels = arrayList.toArray(new Model[0]);
        ApplicationOptions.getInstance().setNumModels(candidateModels.length);
    }

    static {
        CONFIG_FILE = "conf/jmodeltest.conf";
        PHYML_CONSOLE = null;
        AICwasCalculated = false;
        AICcwasCalculated = false;
        BICwasCalculated = false;
        DTwasCalculated = false;
        buildGUI = true;
        USERDEF_PROPERTIES = new Properties();
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            hostname = inetAddress.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            hostname = UNKNOWN_HOSTNAME;
            System.err.println("WARNING: This host is unknown");
        }
    }

    public class NullPrinter
    extends OutputStream {
        @Override
        public void write(int n) throws IOException {
        }
    }

    public static enum ExecMode {
        CONSOLE,
        GUI;

    }
}

