/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.jmodeltest;

import es.uvigo.darwin.jmodeltest.ModelTest;
import es.uvigo.darwin.jmodeltest.utilities.Utilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class ModelTestConfiguration {
    private static final Properties APPLICATION_PROPERTIES = new Properties();
    public static final boolean DEFAULT_GLOBAL_PHYML = false;
    private static String JAR_PATH;
    public static String PATH;
    public static String DEFAULT_EXE_DIR;
    public static String DEFAULT_LOG_DIR;
    public static final String HTML_LOG = "html-logging";
    public static final String PHYML_LOG = "phyml-logging";
    public static final String CKP_LOG = "checkpointing";
    public static final String LOG_DIR = "log-dir";
    public static final String EXE_DIR = "exe-dir";
    public static final String GLOBAL_PHYML_EXE = "global-phyml-exe";
    public static final String G_THREADS = "gamma-threads";
    public static final String I_THREADS = "inv-threads";
    public static final String U_THREADS = "uniform-threads";

    private static String convertPathToAbsolute(String string) {
        Object object;
        Map<String, String> map = System.getenv();
        String string2 = "\\$\\{([A-Za-z0-9]+)\\}";
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            object = map.get(matcher.group(1).toUpperCase());
            object = object == null ? "" : ((String)object).replace("\\", "\\\\");
            Pattern pattern2 = Pattern.compile(Pattern.quote(matcher.group(0)));
            string = pattern2.matcher(string).replaceAll((String)object);
        }
        if (Utilities.isWindows()) {
            string.replace('/', '\\');
        } else {
            object = new File(string);
            if (!((File)object).isAbsolute()) {
                string = PATH + string;
            }
        }
        return string;
    }

    public static boolean existsKey(String string) {
        return !ModelTestConfiguration.getProperty(string).equals("n/a");
    }

    public static String getProperty(String string) {
        return APPLICATION_PROPERTIES.getProperty(string, "n/a");
    }

    public static String getExeDir() {
        String string = ModelTestConfiguration.existsKey(EXE_DIR) ? ModelTestConfiguration.getProperty(EXE_DIR) : DEFAULT_EXE_DIR;
        return ModelTestConfiguration.convertPathToAbsolute(string);
    }

    public static void disableCkpLog() {
        APPLICATION_PROPERTIES.setProperty(CKP_LOG, "disabled");
    }

    public static void disablePhymlLog() {
        APPLICATION_PROPERTIES.setProperty(PHYML_LOG, "disabled");
    }

    public static void disableHtmlLog() {
        APPLICATION_PROPERTIES.setProperty(HTML_LOG, "disabled");
    }

    public static boolean isGlobalPhymlBinary() {
        String string = ModelTestConfiguration.getProperty(GLOBAL_PHYML_EXE);
        return ModelTestConfiguration.existsKey(string) && ModelTestConfiguration.getProperty(GLOBAL_PHYML_EXE).equalsIgnoreCase("true");
    }

    public static boolean isHtmlLogEnabled() {
        return ModelTestConfiguration.getProperty(HTML_LOG).equalsIgnoreCase("enabled");
    }

    public static boolean isPhymlLogEnabled() {
        return ModelTestConfiguration.getProperty(PHYML_LOG).equalsIgnoreCase("enabled");
    }

    public static boolean isCkpEnabled() {
        return ModelTestConfiguration.getProperty(CKP_LOG).equalsIgnoreCase("enabled");
    }

    public static String getLogDir() {
        String string = ModelTestConfiguration.getProperty(LOG_DIR);
        if (string == null) {
            string = DEFAULT_LOG_DIR;
        }
        return ModelTestConfiguration.convertPathToAbsolute(string);
    }

    public static Properties getProperties() {
        return APPLICATION_PROPERTIES;
    }

    static {
        try {
            Object object;
            try {
                object = new File(ModelTest.class.getProtectionDomain().getCodeSource().getLocation().toURI());
                JAR_PATH = ((File)object).getAbsolutePath();
                PATH = JAR_PATH.replaceFirst(new File(JAR_PATH).getName(), "");
                DEFAULT_EXE_DIR = PATH + "exe" + File.separator + "phyml";
                DEFAULT_LOG_DIR = PATH + "log";
            }
            catch (URISyntaxException uRISyntaxException) {
                uRISyntaxException.printStackTrace();
            }
            object = new FileInputStream(ModelTestConfiguration.convertPathToAbsolute(ModelTest.CONFIG_FILE));
            APPLICATION_PROPERTIES.load((InputStream)object);
            for (Object object2 : ModelTest.USERDEF_PROPERTIES.keySet()) {
                String string = (String)object2;
                if (string.equals(LOG_DIR) || string.equals(EXE_DIR)) {
                    File file = new File(ModelTest.USERDEF_PROPERTIES.getProperty(string));
                    if (!file.exists()) {
                        System.err.println("\nCOMMAND LINE ERROR: Unexistent directory " + file.getAbsolutePath());
                        ModelTest.CommandLineError();
                    } else if (!file.isDirectory() || !file.canRead() || string.equals(LOG_DIR) && !file.canWrite()) {
                        System.err.println("\nCOMMAND LINE ERROR: Argument " + file.getAbsolutePath() + " is not a directory or you have not the required permissions on it");
                        ModelTest.CommandLineError();
                    }
                    APPLICATION_PROPERTIES.setProperty(string, file.getAbsolutePath());
                    continue;
                }
                APPLICATION_PROPERTIES.setProperty(string, ModelTest.USERDEF_PROPERTIES.getProperty(string));
            }
            if (ModelTestConfiguration.existsKey(LOG_DIR)) {
                File file = new File(ModelTestConfiguration.getLogDir());
                if (!(!ModelTestConfiguration.isCkpEnabled() && !ModelTestConfiguration.isPhymlLogEnabled() && !ModelTestConfiguration.isHtmlLogEnabled() || file.exists() && file.canWrite())) {
                    System.err.println("WARNING: Cannot write in 'log' directory (" + ModelTestConfiguration.getLogDir() + "): All logging will be disabled");
                    System.err.println("         If you want to fix this warning, check 'conf/jmodeltest.conf'");
                    System.err.println("         Change the logging directory to where you have writing permission");
                    System.err.println("         or disable 'checkpointing', 'html-logging' and 'phyml-logging' properties\n");
                    ModelTestConfiguration.disableHtmlLog();
                    ModelTestConfiguration.disablePhymlLog();
                    ModelTestConfiguration.disableCkpLog();
                }
            } else {
                ModelTestConfiguration.disableHtmlLog();
                ModelTestConfiguration.disablePhymlLog();
                ModelTestConfiguration.disableCkpLog();
            }
        }
        catch (IOException iOException) {
            System.err.println("Configuration file (" + ModelTestConfiguration.convertPathToAbsolute(ModelTest.CONFIG_FILE) + ") cannot be resolved");
            System.exit(-1);
        }
    }
}

