/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.jmodeltest.exe;

import java.util.ArrayList;
import java.util.Collection;

public class ExternalExecutionManager {
    private static ExternalExecutionManager instance;
    private final Collection<Process> processes = new ArrayList<Process>();

    private ExternalExecutionManager() {
    }

    public static ExternalExecutionManager getInstance() {
        if (instance == null) {
            instance = new ExternalExecutionManager();
        }
        return instance;
    }

    public boolean addProcess(Process process) {
        boolean bl = false;
        if (!this.processes.contains(process)) {
            bl = this.processes.add(process);
        }
        return bl;
    }

    public boolean removeProcess(Process process) {
        boolean bl = false;
        if (this.processes.contains(process)) {
            bl = this.processes.remove(process);
        }
        return bl;
    }

    public void killProcesses() {
        for (final Process process : this.processes) {
            if (process == null) continue;
            try {
                process.exitValue();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                    @Override
                    public void run() {
                        process.destroy();
                    }
                }));
            }
        }
        this.processes.clear();
    }
}

