/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.jmodeltest.exe;

import es.uvigo.darwin.jmodeltest.ModelTest;
import es.uvigo.darwin.jmodeltest.ModelTestConfiguration;
import es.uvigo.darwin.jmodeltest.exe.RunPhymlHybrid;
import es.uvigo.darwin.jmodeltest.model.Model;
import es.uvigo.darwin.jmodeltest.model.ModelComparator;
import es.uvigo.darwin.jmodeltest.observer.ProgressInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Observable;
import javax.management.RuntimeErrorException;
import mpi.MPI;
import mpi.Request;
import mpi.Status;

public class MultipleDistributor
extends Observable
implements Runnable {
    public static final int BIG = 999;
    public static final int DEFAULT_PROCESSORS_IG = 4;
    public static final int DEFAULT_PROCESSORS_I = 2;
    public static final int DEFAULT_PROCESSORS_UNIFORM = 1;
    public static int PROCESSORS_IG;
    public static int PROCESSORS_I;
    public static int PROCESSORS_UNIFORM;
    public static final int TAG_SEND_REQUEST = 1;
    public static final int TAG_SEND_MODEL = 2;
    public static final int TAG_EXIST_MORE_MODELS = 3;
    private List<Model> modelsToSend;
    private RunPhymlHybrid caller;
    private static boolean assumeHyperThreading;
    private static boolean homogeneousDistribution;
    private int mpjMe;
    private int mpjSize;
    private static int numberOfHosts;
    private static int totalNumberOfThreads;
    private static int minProcs;
    private static int maxProcs;
    private static float avgProcs;
    private int[] itemsPerProc;
    private int[] displs;

    public MultipleDistributor(List<Model> list, RunPhymlHybrid runPhymlHybrid, int n, int n2) {
        this.mpjMe = n;
        this.mpjSize = n2;
        this.modelsToSend = new ArrayList<Model>(list);
        this.caller = runPhymlHybrid;
        this.itemsPerProc = new int[n2];
        this.displs = new int[n2];
        if (ModelTest.HOSTS_TABLE != null) {
            numberOfHosts = ModelTest.HOSTS_TABLE.size();
            Enumeration<Integer> enumeration = ModelTest.HOSTS_TABLE.elements();
            while (enumeration.hasMoreElements()) {
                int n3 = enumeration.nextElement();
                totalNumberOfThreads += n3;
                if (n3 < minProcs) {
                    minProcs = n3;
                }
                if (n3 <= maxProcs) continue;
                maxProcs = n3;
            }
            homogeneousDistribution = minProcs == maxProcs;
            assumeHyperThreading = maxProcs > 8;
            avgProcs = totalNumberOfThreads / numberOfHosts;
        } else {
            homogeneousDistribution = true;
            assumeHyperThreading = false;
            avgProcs = 1.0f;
        }
        Collections.sort(this.modelsToSend, new ModelComparator());
    }

    public void distribute(List<Model> list) throws InterruptedException {
        Object object;
        this.itemsPerProc = new int[this.mpjSize];
        Status status = null;
        this.displs = new int[this.mpjSize];
        int[] nArray = new int[2];
        boolean bl = true;
        Request request = null;
        while (!this.modelsToSend.isEmpty()) {
            Object object2;
            if (this.caller.rootModelRequest && this.caller.availablePEs > 0) {
                object2 = this.getNextModel(this.caller.availablePEs, this.caller.maxPEs);
                if (object2 == null) continue;
                this.caller.rootModel = object2;
                this.caller.rootModelRequest = false;
                int n = this.mpjMe;
                this.itemsPerProc[n] = this.itemsPerProc[n] + 1;
                continue;
            }
            if (bl) {
                request = MPI.COMM_WORLD.Irecv(nArray, 0, 2, MPI.INT, MPI.ANY_SOURCE, 1);
                bl = false;
            }
            if ((status = request.Test()) != null) {
                object2 = MPI.COMM_WORLD.Isend(new boolean[]{true}, 0, 1, MPI.BOOLEAN, status.source, 3);
                object = new Model[1];
                ((Request)object2).Wait();
                object[0] = this.getNextModel(nArray[0], nArray[1]);
                Request request2 = MPI.COMM_WORLD.Isend(object, 0, 1, MPI.OBJECT, status.source, 2);
                if (object[0] != null) {
                    int n = status.source;
                    this.itemsPerProc[n] = this.itemsPerProc[n] + 1;
                }
                request2.Wait();
                bl = true;
                status = null;
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        this.displs[0] = 0;
        for (int i = 1; i < this.mpjSize; ++i) {
            this.displs[i] = this.displs[i - 1] + this.itemsPerProc[i - 1];
        }
        while (!this.caller.rootModelRequest) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        this.caller.rootModel = null;
        this.caller.rootModelRequest = false;
        for (int i = 1; i < this.mpjSize; ++i) {
            request = MPI.COMM_WORLD.Irecv(nArray, 0, 2, MPI.INT, MPI.ANY_SOURCE, 1);
            status = request.Wait();
            object = MPI.COMM_WORLD.Isend(new boolean[]{false}, 0, 1, MPI.BOOLEAN, status.source, 3);
            ((Request)object).Wait();
        }
    }

    public int[] getItemsPerProc() {
        return this.itemsPerProc;
    }

    public int[] getDispls() {
        return this.displs;
    }

    @Override
    public void run() {
        try {
            this.distribute(this.modelsToSend);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            throw new RuntimeErrorException(new Error(interruptedException));
        }
    }

    private Model getNextModel(int n, int n2) {
        Model model = null;
        for (Model model2 : this.modelsToSend) {
            if (MultipleDistributor.getPEs(model2, n2) > n || !homogeneousDistribution && !((float)n2 >= avgProcs)) continue;
            model = model2;
            break;
        }
        if (model == null && !homogeneousDistribution && (float)n2 < avgProcs && !this.modelsToSend.isEmpty()) {
            for (Model model2 : this.modelsToSend) {
                if (MultipleDistributor.getPEs(model2, n2) > n) continue;
                model = model2;
                break;
            }
        }
        this.modelsToSend.remove(model);
        return model;
    }

    public static int getPEs(Model model, int n) {
        int n2 = model.ispG() ? PROCESSORS_IG : (model.ispI() ? PROCESSORS_I : PROCESSORS_UNIFORM);
        if (assumeHyperThreading && n > 8) {
            n2 *= 2;
        }
        return Math.min(n, n2);
    }

    private void notifyObservers(int n, int n2, Model model, String string) {
        this.setChanged();
        this.notifyObservers(new ProgressInfo(n, n2, model, string));
    }

    static {
        totalNumberOfThreads = 0;
        minProcs = 999;
        maxProcs = 0;
        String string = ModelTestConfiguration.getProperty("gamma-threads");
        String string2 = ModelTestConfiguration.getProperty("inv-threads");
        String string3 = ModelTestConfiguration.getProperty("uniform-threads");
        try {
            PROCESSORS_IG = Integer.parseInt(string != null ? string : String.valueOf(4));
            PROCESSORS_I = Integer.parseInt(string2 != null ? string2 : String.valueOf(2));
            PROCESSORS_UNIFORM = Integer.parseInt(string3 != null ? string3 : String.valueOf(1));
        }
        catch (NumberFormatException numberFormatException) {
            PROCESSORS_IG = 4;
            PROCESSORS_I = 2;
            PROCESSORS_UNIFORM = 1;
        }
    }
}

