/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.jmodeltest.exe;

import es.uvigo.darwin.jmodeltest.ApplicationOptions;
import es.uvigo.darwin.jmodeltest.ModelTest;
import es.uvigo.darwin.jmodeltest.ModelTestConfiguration;
import es.uvigo.darwin.jmodeltest.exe.GuidedSearchManager;
import es.uvigo.darwin.jmodeltest.exe.PhymlSingleModel;
import es.uvigo.darwin.jmodeltest.io.TextOutputStream;
import es.uvigo.darwin.jmodeltest.model.Model;
import es.uvigo.darwin.jmodeltest.model.ModelComparator;
import es.uvigo.darwin.jmodeltest.observer.ProgressInfo;
import es.uvigo.darwin.jmodeltest.utilities.Utilities;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public abstract class RunPhyml
extends Observable
implements Observer {
    private static final boolean filterFrequencies = true;
    private static final boolean filterRateMatrix = true;
    private static final boolean filterRateVariation = true;
    protected ApplicationOptions options;
    protected Model[] models;
    protected Model gtrModel = null;
    public static final String[] COMPATIBLE_VERSIONS = new String[]{"20130103", "20131022", "20141009", "20141029", "20150501", "20151222"};
    public static String PHYML_VERSION = "3.0";
    public static String PHYML_TREE_SUFFIX = "_phyml_tree_";
    public static String PHYML_STATS_SUFFIX = "_phyml_stats_";
    public static File phymlBinary;
    public static String phymlBinaryStr;
    private static String CURRENT_DIRECTORY;
    private static boolean PHYML_GLOBAL;
    public static String PHYML_PATH;
    private static boolean compatiblePhyml;
    protected Observer progress;

    public static boolean isCompatible() {
        return compatiblePhyml;
    }

    public static boolean checkBinary() {
        boolean bl = false;
        if (!ModelTestConfiguration.isGlobalPhymlBinary()) {
            if (!phymlBinary.exists()) {
                Utilities.printRed("ERROR: PhyML binary cannot be found: " + phymlBinary.getAbsolutePath() + "\n");
            } else if (!phymlBinary.canExecute()) {
                Utilities.printRed("ERROR: PhyML binary exists, but it cannot be executed: " + phymlBinary.getAbsolutePath() + "\n");
            } else if (!RunPhyml.isCompatible()) {
                Utilities.printRed("WARNING: PhyML binary is not in the list of compatibility: \n");
                Utilities.printRed(phymlBinary.getAbsolutePath() + " v" + PHYML_VERSION + "\n");
                Utilities.printRed("Compatible versions: ");
                for (int i = 0; i < COMPATIBLE_VERSIONS.length; ++i) {
                    Utilities.printBlue(COMPATIBLE_VERSIONS[i] + " ");
                }
                Utilities.printBlue("\n");
                Utilities.printRed("jModelTest will try to continue execution anyway, but it might fail.\n");
                bl = true;
            } else {
                Utilities.printBlue("PhyML binary: " + phymlBinary.getAbsolutePath() + " v" + PHYML_VERSION + "\n");
                bl = true;
            }
        }
        return bl;
    }

    private static boolean checkPhymlCompatibility(String string) {
        boolean bl = false;
        if (Utilities.findCurrentOS() != 1) {
            return false;
        }
        String[] stringArray = new String[]{string, "--version"};
        Runtime runtime = Runtime.getRuntime();
        try {
            Process process = runtime.exec(stringArray, null, null);
            InputStream inputStream = process.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                String string3;
                if (!string2.toLowerCase().contains("phyml version")) continue;
                String[] stringArray2 = string2.trim().replace(".", "").split(" ");
                PHYML_VERSION = string3 = stringArray2[stringArray2.length - 1];
                compatiblePhyml = Arrays.asList(COMPATIBLE_VERSIONS).contains(string3);
                bl = true;
            }
            bufferedReader.close();
            inputStreamReader.close();
            inputStream.close();
            process.destroy();
        }
        catch (IOException iOException) {
            return false;
        }
        return bl;
    }

    public static boolean isPhymlGlobal() {
        return PHYML_GLOBAL;
    }

    public RunPhyml(Observer observer, ApplicationOptions applicationOptions, Model[] modelArray) {
        this.models = modelArray != null ? new Model[modelArray.length] : new Model[0];
        for (int i = 0; i < this.models.length; ++i) {
            this.models[i] = modelArray[i];
        }
        this.options = applicationOptions;
        this.progress = observer;
        this.addObserver(observer);
        Arrays.sort(this.models, new ModelComparator());
    }

    public void execute() {
        Object object;
        int n;
        String string;
        this.deleteFiles();
        this.printSettings(ModelTest.getMainConsole());
        if (this.options.doI && this.options.doG) {
            string = "GTR+I+G";
            n = 10;
        } else if (this.options.doI) {
            string = "GTR+I";
            n = 9;
        } else if (this.options.doG) {
            string = "GTR+G";
            n = 9;
        } else {
            string = "GTR";
            n = 8;
        }
        for (int i = this.models.length - 1; i >= 0; --i) {
            if (!this.models[i].getName().startsWith(string)) continue;
            this.gtrModel = this.models[i];
            break;
        }
        if (this.gtrModel == null) {
            this.gtrModel = new Model(0, string, "012345", n, false, false, false, true, this.options.doI, this.options.doG, 2, 4);
        }
        if (this.options.fixedTopology) {
            Model model = null;
            for (Model model2 : this.models) {
                if (!model2.getName().equals("JC")) continue;
                model = model2;
                break;
            }
            if (model != null) {
                this.notifyObservers(1, 0, model, null);
                object = new PhymlSingleModel(model, 0, true, false, this.options);
                ((Observable)object).addObserver(this);
                ((PhymlSingleModel)object).run();
                TextOutputStream textOutputStream = new TextOutputStream(this.options.getTreeFile().getAbsolutePath(), false);
                textOutputStream.print(model.getTreeString() + "\n");
                textOutputStream.close();
                this.notifyObservers(2, 0, model, null);
            }
        }
        if (this.options.isGuidedSearch()) {
            if (this.gtrModel != null) {
                this.notifyObservers(10, this.models.length, this.gtrModel, null);
                PhymlSingleModel phymlSingleModel = new PhymlSingleModel(this.gtrModel, 0, false, false, this.options);
                phymlSingleModel.run();
                this.notifyObservers(11, this.models.length, this.gtrModel, null);
                object = new GuidedSearchManager(this.options.getGuidedSearchThreshold(), this.gtrModel, true, true, true);
                this.models = ((GuidedSearchManager)object).filterModels(this.models);
                ModelTest.setCandidateModels(this.models);
            } else {
                this.notifyObservers(12, this.models.length, this.models[0], null);
            }
        }
        this.notifyObservers(3, 0, this.models[0], null);
        this.doPhyml();
    }

    public void executeIgnoreGaps(Model[] modelArray) {
        this.notifyObservers(8, modelArray.length, modelArray[0], null);
        this.parallelExecute(modelArray, true);
        this.notifyObservers(9, modelArray.length, null, null);
    }

    protected boolean parallelExecute(Model[] modelArray, boolean bl) {
        ExecutorService executorService = Executors.newFixedThreadPool(this.options.getNumberOfThreads());
        ArrayList<Callable<Object>> arrayList = new ArrayList<Callable<Object>>();
        int n = 0;
        for (Model model : modelArray) {
            if (model == null) continue;
            PhymlSingleModel phymlSingleModel = new PhymlSingleModel(model, n, false, bl, this.options);
            phymlSingleModel.addObserver(this);
            arrayList.add(Executors.callable(phymlSingleModel));
            ++n;
        }
        Object object = null;
        try {
            object = executorService.invokeAll(arrayList);
        }
        catch (InterruptedException interruptedException) {
            this.notifyObservers(20, 0, null, null);
        }
        if (object != null) {
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Future future = (Future)iterator.next();
                try {
                    future.get();
                }
                catch (InterruptedException interruptedException) {
                    this.notifyObservers(20, 0, null, null);
                    interruptedException.printStackTrace();
                    return false;
                }
                catch (ExecutionException executionException) {
                    executionException.printStackTrace();
                    return false;
                }
            }
        }
        return true;
    }

    protected void printSettings(TextOutputStream textOutputStream) {
        textOutputStream.println(" ");
        textOutputStream.println(" ");
        textOutputStream.println("---------------------------------------------------------------");
        textOutputStream.println("*                                                             *");
        textOutputStream.println("*        COMPUTATION OF LIKELIHOOD SCORES WITH PHYML          *");
        textOutputStream.println("*                                                             *");
        textOutputStream.println("---------------------------------------------------------------");
        textOutputStream.println(" ");
        textOutputStream.println("::Settings::");
        textOutputStream.println(" ");
        textOutputStream.println(" Phyml version = " + PHYML_VERSION);
        textOutputStream.println(" Phyml binary = " + phymlBinary.getName());
        textOutputStream.println(" Phyml path = " + phymlBinary.getAbsolutePath().substring(0, phymlBinary.getAbsolutePath().lastIndexOf(File.separator)) + File.separator);
        textOutputStream.println(" Candidate models = " + this.models.length);
        textOutputStream.print("   number of substitution schemes = ");
        if (this.options.getSubstTypeCode() == 0) {
            textOutputStream.println("3");
        } else if (this.options.getSubstTypeCode() == 1) {
            textOutputStream.println("5");
        } else if (this.options.getSubstTypeCode() == 2) {
            textOutputStream.println("7");
        } else {
            textOutputStream.println("11");
        }
        if (this.options.doF) {
            textOutputStream.println("   including models with equal/unequal base frequencies (+F)");
        } else {
            textOutputStream.println("   including only models with equal base frequencies");
        }
        if (this.options.doI) {
            textOutputStream.println("   including models with/without a proportion of invariable sites (+I)");
        } else {
            textOutputStream.println("   including only models without a proportion of invariable sites");
        }
        if (this.options.doG) {
            textOutputStream.println("   including models with/without rate variation among sites (+G) (nCat = " + this.options.numGammaCat + ")");
        } else {
            textOutputStream.println("   including only models without rate variation among sites");
        }
        textOutputStream.print(" Optimized free parameters (K) =");
        textOutputStream.print(" substitution parameters");
        if (this.options.countBLasParameters) {
            textOutputStream.print(" + " + this.options.getNumBranches() + " branch lengths");
        }
        if (this.options.optimizeMLTopology) {
            textOutputStream.print(" + topology");
        }
        textOutputStream.println(" ");
        textOutputStream.print(" Base tree for likelihood calculations = ");
        if (this.options.userTopologyExists) {
            textOutputStream.println("fixed user tree topology.");
            textOutputStream.println(" ");
            textOutputStream.print("User tree (" + this.options.getInputTreeFile().getName() + ") = ");
            textOutputStream.println(this.options.getUserTree());
            textOutputStream.println(" ");
        } else if (this.options.fixedTopology) {
            textOutputStream.println("fixed BIONJ-JC tree topology");
        } else if (this.options.optimizeMLTopology) {
            textOutputStream.println("ML tree");
        } else {
            textOutputStream.println("BIONJ tree");
        }
        if (this.options.optimizeMLTopology) {
            textOutputStream.print(" Tree topology search operation = ");
            switch (this.options.treeSearchOperations) {
                case NNI: {
                    textOutputStream.println("NNI");
                    break;
                }
                case SPR: {
                    textOutputStream.println("SPR");
                    break;
                }
                case BEST: {
                    textOutputStream.println("BEST");
                }
            }
        }
        if (this.options.isClusteringSearch()) {
            textOutputStream.println(" Using hill-climbing hierarchical clustering");
        }
        if (this.options.isGuidedSearch()) {
            textOutputStream.println(" Using heuristic model filtering ");
        }
        textOutputStream.println(" ");
    }

    protected abstract Object doPhyml();

    public void interruptThread() {
        this.notifyObservers(7, 0, null, null);
    }

    private void deleteFiles() {
        this.options.getLogFile().delete();
    }

    protected void notifyObservers(int n, int n2, Model model, String string) {
        this.setChanged();
        this.notifyObservers(new ProgressInfo(n, n2, model, string));
    }

    @Override
    public void update(Observable observable, Object object) {
        this.setChanged();
        this.notifyObservers(object);
    }

    static {
        CURRENT_DIRECTORY = ModelTestConfiguration.PATH;
        PHYML_GLOBAL = ModelTestConfiguration.isGlobalPhymlBinary();
        PHYML_PATH = CURRENT_DIRECTORY + "exe/phyml/";
        compatiblePhyml = false;
        if (PHYML_GLOBAL) {
            PHYML_PATH = "";
            phymlBinaryStr = "phyml";
        } else {
            String string = ModelTestConfiguration.getExeDir();
            PHYML_PATH = !string.startsWith(File.separator) ? CURRENT_DIRECTORY + File.separator + string : string;
            if (!PHYML_PATH.endsWith(File.separator)) {
                PHYML_PATH = PHYML_PATH + File.separator;
            }
            if ((phymlBinary = new File(PHYML_PATH + "phyml")).exists() && phymlBinary.canExecute()) {
                phymlBinaryStr = phymlBinary.getAbsolutePath();
                compatiblePhyml = true;
            } else {
                phymlBinaryStr = PHYML_PATH + Utilities.getBinaryVersion();
            }
            phymlBinary = new File(phymlBinaryStr);
            if (!(RunPhyml.checkPhymlCompatibility(phymlBinaryStr) || phymlBinary.exists() && phymlBinary.canExecute() || !RunPhyml.checkPhymlCompatibility("/usr/bin/phyml"))) {
                PHYML_PATH = "/usr/bin";
                phymlBinary = new File(PHYML_PATH + "/phyml");
                phymlBinaryStr = phymlBinary.getAbsolutePath();
            }
        }
    }
}

