/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.jmodeltest.exe;

import es.uvigo.darwin.jmodeltest.ApplicationOptions;
import es.uvigo.darwin.jmodeltest.ModelTest;
import es.uvigo.darwin.jmodeltest.exe.GuidedSearchManager;
import es.uvigo.darwin.jmodeltest.exe.PhymlSingleModel;
import es.uvigo.darwin.jmodeltest.exe.ProcessManager;
import es.uvigo.darwin.jmodeltest.exe.RunPhyml;
import es.uvigo.darwin.jmodeltest.model.Model;
import es.uvigo.darwin.jmodeltest.observer.ProgressInfo;
import es.uvigo.darwin.jmodeltest.selection.AIC;
import es.uvigo.darwin.jmodeltest.selection.AICc;
import es.uvigo.darwin.jmodeltest.selection.BIC;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class RunPhymlThread
extends RunPhyml {
    private ExecutorService threadPool;
    private int currentStage;
    private int numModelsInStage;

    public RunPhymlThread(Observer observer, ApplicationOptions applicationOptions, Model[] modelArray) {
        super(observer, applicationOptions, modelArray);
        this.threadPool = Executors.newFixedThreadPool(applicationOptions.getNumberOfThreads());
    }

    @Override
    protected Object doPhyml() {
        boolean bl = false;
        if (this.options.isClusteringSearch()) {
            ArrayList<Model> arrayList = new ArrayList<Model>();
            arrayList.add(this.gtrModel);
            Model model = this.gtrModel;
            if (this.gtrModel == null) {
                model = this.models[this.models.length - 1];
            }
            double d = Double.MAX_VALUE;
            for (int i = 6; i > 0; --i) {
                double d2 = Double.MAX_VALUE;
                String string = model == null ? "012345" : model.getPartition();
                Model[] modelArray = GuidedSearchManager.getModelsSubset(this.models, string, i);
                this.currentStage = 7 - i;
                this.numModelsInStage = modelArray.length;
                if (modelArray.length <= 0) continue;
                Model model2 = modelArray[0];
                bl |= !this.parallelExecute(modelArray, false);
                for (Model model3 : modelArray) {
                    double d3 = Double.MAX_VALUE;
                    switch (this.options.getHeuristicInformationCriterion()) {
                        case 1: {
                            d3 = AIC.computeAic(model3, this.options);
                            break;
                        }
                        case 3: {
                            d3 = BIC.computeBic(model3, this.options);
                            break;
                        }
                        case 2: {
                            d3 = AICc.computeAicc(model3, this.options);
                        }
                    }
                    if (!(d3 < d2)) continue;
                    model2 = model3;
                    d2 = d3;
                }
                if (model.getLnL() > 0.0 && d2 > d) break;
                model = model2;
                d = d2;
            }
            ModelTest.purgeModels();
        } else {
            boolean bl2 = bl = !this.parallelExecute(this.models, false);
        }
        if (bl) {
            this.notifyObservers(7, this.models.length, null, null);
            return "Interrupted";
        }
        this.notifyObservers(6, this.models.length, null, null);
        return "All Done";
    }

    @Override
    protected boolean parallelExecute(Model[] modelArray, boolean bl) {
        ArrayList<Callable<Object>> arrayList = new ArrayList<Callable<Object>>();
        int n = 0;
        for (Model model : modelArray) {
            if (model == null) continue;
            PhymlSingleModel phymlSingleModel = new PhymlSingleModel(model, n, false, bl, this.options);
            phymlSingleModel.addObserver(this);
            arrayList.add(Executors.callable(phymlSingleModel));
            ++n;
        }
        Object object = null;
        try {
            object = this.threadPool.invokeAll(arrayList);
        }
        catch (InterruptedException interruptedException) {
            this.notifyObservers(20, 0, null, null);
        }
        if (object != null) {
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Future future = (Future)iterator.next();
                try {
                    future.get();
                }
                catch (InterruptedException interruptedException) {
                    this.notifyObservers(20, 0, null, null);
                    interruptedException.printStackTrace();
                    return false;
                }
                catch (ExecutionException executionException) {
                    executionException.printStackTrace();
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void interruptThread() {
        super.interruptThread();
        ProcessManager.getInstance().killAll();
        this.threadPool.shutdownNow();
    }

    @Override
    public void update(Observable observable, Object object) {
        if (object != null) {
            ProgressInfo progressInfo = (ProgressInfo)object;
            if (progressInfo.getType() == 21 || progressInfo.getType() == 23 || progressInfo.getType() == 22) {
                this.interruptThread();
            } else if (this.options.isClusteringSearch()) {
                progressInfo.setHeuristicStage(this.currentStage);
                progressInfo.setNumModelsInStage(this.numModelsInStage);
            }
        }
        super.update(observable, object);
    }
}

