/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.jmodeltest.gui;

import es.uvigo.darwin.jmodeltest.ApplicationOptions;
import es.uvigo.darwin.jmodeltest.ModelTest;
import es.uvigo.darwin.jmodeltest.exe.RunPhyml;
import es.uvigo.darwin.jmodeltest.exe.RunPhymlThread;
import es.uvigo.darwin.jmodeltest.gui.Frame_Progress;
import es.uvigo.darwin.jmodeltest.gui.JModelTestFrame;
import es.uvigo.darwin.jmodeltest.gui.XManager;
import es.uvigo.darwin.jmodeltest.io.TextOutputStream;
import es.uvigo.darwin.jmodeltest.threads.SwingWorker;
import es.uvigo.darwin.jmodeltest.tree.TreeUtilities;
import es.uvigo.darwin.jmodeltest.utilities.Utilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.BorderUIResource;
import pal.tree.Tree;
import pal.tree.TreeParseException;

public class Frame_CalcLike
extends JModelTestFrame {
    private static final long serialVersionUID = 201103091058L;
    private static final int TOTAL_NUMBER_OF_THREADS;
    private static final int DEFAULT_NUMBER_OF_THREADS;
    private static final int DEFAULT_THRESHOLD = 100;
    private static final int PANEL_X = 10;
    private static final int PANEL_PROCESSORS_Y = 10;
    private static final int PANEL_HEURISTICS_Y = 100;
    private static final int PANEL_CALCLIKE_Y = 230;
    private ApplicationOptions options = ApplicationOptions.getInstance();
    private JPanel PanelProcessors = new JPanel();
    private JSlider SliderProcessors = new JSlider(1, TOTAL_NUMBER_OF_THREADS, DEFAULT_NUMBER_OF_THREADS);
    private JLabel jLabelNumProcessors = new JLabel();
    private JPanel PanelHeuristics = new JPanel();
    private JRadioButton ButtonAICClustering = new JRadioButton();
    private JRadioButton ButtonAICcClustering = new JRadioButton();
    private JRadioButton ButtonBICClustering = new JRadioButton();
    private ButtonGroup ButtonGroupClusteringIC = new ButtonGroup();
    private JPanel PanelCalcLike = new JPanel();
    JButton RunButtonCalcLike = new JButton();
    private JButton CancelButtonCalcLike = new JButton();
    private JButton JButtonDefaultCalcLike = new JButton();
    private JPanel PanelNumberModelsCalcLike = new JPanel();
    private JRadioButton Button3SubsTypeCalcLike = new JRadioButton();
    private JRadioButton Button5SubsTypeCalcLike = new JRadioButton();
    private JRadioButton Button7SubsTypeCalcLike = new JRadioButton();
    private JRadioButton Button11SubsTypeCalcLike = new JRadioButton();
    private JRadioButton Button203SubsTypeCalcLike = new JRadioButton();
    private JCheckBox jCheckBoxModelFiltering = new JCheckBox();
    private JLabel jLabelThreshold = new JLabel();
    private JCheckBox jCheckBoxClustering = new JCheckBox();
    private JSlider SliderThreshold = new JSlider(1, 1000, 100);
    private JPanel PanelFrequenciesCalcLike = new JPanel();
    private JCheckBox jCheckBoxFrequencies = new JCheckBox();
    private JPanel PanelRateVariationCalcLike = new JPanel();
    private JCheckBox jCheckBoxPinv = new JCheckBox();
    private JCheckBox jCheckBoxGamma = new JCheckBox();
    private JTextField TextFieldNcat = new JTextField();
    private JPanel PanelTreeOptimizationCalcLike = new JPanel();
    private JPanel PanelTreeOptimizationMethod = new JPanel();
    private JRadioButton ButtonFixedCalcLike = new JRadioButton();
    private JRadioButton ButtonBIONJCalcLike = new JRadioButton();
    private JRadioButton ButtonMLCalcLike = new JRadioButton();
    private JRadioButton ButtonFixedUserTopologyCalcLike = new JRadioButton();
    private JRadioButton ButtonNNICalcLike = new JRadioButton();
    private JRadioButton ButtonSPRCalcLike = new JRadioButton();
    private JRadioButton ButtonBestCalcLike = new JRadioButton();
    private ButtonGroup ButtonGroupTreeOptimizationCalcLike = new ButtonGroup();
    private ButtonGroup ButtonGroupNumberModelsCalcLike = new ButtonGroup();
    private ButtonGroup ButtonGroupTreeSearchCalcLike = new ButtonGroup();
    private JLabel jLabelNumModels = new JLabel();
    private JLabel jLabelUserTree = new JLabel();
    private JLabel jLabelUserTopology = new JLabel();
    private Frame_Progress progressFrame;
    private RunPhyml runPhyml;
    private ComputeLikelihoodTask task;
    private boolean mShown = false;

    public void cancelTask() {
        this.task.interrupt();
    }

    public RunPhyml getRunPhyml() {
        return this.runPhyml;
    }

    public void initComponents() throws Exception {
        this.PanelProcessors.setLocation(10, 10);
        this.PanelProcessors.setSize(460, 80);
        this.PanelProcessors.setBorder(new BorderUIResource.TitledBorderUIResource(new LineBorder(XManager.PANEL_BORDER_COLOR, 1, false), "Number of processors requested", 4, 2, XManager.FONT_LABEL, XManager.LABEL_BLUE_COLOR));
        this.PanelProcessors.setVisible(true);
        this.PanelProcessors.setLayout(null);
        this.SliderProcessors.setValue(this.SliderProcessors.getMaximum());
        this.SliderProcessors.setLocation(10, 20);
        this.SliderProcessors.setSize(400, 45);
        this.jLabelNumProcessors.setText(String.valueOf(this.SliderProcessors.getValue()));
        this.jLabelNumProcessors.setLocation(420, 25);
        this.jLabelNumProcessors.setSize(20, 40);
        this.PanelProcessors.add(this.SliderProcessors);
        this.PanelProcessors.add(this.jLabelNumProcessors);
        this.PanelHeuristics.setLocation(10, 100);
        this.PanelHeuristics.setSize(460, 120);
        this.PanelHeuristics.setBorder(new BorderUIResource.TitledBorderUIResource(new LineBorder(XManager.PANEL_BORDER_COLOR, 1, false), "Heuristics", 4, 2, XManager.FONT_LABEL, XManager.LABEL_BLUE_COLOR));
        this.PanelHeuristics.setVisible(true);
        this.PanelHeuristics.setLayout(null);
        this.jCheckBoxClustering.setEnabled(false);
        this.jCheckBoxClustering.setText("Clustering");
        this.jCheckBoxClustering.setSelected(false);
        this.jCheckBoxClustering.setLocation(10, 30);
        this.jCheckBoxClustering.setSize(150, 20);
        this.jCheckBoxClustering.setVisible(true);
        this.ButtonAICClustering.setText("AIC");
        this.ButtonAICClustering.setLocation(180, 30);
        this.ButtonAICClustering.setSize(70, 20);
        this.ButtonAICClustering.setVisible(true);
        this.ButtonAICClustering.setEnabled(this.jCheckBoxClustering.isSelected());
        this.ButtonAICClustering.setToolTipText("Use AIC for clustering next-step best model selection");
        this.ButtonAICcClustering.setText("AICc");
        this.ButtonAICcClustering.setLocation(250, 30);
        this.ButtonAICcClustering.setSize(70, 20);
        this.ButtonAICcClustering.setVisible(true);
        this.ButtonAICcClustering.setToolTipText("Use AICc for clustering next-step best model selection");
        this.ButtonAICcClustering.setEnabled(this.jCheckBoxClustering.isSelected());
        this.ButtonBICClustering.setText("BIC");
        this.ButtonBICClustering.setLocation(320, 30);
        this.ButtonBICClustering.setSize(70, 20);
        this.ButtonBICClustering.setVisible(true);
        this.ButtonBICClustering.setSelected(true);
        this.ButtonBICClustering.setToolTipText("Use BIC for clustering next-step best model selection");
        this.ButtonBICClustering.setEnabled(this.jCheckBoxClustering.isSelected());
        this.ButtonGroupClusteringIC.add(this.ButtonAICClustering);
        this.ButtonGroupClusteringIC.add(this.ButtonAICcClustering);
        this.ButtonGroupClusteringIC.add(this.ButtonBICClustering);
        this.jCheckBoxModelFiltering.setEnabled(true);
        this.jCheckBoxModelFiltering.setText("Model Filtering");
        this.jCheckBoxModelFiltering.setSelected(false);
        this.jCheckBoxModelFiltering.setLocation(10, 75);
        this.jCheckBoxModelFiltering.setSize(140, 20);
        this.jCheckBoxModelFiltering.setVisible(true);
        this.jLabelThreshold.setText(Utilities.format((double)this.SliderThreshold.getValue() / 1000.0, 5, 3, false));
        this.jLabelThreshold.setLocation(400, 65);
        this.jLabelThreshold.setSize(60, 40);
        this.jLabelThreshold.setEnabled(this.jCheckBoxModelFiltering.isSelected());
        this.jLabelThreshold.setVisible(true);
        this.SliderThreshold.setEnabled(this.jCheckBoxModelFiltering.isSelected());
        this.SliderThreshold.setLocation(150, 65);
        this.SliderThreshold.setSize(240, 45);
        this.SliderThreshold.setValue(100);
        this.SliderThreshold.setVisible(true);
        this.SliderThreshold.setToolTipText("Model filtering threshold");
        this.PanelHeuristics.add(this.jCheckBoxClustering);
        this.PanelHeuristics.add(this.jCheckBoxModelFiltering);
        this.PanelHeuristics.add(this.SliderThreshold);
        this.PanelHeuristics.add(this.jLabelThreshold);
        this.PanelHeuristics.add(this.ButtonAICClustering);
        this.PanelHeuristics.add(this.ButtonAICcClustering);
        this.PanelHeuristics.add(this.ButtonBICClustering);
        this.PanelCalcLike.setLocation(10, 230);
        this.PanelCalcLike.setSize(460, 360);
        this.PanelCalcLike.setBorder(new BorderUIResource.TitledBorderUIResource(new LineBorder(XManager.PANEL_BORDER_COLOR, 1, false), "Likelihood settings", 4, 2, XManager.FONT_LABEL, XManager.LABEL_BLUE_COLOR));
        this.PanelCalcLike.setVisible(true);
        this.PanelCalcLike.setLayout(null);
        this.JButtonDefaultCalcLike.setText("Default Settings");
        this.JButtonDefaultCalcLike.setLocation(10, 310);
        this.JButtonDefaultCalcLike.setSize(141, 40);
        this.JButtonDefaultCalcLike.setVisible(true);
        this.CancelButtonCalcLike.setText("Cancel");
        this.CancelButtonCalcLike.setLocation(160, 310);
        this.CancelButtonCalcLike.setSize(110, 40);
        this.CancelButtonCalcLike.setVisible(true);
        this.RunButtonCalcLike.setText("Compute Likelihods");
        this.RunButtonCalcLike.setLocation(280, 310);
        this.RunButtonCalcLike.setSize(170, 40);
        this.RunButtonCalcLike.setVisible(true);
        this.getRootPane().setDefaultButton(this.RunButtonCalcLike);
        this.PanelNumberModelsCalcLike.setLocation(20, 20);
        this.PanelNumberModelsCalcLike.setSize(420, 50);
        this.PanelNumberModelsCalcLike.setBorder(new BorderUIResource.TitledBorderUIResource(new LineBorder(XManager.PANEL_BORDER_COLOR, 1, false), "Number of substitution schemes", 4, 2, XManager.FONT_LABEL, XManager.LABEL_BLUE_COLOR));
        this.PanelNumberModelsCalcLike.setVisible(true);
        this.PanelNumberModelsCalcLike.setLayout(null);
        this.Button3SubsTypeCalcLike.setVisible(true);
        this.Button3SubsTypeCalcLike.setSize(45, 20);
        this.Button3SubsTypeCalcLike.setText("3");
        this.Button3SubsTypeCalcLike.setLocation(20, 20);
        this.Button5SubsTypeCalcLike.setVisible(true);
        this.Button5SubsTypeCalcLike.setSize(45, 20);
        this.Button5SubsTypeCalcLike.setText("5");
        this.Button5SubsTypeCalcLike.setLocation(65, 20);
        this.Button7SubsTypeCalcLike.setVisible(true);
        this.Button7SubsTypeCalcLike.setSize(45, 20);
        this.Button7SubsTypeCalcLike.setText("7");
        this.Button7SubsTypeCalcLike.setLocation(110, 20);
        this.Button11SubsTypeCalcLike.setVisible(true);
        this.Button11SubsTypeCalcLike.setSize(50, 20);
        this.Button11SubsTypeCalcLike.setText("11");
        this.Button11SubsTypeCalcLike.setLocation(155, 20);
        this.Button11SubsTypeCalcLike.setSelected(true);
        this.Button203SubsTypeCalcLike.setVisible(true);
        this.Button203SubsTypeCalcLike.setSize(60, 20);
        this.Button203SubsTypeCalcLike.setText("203");
        this.Button203SubsTypeCalcLike.setLocation(205, 20);
        this.Button203SubsTypeCalcLike.setSelected(true);
        this.ButtonGroupNumberModelsCalcLike.add(this.Button3SubsTypeCalcLike);
        this.ButtonGroupNumberModelsCalcLike.add(this.Button5SubsTypeCalcLike);
        this.ButtonGroupNumberModelsCalcLike.add(this.Button7SubsTypeCalcLike);
        this.ButtonGroupNumberModelsCalcLike.add(this.Button11SubsTypeCalcLike);
        this.ButtonGroupNumberModelsCalcLike.add(this.Button203SubsTypeCalcLike);
        this.jLabelNumModels.setSize(165, 20);
        this.jLabelNumModels.setLocation(275, 20);
        this.jLabelNumModels.setAlignmentX(0.5f);
        this.jLabelNumModels.setAlignmentY(0.5f);
        this.jLabelNumModels.setVisible(true);
        this.jLabelNumModels.setForeground(Color.gray);
        this.jLabelNumModels.setFont(XManager.FONT_LABEL_BIG);
        this.PanelFrequenciesCalcLike.setSize(130, 50);
        this.PanelFrequenciesCalcLike.setBorder(new BorderUIResource.TitledBorderUIResource(new LineBorder(XManager.PANEL_BORDER_COLOR, 1, false), "Base frequencies", 4, 2, XManager.FONT_LABEL, XManager.LABEL_BLUE_COLOR));
        this.PanelFrequenciesCalcLike.setLocation(20, 80);
        this.PanelFrequenciesCalcLike.setVisible(true);
        this.PanelFrequenciesCalcLike.setLayout(null);
        this.jCheckBoxFrequencies.setVisible(true);
        this.jCheckBoxFrequencies.setSize(50, 20);
        this.jCheckBoxFrequencies.setText("+F");
        this.jCheckBoxFrequencies.setLocation(20, 20);
        this.jCheckBoxFrequencies.setSelected(true);
        this.PanelRateVariationCalcLike.setLocation(170, 80);
        this.PanelRateVariationCalcLike.setSize(270, 50);
        this.PanelRateVariationCalcLike.setBorder(new BorderUIResource.TitledBorderUIResource(new LineBorder(XManager.PANEL_BORDER_COLOR, 1, false), "Rate variation", 4, 2, XManager.FONT_LABEL, XManager.LABEL_BLUE_COLOR));
        this.PanelRateVariationCalcLike.setVisible(true);
        this.PanelRateVariationCalcLike.setLayout(null);
        this.jCheckBoxPinv.setLocation(20, 20);
        this.jCheckBoxPinv.setSize(50, 20);
        this.jCheckBoxPinv.setText("+I");
        this.jCheckBoxPinv.setVisible(true);
        this.jCheckBoxPinv.setSelected(true);
        this.jCheckBoxGamma.setVisible(true);
        this.jCheckBoxGamma.setSize(55, 20);
        this.jCheckBoxGamma.setText("+G");
        this.jCheckBoxGamma.setLocation(70, 20);
        this.jCheckBoxGamma.setSelected(true);
        this.TextFieldNcat.setEnabled(this.jCheckBoxGamma.isSelected());
        this.TextFieldNcat.setToolTipText("Number of rate categories for the discrete gamma distribution");
        this.TextFieldNcat.setBorder(new BorderUIResource.TitledBorderUIResource(new LineBorder(XManager.PANEL_BORDER_COLOR, 1, false), "nCat", 4, 2, XManager.FONT_LABEL, XManager.LABEL_BLUE_COLOR));
        this.TextFieldNcat.setVisible(true);
        this.TextFieldNcat.setSize(65, 35);
        this.TextFieldNcat.setText("4");
        this.TextFieldNcat.setHorizontalAlignment(4);
        this.TextFieldNcat.setLocation(122, 10);
        this.PanelTreeOptimizationCalcLike.setLocation(20, 140);
        this.PanelTreeOptimizationCalcLike.setSize(420, 90);
        this.PanelTreeOptimizationCalcLike.setBorder(new BorderUIResource.TitledBorderUIResource(new LineBorder(XManager.PANEL_BORDER_COLOR, 1, false), "Base tree for likelihood calculations", 4, 2, XManager.FONT_LABEL, XManager.LABEL_BLUE_COLOR));
        this.PanelTreeOptimizationCalcLike.setVisible(true);
        this.PanelTreeOptimizationCalcLike.setLayout(null);
        this.ButtonFixedCalcLike.setText("Fixed BIONJ-JC");
        this.ButtonFixedCalcLike.setSize(160, 20);
        this.ButtonFixedCalcLike.setLocation(20, 20);
        this.ButtonFixedCalcLike.setVisible(true);
        this.ButtonFixedUserTopologyCalcLike.setText("Fixed user topology");
        this.ButtonFixedUserTopologyCalcLike.setLocation(200, 20);
        this.ButtonFixedUserTopologyCalcLike.setSize(200, 20);
        this.ButtonFixedUserTopologyCalcLike.setVisible(true);
        this.ButtonBIONJCalcLike.setText("BIONJ");
        this.ButtonBIONJCalcLike.setLocation(20, 57);
        this.ButtonBIONJCalcLike.setSize(160, 20);
        this.ButtonBIONJCalcLike.setVisible(true);
        this.ButtonMLCalcLike.setText("ML optimized");
        this.ButtonMLCalcLike.setLocation(200, 57);
        this.ButtonMLCalcLike.setSize(200, 20);
        this.ButtonMLCalcLike.setVisible(true);
        this.ButtonMLCalcLike.setSelected(true);
        this.enableTreeSearching(this.ButtonMLCalcLike.isSelected());
        this.jLabelUserTopology.setLocation(194, 22);
        this.jLabelUserTopology.setSize(300, 50);
        this.jLabelUserTopology.setForeground(Color.gray);
        this.jLabelUserTopology.setFont(XManager.FONT_LABEL_BIG);
        this.jLabelUserTopology.setVisible(true);
        this.ButtonGroupTreeOptimizationCalcLike.add(this.ButtonFixedCalcLike);
        this.ButtonGroupTreeOptimizationCalcLike.add(this.ButtonBIONJCalcLike);
        this.ButtonGroupTreeOptimizationCalcLike.add(this.ButtonMLCalcLike);
        this.ButtonGroupTreeOptimizationCalcLike.add(this.ButtonFixedUserTopologyCalcLike);
        this.setLocation(XManager.MAIN_LOCATION);
        this.getContentPane().setLayout(null);
        this.setTitle("Likelihood settings");
        this.PanelTreeOptimizationMethod.setLocation(95, 240);
        this.PanelTreeOptimizationMethod.setSize(250, 60);
        this.PanelTreeOptimizationMethod.setBorder(new BorderUIResource.TitledBorderUIResource(new LineBorder(XManager.PANEL_BORDER_COLOR, 1, false), "Base tree search", 4, 2, XManager.FONT_LABEL, XManager.LABEL_BLUE_COLOR));
        this.PanelTreeOptimizationMethod.setVisible(true);
        this.PanelTreeOptimizationMethod.setLayout(null);
        this.ButtonNNICalcLike.setText("NNI");
        this.ButtonNNICalcLike.setLocation(20, 20);
        this.ButtonNNICalcLike.setSize(70, 20);
        this.ButtonNNICalcLike.setVisible(true);
        this.ButtonNNICalcLike.setSelected(true);
        this.ButtonNNICalcLike.setToolTipText("Nearest Neighbor Interchange");
        this.ButtonSPRCalcLike.setText("SPR");
        this.ButtonSPRCalcLike.setLocation(90, 20);
        this.ButtonSPRCalcLike.setSize(70, 20);
        this.ButtonSPRCalcLike.setVisible(true);
        this.ButtonSPRCalcLike.setToolTipText("Subtree Pruning and Regrafting");
        this.ButtonBestCalcLike.setText("Best");
        this.ButtonBestCalcLike.setLocation(160, 20);
        this.ButtonBestCalcLike.setSize(70, 20);
        this.ButtonBestCalcLike.setVisible(true);
        this.ButtonBestCalcLike.setToolTipText("Best of NNI and SPR algorithms. Tests both of them (Slowest).");
        this.ButtonGroupTreeSearchCalcLike.add(this.ButtonNNICalcLike);
        this.ButtonGroupTreeSearchCalcLike.add(this.ButtonSPRCalcLike);
        this.ButtonGroupTreeSearchCalcLike.add(this.ButtonBestCalcLike);
        this.PanelCalcLike.add(this.RunButtonCalcLike);
        this.PanelCalcLike.add(this.CancelButtonCalcLike);
        this.PanelCalcLike.add(this.JButtonDefaultCalcLike);
        this.PanelCalcLike.add(this.PanelNumberModelsCalcLike);
        this.PanelCalcLike.add(this.PanelTreeOptimizationCalcLike);
        this.PanelCalcLike.add(this.PanelTreeOptimizationMethod);
        this.PanelCalcLike.add(this.PanelRateVariationCalcLike);
        this.PanelCalcLike.add(this.PanelFrequenciesCalcLike);
        this.PanelNumberModelsCalcLike.add(this.Button3SubsTypeCalcLike);
        this.PanelNumberModelsCalcLike.add(this.Button5SubsTypeCalcLike);
        this.PanelNumberModelsCalcLike.add(this.Button7SubsTypeCalcLike);
        this.PanelNumberModelsCalcLike.add(this.Button11SubsTypeCalcLike);
        this.PanelNumberModelsCalcLike.add(this.Button203SubsTypeCalcLike);
        this.PanelNumberModelsCalcLike.add(this.jLabelNumModels);
        this.PanelRateVariationCalcLike.add(this.jCheckBoxPinv);
        this.PanelRateVariationCalcLike.add(this.jCheckBoxGamma);
        this.PanelRateVariationCalcLike.add(this.TextFieldNcat);
        this.PanelFrequenciesCalcLike.add(this.jCheckBoxFrequencies);
        this.PanelTreeOptimizationCalcLike.add(this.ButtonFixedCalcLike);
        this.PanelTreeOptimizationCalcLike.add(this.ButtonBIONJCalcLike);
        this.PanelTreeOptimizationCalcLike.add(this.ButtonMLCalcLike);
        this.PanelTreeOptimizationCalcLike.add(this.ButtonFixedUserTopologyCalcLike);
        this.PanelTreeOptimizationMethod.add(this.ButtonNNICalcLike);
        this.PanelTreeOptimizationMethod.add(this.ButtonSPRCalcLike);
        this.PanelTreeOptimizationMethod.add(this.ButtonBestCalcLike);
        this.PanelTreeOptimizationCalcLike.add(this.jLabelUserTopology);
        this.PanelTreeOptimizationCalcLike.add(this.jLabelUserTree);
        this.getContentPane().add(this.PanelProcessors);
        this.getContentPane().add(this.PanelCalcLike);
        this.getContentPane().add(this.PanelHeuristics);
        this.setSize(480, 630);
        this.setResizable(false);
        this.CalculateNumberOfModels(null);
        this.RunButtonCalcLike.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Frame_CalcLike.this.RunButtonCalcLikeActionPerformed(actionEvent);
            }
        });
        this.CancelButtonCalcLike.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Frame_CalcLike.this.CancelButtonCalcLikeActionPerformed(actionEvent);
            }
        });
        this.JButtonDefaultCalcLike.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Frame_CalcLike.this.JButtonDefaultCalcLikeActionPerformed(actionEvent);
            }
        });
        this.SliderProcessors.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Frame_CalcLike.this.processorsSliderChangeListener(changeEvent);
            }
        });
        this.jCheckBoxModelFiltering.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Frame_CalcLike.this.SliderThreshold.setEnabled(Frame_CalcLike.this.jCheckBoxModelFiltering.isSelected());
                Frame_CalcLike.this.jLabelThreshold.setEnabled(Frame_CalcLike.this.jCheckBoxModelFiltering.isSelected());
            }
        });
        this.SliderThreshold.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Frame_CalcLike.this.jLabelThreshold.setText(Utilities.format((double)Frame_CalcLike.this.SliderThreshold.getValue() / 1000.0, 5, 3, false));
            }
        });
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Frame_CalcLike.this.CalculateNumberOfModels(actionEvent);
                Frame_CalcLike.this.jCheckBoxClustering.setSelected(Frame_CalcLike.this.Button203SubsTypeCalcLike.isSelected());
                Frame_CalcLike.this.ButtonAICClustering.setEnabled(Frame_CalcLike.this.jCheckBoxClustering.isSelected());
                Frame_CalcLike.this.ButtonAICcClustering.setEnabled(Frame_CalcLike.this.jCheckBoxClustering.isSelected());
                Frame_CalcLike.this.ButtonBICClustering.setEnabled(Frame_CalcLike.this.jCheckBoxClustering.isSelected());
            }
        };
        this.Button3SubsTypeCalcLike.addActionListener(actionListener);
        this.Button5SubsTypeCalcLike.addActionListener(actionListener);
        this.Button7SubsTypeCalcLike.addActionListener(actionListener);
        this.Button11SubsTypeCalcLike.addActionListener(actionListener);
        this.Button203SubsTypeCalcLike.addActionListener(actionListener);
        this.jCheckBoxPinv.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Frame_CalcLike.this.CalculateNumberOfModels(actionEvent);
            }
        });
        this.jCheckBoxGamma.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Frame_CalcLike.this.jCheckBoxGamma.isSelected()) {
                    Frame_CalcLike.this.TextFieldNcat.setEnabled(true);
                } else {
                    Frame_CalcLike.this.TextFieldNcat.setEnabled(false);
                }
                Frame_CalcLike.this.CalculateNumberOfModels(actionEvent);
            }
        });
        this.jCheckBoxFrequencies.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Frame_CalcLike.this.CalculateNumberOfModels(actionEvent);
            }
        });
        this.ButtonFixedUserTopologyCalcLike.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Frame_CalcLike.this.ReadUserTopologyCalcLike(actionEvent);
            }
        });
        this.ButtonBIONJCalcLike.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Frame_CalcLike.this.enableTreeSearching(false);
            }
        });
        this.ButtonFixedCalcLike.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Frame_CalcLike.this.enableTreeSearching(false);
            }
        });
        this.ButtonFixedUserTopologyCalcLike.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Frame_CalcLike.this.enableTreeSearching(false);
            }
        });
        this.ButtonMLCalcLike.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Frame_CalcLike.this.enableTreeSearching(true);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                Frame_CalcLike.this.thisWindowClosing(windowEvent);
            }
        });
    }

    private void enableTreeSearching(boolean bl) {
        this.ButtonNNICalcLike.setEnabled(bl);
        this.ButtonSPRCalcLike.setEnabled(bl);
        this.ButtonBestCalcLike.setEnabled(bl);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.mShown) {
            return;
        }
        JMenuBar jMenuBar = this.getJMenuBar();
        if (jMenuBar != null) {
            int n = jMenuBar.getPreferredSize().height;
            Dimension dimension = this.getSize();
            dimension.height += n;
            this.setSize(dimension);
            Component[] componentArray = this.getLayeredPane().getComponentsInLayer(JLayeredPane.DEFAULT_LAYER);
            for (int i = 0; i < componentArray.length; ++i) {
                Point point = componentArray[i].getLocation();
                point.move(point.x, point.y + n);
                componentArray[i].setLocation(point);
            }
        }
        this.mShown = true;
    }

    void thisWindowClosing(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    public void RunButtonCalcLikeActionPerformed(ActionEvent actionEvent) {
        try {
            this.options.setNumberOfThreads(this.SliderProcessors.getValue());
            if (this.Button3SubsTypeCalcLike.isSelected()) {
                this.options.setSubstTypeCode(0);
            } else if (this.Button5SubsTypeCalcLike.isSelected()) {
                this.options.setSubstTypeCode(1);
            } else if (this.Button7SubsTypeCalcLike.isSelected()) {
                this.options.setSubstTypeCode(2);
            } else if (this.Button11SubsTypeCalcLike.isSelected()) {
                this.options.setSubstTypeCode(3);
            } else {
                this.options.setSubstTypeCode(4);
            }
            this.options.doF = this.jCheckBoxFrequencies.isSelected();
            this.options.doI = this.jCheckBoxPinv.isSelected();
            if (this.jCheckBoxGamma.isSelected()) {
                this.options.doG = true;
                this.options.numGammaCat = Integer.parseInt(this.TextFieldNcat.getText());
            } else {
                this.options.doG = false;
            }
            this.CalculateNumberOfModels(actionEvent);
            if (this.ButtonFixedCalcLike.isSelected()) {
                this.options.fixedTopology = true;
                this.options.optimizeMLTopology = false;
                this.options.userTopologyExists = false;
            } else if (this.ButtonBIONJCalcLike.isSelected()) {
                this.options.fixedTopology = false;
                this.options.optimizeMLTopology = false;
                this.options.userTopologyExists = false;
            } else if (this.ButtonMLCalcLike.isSelected()) {
                this.options.fixedTopology = false;
                this.options.optimizeMLTopology = true;
                this.options.userTopologyExists = false;
            } else if (this.ButtonFixedUserTopologyCalcLike.isSelected()) {
                this.options.fixedTopology = false;
                this.options.optimizeMLTopology = false;
                this.options.userTopologyExists = true;
            }
            if (this.ButtonNNICalcLike.isSelected()) {
                this.options.treeSearchOperations = ApplicationOptions.TreeSearch.NNI;
            } else if (this.ButtonSPRCalcLike.isSelected()) {
                this.options.treeSearchOperations = ApplicationOptions.TreeSearch.SPR;
            } else if (this.ButtonBestCalcLike.isSelected()) {
                this.options.treeSearchOperations = ApplicationOptions.TreeSearch.BEST;
            }
            if (this.jCheckBoxClustering.isSelected()) {
                if (this.ButtonAICClustering.isSelected()) {
                    this.options.setHeuristicInformationCriterion(1);
                } else if (this.ButtonAICcClustering.isSelected()) {
                    this.options.setHeuristicInformationCriterion(2);
                } else if (this.ButtonBICClustering.isSelected()) {
                    this.options.setHeuristicInformationCriterion(3);
                }
            }
            if (this.jCheckBoxModelFiltering.isSelected()) {
                this.options.setGuidedSearchThreshold((double)this.SliderThreshold.getValue() / 1000.0);
            } else {
                this.options.setGuidedSearchThreshold(0.0);
            }
            this.options.setCandidateModels();
            this.progressFrame = new Frame_Progress(this.options.getNumModels(), this, this.options);
            this.setVisible(false);
            XManager.getInstance().getPane().setCaretPosition(XManager.getInstance().getPane().getDocument().getLength());
            this.options.createLogFile();
            this.options.createCkpFile();
            this.task = new ComputeLikelihoodTask();
            this.runPhyml = this.task.getValue();
            this.task.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void JButtonDefaultCalcLikeActionPerformed(ActionEvent actionEvent) {
        try {
            this.SliderProcessors.setValue(DEFAULT_NUMBER_OF_THREADS);
            this.Button11SubsTypeCalcLike.setSelected(true);
            this.ButtonMLCalcLike.setSelected(true);
            this.enableTreeSearching(this.ButtonMLCalcLike.isSelected());
            this.ButtonBestCalcLike.setSelected(true);
            this.jCheckBoxFrequencies.setSelected(true);
            this.jCheckBoxPinv.setSelected(true);
            this.jCheckBoxGamma.setSelected(true);
            this.TextFieldNcat.setEnabled(true);
            this.TextFieldNcat.setText("4");
            this.jCheckBoxClustering.setSelected(false);
            this.ButtonAICClustering.setEnabled(this.jCheckBoxClustering.isSelected());
            this.ButtonAICcClustering.setEnabled(this.jCheckBoxClustering.isSelected());
            this.ButtonBICClustering.setEnabled(this.jCheckBoxClustering.isSelected());
            this.jCheckBoxModelFiltering.setSelected(false);
            this.SliderThreshold.setValue(100);
            this.CalculateNumberOfModels(null);
            this.jLabelUserTopology.setText("");
            this.jLabelUserTree.setText("");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void CancelButtonCalcLikeActionPerformed(ActionEvent actionEvent) {
        try {
            this.setVisible(false);
            this.dispose();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void CalculateNumberOfModels(ActionEvent actionEvent) {
        try {
            int n = this.Button3SubsTypeCalcLike.isSelected() ? 3 : (this.Button5SubsTypeCalcLike.isSelected() ? 5 : (this.Button7SubsTypeCalcLike.isSelected() ? 7 : (this.Button11SubsTypeCalcLike.isSelected() ? 11 : 203)));
            if (this.jCheckBoxFrequencies.isSelected()) {
                n *= 2;
            }
            if (this.jCheckBoxPinv.isSelected() && this.jCheckBoxGamma.isSelected()) {
                n *= 4;
            } else if (this.jCheckBoxPinv.isSelected() || this.jCheckBoxGamma.isSelected()) {
                n *= 2;
            }
            this.options.setNumModels(n);
            this.jLabelNumModels.setText("NumModels = " + n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void processorsSliderChangeListener(ChangeEvent changeEvent) {
        this.jLabelNumProcessors.setText(String.valueOf(this.SliderProcessors.getValue()));
    }

    public void ReadUserTopologyCalcLike(ActionEvent actionEvent) {
        FileDialog fileDialog = new FileDialog((Frame)this, "Load Newick tree file with branch lengths", 0);
        fileDialog.setDirectory(System.getProperty("user.dir"));
        fileDialog.setVisible(true);
        String string = fileDialog.getFile();
        if (string != null) {
            String string2 = fileDialog.getDirectory() + string;
            ModelTest.getMainConsole().print("Reading tree file \"" + string + "\"...");
            System.err.print("\nreading tree file \"" + string + "\"...");
            this.options.setInputTreeFile(new File(string));
            Tree tree = null;
            try {
                tree = TreeUtilities.readTree(string2);
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, "The specified file \"" + string + "\" cannot be found", "jModelTest error", 0);
                ModelTest.getMainConsole().println(" failed.\n");
                this.ButtonMLCalcLike.setSelected(true);
            }
            catch (TreeParseException treeParseException) {
                ModelTest.getMainConsole().println(" failed.\n");
                System.err.println(" failed.\n");
                this.ButtonMLCalcLike.setSelected(true);
            }
            if (tree != null) {
                this.options.setUserTree(TreeUtilities.toNewick(tree, true, false, false));
                TextOutputStream textOutputStream = new TextOutputStream(this.options.getTreeFile().getAbsolutePath());
                System.out.println("INPUT TREE: " + this.options.getUserTree());
                textOutputStream.print(this.options.getUserTree());
                textOutputStream.close();
                this.jLabelUserTopology.setText(string);
                ModelTest.getMainConsole().println(" OK.");
                System.err.println("OK.");
            }
        } else {
            this.ButtonMLCalcLike.setSelected(true);
            this.enableTreeSearching(true);
        }
    }

    static {
        DEFAULT_NUMBER_OF_THREADS = TOTAL_NUMBER_OF_THREADS = Runtime.getRuntime().availableProcessors();
    }

    private class ComputeLikelihoodTask
    extends SwingWorker {
        private RunPhyml runPhyml;

        public ComputeLikelihoodTask() {
            this.runPhyml = new RunPhymlThread(Frame_CalcLike.this.progressFrame, Frame_CalcLike.this.options, ModelTest.getCandidateModels());
        }

        @Override
        public Object construct() {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            this.runPhyml.execute();
            return this.runPhyml;
        }

        @Override
        public void interrupt() {
            this.runPhyml.interruptThread();
            super.interrupt();
        }

        @Override
        public RunPhyml getValue() {
            return this.runPhyml;
        }
    }
}

