/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.jmodeltest.gui;

import es.uvigo.darwin.jmodeltest.ApplicationOptions;
import es.uvigo.darwin.jmodeltest.ModelTest;
import es.uvigo.darwin.jmodeltest.gui.JModelTestFrame;
import es.uvigo.darwin.jmodeltest.gui.XManager;
import es.uvigo.darwin.jmodeltest.selection.DT;
import es.uvigo.darwin.jmodeltest.utilities.Utilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.BorderUIResource;

public class Frame_DT
extends JModelTestFrame {
    private static final long serialVersionUID = 201104031100L;
    private JPanel panelDTSettings = new JPanel();
    private JTextField textTaxaDT = new JTextField();
    private JTextField textSizeDT = new JTextField();
    private JButton runButtonDT = new JButton();
    private JButton cancelButtonDT = new JButton();
    private JButton buttonDefaultDT = new JButton();
    private JCheckBox checkBoxIncludeBL_DT = new JCheckBox();
    private JCheckBox checkBoxPAUPblock = new JCheckBox();
    private JCheckBox checkBoxAveraging = new JCheckBox();
    private JCheckBox checkBoxImportance = new JCheckBox();
    private JSlider sliderInterval = new JSlider();
    private DT myDT;
    private boolean mShown = false;

    public void initComponents() throws Exception {
        this.panelDTSettings.setSize(490, 240);
        this.panelDTSettings.setBorder(new BorderUIResource.TitledBorderUIResource(new LineBorder(new Color(153, 153, 153), 1, false), "DT Settings", 4, 2, new Font("Application", 1, 10), new Color(102, 102, 153)));
        this.panelDTSettings.setLocation(10, 10);
        this.panelDTSettings.setVisible(true);
        this.panelDTSettings.setLayout(null);
        this.runButtonDT.setVisible(true);
        this.runButtonDT.setSize(190, 40);
        this.runButtonDT.setText("Do DT calculations");
        this.runButtonDT.setLocation(280, 190);
        this.getRootPane().setDefaultButton(this.runButtonDT);
        this.buttonDefaultDT.setVisible(true);
        this.buttonDefaultDT.setSize(141, 40);
        this.buttonDefaultDT.setText("Default Settings");
        this.buttonDefaultDT.setLocation(10, 190);
        this.cancelButtonDT.setVisible(true);
        this.cancelButtonDT.setSize(110, 40);
        this.cancelButtonDT.setText("Cancel");
        this.cancelButtonDT.setLocation(160, 190);
        this.textSizeDT.setToolTipText("Enter the sample size you want to use for the DT and click RETURN. By default this is the number of sites in the alignment");
        this.textSizeDT.setBorder(new BorderUIResource.TitledBorderUIResource(new LineBorder(new Color(153, 153, 153), 1, false), "Sample size", 4, 2, new Font("Application", 1, 10), new Color(102, 102, 153)));
        this.textSizeDT.setVisible(true);
        this.textSizeDT.setSize(100, 40);
        this.textSizeDT.setText(Utilities.format(this.options.getSampleSize(), 10, 4, false));
        this.textSizeDT.setHorizontalAlignment(4);
        this.textSizeDT.setLocation(30, 20);
        this.textSizeDT.setEnabled(false);
        this.checkBoxImportance.setVisible(true);
        this.checkBoxImportance.setSize(260, 20);
        this.checkBoxImportance.setText("Calculate parameter importances");
        this.checkBoxImportance.setLocation(30, 70);
        this.checkBoxImportance.setSelected(true);
        this.checkBoxAveraging.setVisible(true);
        this.checkBoxAveraging.setSize(260, 20);
        this.checkBoxAveraging.setText("Do model averaging");
        this.checkBoxAveraging.setLocation(30, 110);
        this.checkBoxAveraging.setSelected(true);
        this.checkBoxPAUPblock.setVisible(true);
        this.checkBoxPAUPblock.setSize(260, 20);
        this.checkBoxPAUPblock.setText("Write PAUP* block");
        this.checkBoxPAUPblock.setLocation(30, 150);
        this.checkBoxPAUPblock.setSelected(false);
        this.checkBoxPAUPblock.setToolTipText("Writes a block of PAUP* commands implementing the selected model");
        this.sliderInterval.setVisible(true);
        this.sliderInterval.setToolTipText("Set the confidence interval for model averaging and/or parameter importance");
        this.sliderInterval.setBorder(new BorderUIResource.TitledBorderUIResource(new LineBorder(new Color(153, 153, 153), 1, false), "Confidence interval = 100%", 4, 2, new Font("Application", 1, 10), new Color(102, 102, 153)));
        this.sliderInterval.setSize(170, 70);
        this.sliderInterval.setLocation(300, 70);
        this.sliderInterval.setMinimum(0);
        this.sliderInterval.setMaximum(100);
        this.sliderInterval.setValue(100);
        this.sliderInterval.setMajorTickSpacing(20);
        this.sliderInterval.setMinorTickSpacing(5);
        this.sliderInterval.setPaintTicks(true);
        this.sliderInterval.setPaintLabels(true);
        this.sliderInterval.setEnabled(true);
        this.sliderInterval.setFont(XManager.FONT_SLIDER);
        this.setLocation(281, 80);
        this.getContentPane().setLayout(null);
        this.setTitle("Decision Theory (DT) Settings");
        this.panelDTSettings.add(this.textTaxaDT);
        this.panelDTSettings.add(this.textSizeDT);
        this.panelDTSettings.add(this.checkBoxIncludeBL_DT);
        this.panelDTSettings.add(this.checkBoxAveraging);
        this.panelDTSettings.add(this.checkBoxImportance);
        this.panelDTSettings.add(this.checkBoxPAUPblock);
        this.panelDTSettings.add(this.sliderInterval);
        this.panelDTSettings.add(this.buttonDefaultDT);
        this.panelDTSettings.add(this.cancelButtonDT);
        this.panelDTSettings.add(this.runButtonDT);
        this.getContentPane().add(this.panelDTSettings);
        this.setSize(510, 280);
        this.setResizable(false);
        this.checkBoxAveraging.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Frame_DT.this.jCheckBoxAveragingStateChanged(changeEvent);
            }
        });
        this.checkBoxImportance.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Frame_DT.this.jCheckBoxImportanceStateChanged(changeEvent);
            }
        });
        this.sliderInterval.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Frame_DT.this.JSliderIntervalStateChanged(changeEvent);
            }
        });
        this.buttonDefaultDT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Frame_DT.this.JButtonDefaultDTActionPerformed(actionEvent);
            }
        });
        this.cancelButtonDT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Frame_DT.this.CancelButtonDTActionPerformed(actionEvent);
            }
        });
        this.runButtonDT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Frame_DT.this.RunButtonDTActionPerformed(actionEvent);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                Frame_DT.this.thisWindowClosing(windowEvent);
            }
        });
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.mShown) {
            return;
        }
        JMenuBar jMenuBar = this.getJMenuBar();
        if (jMenuBar != null) {
            int n = jMenuBar.getPreferredSize().height;
            Dimension dimension = this.getSize();
            dimension.height += n;
            this.setSize(dimension);
            Component[] componentArray = this.getLayeredPane().getComponentsInLayer(JLayeredPane.DEFAULT_LAYER);
            for (int i = 0; i < componentArray.length; ++i) {
                Point point = componentArray[i].getLocation();
                point.move(point.x, point.y + n);
                componentArray[i].setLocation(point);
            }
        }
        this.mShown = true;
    }

    void thisWindowClosing(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    public void jCheckBoxImportanceStateChanged(ChangeEvent changeEvent) {
        if (this.checkBoxImportance.isSelected()) {
            this.sliderInterval.setEnabled(true);
        } else if (!this.checkBoxAveraging.isSelected()) {
            this.sliderInterval.setEnabled(false);
        }
    }

    public void jCheckBoxAveragingStateChanged(ChangeEvent changeEvent) {
        if (this.checkBoxAveraging.isSelected()) {
            this.sliderInterval.setEnabled(true);
        } else if (!this.checkBoxImportance.isSelected()) {
            this.sliderInterval.setEnabled(false);
        }
    }

    public void JSliderIntervalStateChanged(ChangeEvent changeEvent) {
        this.sliderInterval.setBorder(new BorderUIResource.TitledBorderUIResource(new LineBorder(new Color(153, 153, 153), 1, false), "Confidence interval = " + this.sliderInterval.getValue() + "%", 4, 2, new Font("Application", 1, 10), new Color(102, 102, 153)));
    }

    public void JButtonDefaultDTActionPerformed(ActionEvent actionEvent) {
        this.textSizeDT.setEnabled(false);
        ApplicationOptions.getInstance().countBLasParameters = true;
        XManager.getInstance().selectedMenuResultsBLasParameters(true);
        this.checkBoxPAUPblock.setSelected(false);
        this.checkBoxAveraging.setSelected(true);
        this.checkBoxImportance.setSelected(true);
        this.sliderInterval.setValue(100);
    }

    public void CancelButtonDTActionPerformed(ActionEvent actionEvent) {
        try {
            this.setVisible(false);
            this.dispose();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void RunButtonDTActionPerformed(ActionEvent actionEvent) {
        try {
            this.setVisible(false);
            this.dispose();
            boolean bl = this.checkBoxPAUPblock.isSelected();
            this.options.writePAUPblock |= bl;
            boolean bl2 = this.checkBoxImportance.isSelected();
            boolean bl3 = this.checkBoxAveraging.isSelected();
            double d = (double)this.sliderInterval.getValue() / 100.0;
            this.myDT = new DT(bl, bl2, bl3, d);
            this.myDT.compute();
            this.myDT.print(ModelTest.getCurrentOutStream());
            ModelTest.setMyDT(this.myDT);
            this.options.doDT = this.myDT != null;
            XManager.getInstance().resultsFrame.enablePane(4);
            XManager.getInstance().resultsFrame.populate(4);
            XManager.getInstance().enableMenuAveraging(!this.options.fixedTopology);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

