/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.jmodeltest.gui;

import es.uvigo.darwin.jmodeltest.ApplicationOptions;
import es.uvigo.darwin.jmodeltest.ModelTest;
import es.uvigo.darwin.jmodeltest.ModelTestConfiguration;
import es.uvigo.darwin.jmodeltest.exe.ExternalExecutionManager;
import es.uvigo.darwin.jmodeltest.exe.ProcessManager;
import es.uvigo.darwin.jmodeltest.gui.Frame_CalcLike;
import es.uvigo.darwin.jmodeltest.gui.JModelTestFrame;
import es.uvigo.darwin.jmodeltest.gui.XManager;
import es.uvigo.darwin.jmodeltest.io.TextOutputStream;
import es.uvigo.darwin.jmodeltest.model.Model;
import es.uvigo.darwin.jmodeltest.observer.ProgressInfo;
import es.uvigo.darwin.jmodeltest.utilities.Utilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Locale;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import javax.swing.border.LineBorder;
import javax.swing.plaf.BorderUIResource;

public class Frame_Progress
extends JModelTestFrame
implements Observer,
ActionListener {
    private static final long serialVersionUID = 201102181036L;
    private static final int LABEL_HEIGHT = 20;
    private static final int THREAD_BAR_HEIGHT = 20;
    private static final int PROGRESS_BAR_HEIGHT = 30;
    private static final int WINDOW_WIDTH = 400;
    private static final int H_MARGIN = 20;
    private static final int V_MARGIN = 10;
    private static final int V_INNER_MARGIN = 5;
    private static final int SECTION_WIDTH = 360;
    private static final int HEADER_HEIGHT = 30;
    private static int FOOTER_HEIGHT = 75;
    private static final int THREADS_SECTIONS_VLOC = 50;
    private static final int HEIGHT_PER_THREAD = 45;
    private static final int BUTTON_WIDTH = 100;
    private static final int THREAD_LABEL_WIDTH = 80;
    private static final String NO_MODEL = "idle";
    private static final long lockTime = 3000L;
    private static final Color[] THREAD_COLOR = new Color[]{new Color(177, 68, 68), new Color(177, 68, 161), new Color(126, 68, 177), new Color(68, 97, 177), new Color(68, 177, 162), new Color(68, 177, 63), new Color(161, 177, 68), new Color(177, 141, 48), new Color(177, 73, 68)};
    private TextOutputStream stream;
    private int numberOfThreads;
    private JPanel headerPanel = new JPanel();
    private JPanel threadsActivityPanel = new JPanel();
    private JPanel footerPanel = new JPanel();
    private JProgressBar[] threadProgressBar;
    private JLabel[] threadProgressLabel;
    private JLabel[] threadProgressModelLabel;
    private JButton progressBarCancelButton = new JButton();
    private JProgressBar progressBarLike = new JProgressBar();
    private JLabel progressBarLikeLabel = new JLabel();
    private JLabel timerLabel = new JLabel();
    private int[] maxNumOfModelsPerStage = new int[]{1, 15, 10, 6, 3, 1};
    private JLabel footerStageLabel = new JLabel();
    private volatile long startTime;
    private volatile long lockTimer = 0L;
    private Frame_CalcLike frameCalcLike;
    private Timer timer;
    private int completedModels = 0;
    private int totalModels;
    private int currentStage = 1;
    private boolean interrupted;
    private int maximum;
    private boolean mShown = false;

    public Frame_Progress(int n, Frame_CalcLike frame_CalcLike, ApplicationOptions applicationOptions) {
        this.numberOfThreads = applicationOptions.getNumberOfThreads();
        this.totalModels = ModelTest.getCandidateModels().length;
        this.interrupted = false;
        this.options = applicationOptions;
        this.startTime = System.currentTimeMillis();
        this.stream = ModelTest.getMainConsole();
        this.threadProgressBar = new JProgressBar[this.numberOfThreads];
        this.threadProgressLabel = new JLabel[this.numberOfThreads];
        this.threadProgressModelLabel = new JLabel[this.numberOfThreads];
        this.maximum = n;
        this.frameCalcLike = frame_CalcLike;
        this.initComponents();
        this.setVisible(true);
        this.timer = new Timer(1000, this);
        this.timer.setRepeats(true);
        this.timer.start();
    }

    public void initComponents() {
        int n;
        int n2;
        this.headerPanel.setSize(360, 30);
        this.headerPanel.setLocation(20, 10);
        this.headerPanel.setBorder(new BorderUIResource.LineBorderUIResource(XManager.PANEL_BORDER_COLOR));
        this.headerPanel.setLayout(null);
        this.headerPanel.setVisible(true);
        this.progressBarLikeLabel.setSize(120, 20);
        this.progressBarLikeLabel.setLocation(20, 5);
        this.progressBarLikeLabel.setVisible(true);
        this.progressBarLikeLabel.setFont(XManager.FONT_CONSOLE);
        this.progressBarLikeLabel.setText("Completed 0/" + this.totalModels);
        this.timerLabel.setSize(180, 20);
        this.timerLabel.setLocation(160, 5);
        this.timerLabel.setVisible(true);
        this.timerLabel.setFont(XManager.FONT_CONSOLE);
        this.timerLabel.setAlignmentX(1.0f);
        int n3 = this.numberOfThreads * 45 + 20;
        this.threadsActivityPanel.setSize(360, n3);
        this.threadsActivityPanel.setLocation(20, 50);
        this.threadsActivityPanel.setBorder(new BorderUIResource.TitledBorderUIResource(new LineBorder(XManager.PANEL_BORDER_COLOR, 1, false), "Thread activity", 4, 2, XManager.FONT_LABEL, XManager.LABEL_BLUE_COLOR));
        this.threadsActivityPanel.setLayout(null);
        this.threadsActivityPanel.setVisible(true);
        int n4 = Math.max(THREAD_COLOR.length / this.numberOfThreads, 1);
        for (n2 = 0; n2 < this.numberOfThreads; ++n2) {
            this.threadProgressLabel[n2] = new JLabel();
            this.threadProgressLabel[n2].setSize(80, 20);
            this.threadProgressLabel[n2].setLocation(20, 20 + n2 * 45 + 5);
            this.threadProgressLabel[n2].setVisible(true);
            this.threadProgressLabel[n2].setFont(XManager.FONT_CONSOLE);
            this.threadProgressLabel[n2].setText(" Thread " + n2 + ":");
            this.threadProgressLabel[n2].setOpaque(true);
            this.threadProgressLabel[n2].setBackground(THREAD_COLOR[n2 * n4 % THREAD_COLOR.length]);
            this.threadProgressLabel[n2].setForeground(Color.WHITE);
            this.threadProgressModelLabel[n2] = new JLabel();
            this.threadProgressModelLabel[n2].setSize(220, 20);
            this.threadProgressModelLabel[n2].setLocation(120, n2 * 45 + 10);
            this.threadProgressModelLabel[n2].setVisible(true);
            this.threadProgressModelLabel[n2].setFont(XManager.FONT_CONSOLE);
            this.threadProgressModelLabel[n2].setText(NO_MODEL);
            this.threadProgressModelLabel[n2].setOpaque(false);
            this.threadProgressModelLabel[n2].setForeground(XManager.LABEL_FAIL_COLOR);
            this.threadProgressBar[n2] = new JProgressBar();
            this.threadProgressBar[n2].setSize(220, 20);
            this.threadProgressBar[n2].setStringPainted(false);
            this.threadProgressBar[n2].setIndeterminate(false);
            this.threadProgressBar[n2].setLocation(120, 20 + n2 * 45 + 10);
            this.threadProgressBar[n2].setVisible(true);
        }
        n2 = 50 + n3 + 10;
        this.footerPanel.setSize(360, FOOTER_HEIGHT + (this.options.isClusteringSearch() ? 30 : 0));
        this.footerPanel.setLocation(20, n2);
        this.footerPanel.setBorder(new BorderUIResource.LineBorderUIResource(XManager.PANEL_BORDER_COLOR));
        this.footerPanel.setLayout(null);
        this.footerPanel.setVisible(true);
        if (this.options.isClusteringSearch()) {
            this.footerStageLabel.setSize(80, 20);
            this.footerStageLabel.setLocation(20, 5);
            this.footerStageLabel.setVisible(true);
            this.footerStageLabel.setText("Step 1/6");
            this.footerPanel.add(this.footerStageLabel);
        }
        int n5 = 5;
        if (this.options.isClusteringSearch()) {
            n = (this.options.doI ? 2 : 1) * (this.options.doG ? 2 : 1) * (this.options.doF ? 2 : 1);
            int n6 = 0;
            while (n6 < 6) {
                int n7 = n6++;
                this.maxNumOfModelsPerStage[n7] = this.maxNumOfModelsPerStage[n7] * n;
            }
            n5 += 30;
            FOOTER_HEIGHT += 30;
        }
        n = this.options.isClusteringSearch() ? this.maxNumOfModelsPerStage[0] : this.maximum;
        this.progressBarLike.setMaximum(n);
        this.progressBarLike.setValue(0);
        this.progressBarLike.setStringPainted(true);
        this.progressBarLike.setString(null);
        this.progressBarLike.setSize(320, 30);
        this.progressBarLike.setLocation(20, n5);
        this.progressBarLike.setVisible(true);
        this.progressBarCancelButton.setVisible(true);
        this.progressBarCancelButton.setSize(100, 30);
        this.progressBarCancelButton.setText("Cancel");
        this.progressBarCancelButton.setLocation(130, 35 + n5);
        this.setLocation(281, 80);
        this.getContentPane().setLayout(null);
        this.setTitle("Progress");
        for (JProgressBar jComponent : this.threadProgressBar) {
            this.threadsActivityPanel.add(jComponent);
        }
        for (JComponent jComponent : this.threadProgressLabel) {
            this.threadsActivityPanel.add(jComponent);
        }
        for (JComponent jComponent : this.threadProgressModelLabel) {
            this.threadsActivityPanel.add(jComponent);
        }
        this.headerPanel.add(this.progressBarLikeLabel);
        this.headerPanel.add(this.timerLabel);
        this.getContentPane().add(this.headerPanel);
        this.getContentPane().add(this.threadsActivityPanel);
        this.footerPanel.add(this.progressBarLike);
        this.footerPanel.add(this.progressBarCancelButton);
        this.getContentPane().add(this.footerPanel);
        this.setSize(400, n2 + FOOTER_HEIGHT + 40);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                Frame_Progress.this.thisWindowClosing(windowEvent);
            }
        });
        this.progressBarCancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Frame_Progress.this.progressBarCancel(actionEvent);
            }
        });
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.mShown) {
            return;
        }
        JMenuBar jMenuBar = this.getJMenuBar();
        if (jMenuBar != null) {
            int n = jMenuBar.getPreferredSize().height;
            Dimension dimension = this.getSize();
            dimension.height += n;
            this.setSize(dimension);
            Component[] componentArray = this.getLayeredPane().getComponentsInLayer(JLayeredPane.DEFAULT_LAYER);
            for (int i = 0; i < componentArray.length; ++i) {
                Point point = componentArray[i].getLocation();
                point.move(point.x, point.y + n);
                componentArray[i].setLocation(point);
            }
        }
        this.mShown = true;
    }

    private void thisWindowClosing(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    private void progressBarCancel(ActionEvent actionEvent) {
        this.setEnabled(false);
        try {
            Object[] objectArray = new Object[]{"Yes", "No"};
            int n = JOptionPane.showOptionDialog(null, "Are you sure you want to cancel?", "Cancel Execution", 0, 2, null, objectArray, objectArray[1]);
            if (n == 0) {
                this.frameCalcLike.getRunPhyml().interruptThread();
                this.frameCalcLike.cancelTask();
                this.setVisible(false);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setEnabled(true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void update(Observable observable, Object object) {
        block33: {
            block32: {
                if (Math.abs(System.currentTimeMillis() - this.lockTimer) < 3000L) {
                    return;
                }
                if (object == null) break block32;
                ProgressInfo progressInfo = (ProgressInfo)object;
                block2 : switch (progressInfo.getType()) {
                    case 1: {
                        this.stream.print("\nEstimating a BIONJ-JC tree ... ");
                        System.out.print("estimating a BIONJ-JC tree ... ");
                        this.threadProgressModelLabel[0].setText("Computing BIONJ tree for JC");
                        this.threadProgressModelLabel[0].setForeground(XManager.LABEL_GREEN_COLOR);
                        this.threadProgressBar[0].setIndeterminate(true);
                        break;
                    }
                    case 2: {
                        this.stream.println("OK");
                        System.out.println("OK");
                        this.threadProgressModelLabel[0].setText(NO_MODEL);
                        this.threadProgressModelLabel[0].setForeground(XManager.LABEL_FAIL_COLOR);
                        this.threadProgressBar[0].setIndeterminate(false);
                        this.stream.print(progressInfo.getModel().getName() + " tree: " + progressInfo.getModel().getTreeString() + "\n");
                        break;
                    }
                    case 10: {
                        this.stream.println("[Heuristic search] Optimizing " + progressInfo.getModel().getName() + " model");
                        this.threadProgressModelLabel[0].setText("Computing " + progressInfo.getModel().getName() + " model for heuristic search");
                        this.threadProgressModelLabel[0].setForeground(XManager.LABEL_GREEN_COLOR);
                        this.threadProgressBar[0].setIndeterminate(true);
                        break;
                    }
                    case 11: {
                        this.stream.println("[Heuristic search] OK");
                        this.threadProgressModelLabel[0].setText(NO_MODEL);
                        this.threadProgressModelLabel[0].setForeground(XManager.LABEL_FAIL_COLOR);
                        this.threadProgressBar[0].setIndeterminate(false);
                        break;
                    }
                    case 4: {
                        for (int i = 0; i < this.numberOfThreads; ++i) {
                            JLabel jLabel = this.threadProgressModelLabel[i];
                            if (!jLabel.getText().equals(NO_MODEL)) continue;
                            jLabel.setText("Computing " + progressInfo.getModel().getName() + "...");
                            jLabel.setForeground(XManager.LABEL_GREEN_COLOR);
                            this.threadProgressBar[i].setIndeterminate(true);
                            break block2;
                        }
                        break block33;
                    }
                    case 3: {
                        this.stream.println(" ");
                        this.stream.println("::Progress::");
                        this.stream.println(" ");
                        this.stream.println("Model \t\t Exec. Time \t Total Time \t -lnL");
                        this.stream.println("-------------------------------------------------------------------------");
                        ModelTest.setMyAIC(null);
                        ModelTest.setMyAICc(null);
                        ModelTest.setMyBIC(null);
                        ModelTest.setMyDT(null);
                        break;
                    }
                    case 5: {
                        ++this.completedModels;
                        try {
                            Object object2;
                            int n;
                            for (n = 0; n < this.numberOfThreads; ++n) {
                                object2 = this.threadProgressModelLabel[n];
                                if (!((JLabel)object2).getText().equals("Computing " + progressInfo.getModel().getName() + "...")) continue;
                                ((JLabel)object2).setText(NO_MODEL);
                                ((JComponent)object2).setForeground(XManager.LABEL_FAIL_COLOR);
                                this.threadProgressBar[n].setIndeterminate(false);
                                break;
                            }
                            if (this.options.isClusteringSearch()) {
                                if (this.currentStage != progressInfo.getHeuristicStage()) {
                                    this.currentStage = progressInfo.getHeuristicStage();
                                    this.completedModels = 0;
                                    this.footerStageLabel.setText("Step " + this.currentStage + "/6");
                                    n = this.maxNumOfModelsPerStage[this.currentStage - 1];
                                    this.progressBarLike.setMaximum(n);
                                }
                                this.progressBarLikeLabel.setText("[" + this.currentStage + "/6]" + this.completedModels + "/" + progressInfo.getNumModelsInStage());
                            } else {
                                this.totalModels = this.options.getNumModels();
                                this.progressBarLikeLabel.setText("Completed " + this.completedModels + "/" + this.totalModels);
                            }
                            if (ModelTestConfiguration.isCkpEnabled()) {
                                try {
                                    FileOutputStream fileOutputStream = new FileOutputStream(this.options.getCkpFile());
                                    object2 = new BufferedOutputStream(fileOutputStream);
                                    ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)object2);
                                    objectOutputStream.writeObject(ModelTest.getCandidateModels());
                                    objectOutputStream.close();
                                }
                                catch (IOException iOException) {
                                    System.err.println("Cannot perform output.");
                                }
                            }
                            this.progressBarLike.setValue(this.completedModels);
                        }
                        catch (NullPointerException nullPointerException) {
                            // empty catch block
                        }
                        String string = progressInfo.getModel().getName().length() > 10 ? "\t" : "\t\t";
                        this.stream.println(progressInfo.getModel().getName() + string + progressInfo.getMessage() + "\t" + Utilities.calculateRuntime(this.startTime, System.currentTimeMillis()) + "\t" + String.format(Locale.ENGLISH, "%5.4f", progressInfo.getModel().getLnL()));
                        XManager.getInstance().getPane().setCaretPosition(XManager.getInstance().getPane().getDocument().getLength());
                        break;
                    }
                    case 20: {
                        this.lockTimer = System.currentTimeMillis();
                        if (this.interrupted) break;
                        this.interrupted = true;
                        this.stream.println(" ");
                        XManager.getInstance().setLikeLabelColor(XManager.LABEL_FAIL_COLOR);
                        System.err.println("\nComputation of likelihood scores discontinued...");
                        Utilities.printRed("\nComputation of likelihood scores interrupted. It took " + Utilities.calculateRuntime(this.startTime, System.currentTimeMillis()) + ".\n");
                        this.stream.println(" ");
                        XManager.getInstance().getPane().setCaretPosition(XManager.getInstance().getPane().getDocument().getLength());
                        ProcessManager.getInstance().killAll();
                        break;
                    }
                    case 21: {
                        this.lockTimer = System.currentTimeMillis();
                        this.progressBarCancel(null);
                        Utilities.printRed(progressInfo.getMessage());
                        JOptionPane.showMessageDialog(new JFrame(), progressInfo.getMessage(), "jModeltest error", 0);
                        break;
                    }
                    case 23: {
                        this.lockTimer = System.currentTimeMillis();
                        this.progressBarCancel(null);
                        Utilities.printRed("\n********************\n");
                        Utilities.printRed("PhyML binary does not have execution permission: " + progressInfo.getMessage());
                        Utilities.printRed("\n********************\n");
                        JOptionPane.showMessageDialog(new JFrame(), "PhyML binary does not have execution permission:\n   " + progressInfo.getMessage(), "jModeltest error", 0);
                        break;
                    }
                    case 22: {
                        this.lockTimer = System.currentTimeMillis();
                        this.progressBarCancel(null);
                        Utilities.printRed("\n********************\n");
                        Utilities.printRed("PhyML binary does not exist: " + progressInfo.getMessage());
                        Utilities.printRed("\n********************\n");
                        JOptionPane.showMessageDialog(new JFrame(), "PhyML binary does not exist:\n   " + progressInfo.getMessage(), "jModeltest error", 0);
                        break;
                    }
                    case 6: {
                        if (!this.interrupted) {
                            void var6_18;
                            this.stream.println(" ");
                            this.stream.println("::Results::");
                            this.stream.println(" ");
                            int n = 0;
                            for (Model model : ModelTest.getCandidateModels()) {
                                if (!(model.getLnL() > 0.0)) continue;
                                ++n;
                                model.print(ModelTest.getMainConsole());
                                ModelTest.getMainConsole().println(" ");
                            }
                            String string = "";
                            if (!this.options.fixedTopology && !this.options.userTopologyExists) {
                                String string2 = "(optimized trees)";
                            } else {
                                String string3 = "(fixed tree)";
                            }
                            XManager.getInstance().setLikeLabelText("  Likelihood scores loaded for " + n + " models " + (String)var6_18);
                            if (this.options.isClusteringSearch() || n == this.options.getNumModels()) {
                                XManager.getInstance().setLikeLabelColor(XManager.LABEL_BLUE_COLOR);
                                this.stream.println("\nComputation of likelihood scores completed. It took " + Utilities.calculateRuntime(this.startTime, System.currentTimeMillis()) + ".\n");
                                XManager.getInstance().enableMenuhLRT(this.options.getSubstTypeCode() < 4 & (this.options.fixedTopology | this.options.userTopologyExists));
                                XManager.getInstance().enableMenuAveraging(!(this.options.fixedTopology | this.options.userTopologyExists));
                                XManager.getInstance().enableMenuAIC(true);
                                XManager.getInstance().enableMenuBIC(true);
                                XManager.getInstance().enableMenuDT(true);
                                XManager.getInstance().buildFrameResults();
                                XManager.getInstance().enableMenuShowModelTable(true);
                                XManager.getInstance().enableMenuHtmlOutput(true);
                                System.out.println(" ... OK");
                            } else {
                                XManager.getInstance().setLikeLabelColor(XManager.LABEL_FAIL_COLOR);
                                this.stream.println("\nComputation of likelihood scores interrupted. It took " + Utilities.calculateRuntime(this.startTime, System.currentTimeMillis()) + ".\n");
                            }
                        }
                        XManager.getInstance().getPane().setCaretPosition(XManager.getInstance().getPane().getDocument().getLength());
                    }
                    case 7: {
                        ExternalExecutionManager.getInstance().killProcesses();
                        this.setVisible(false);
                    }
                }
                break block33;
            }
            this.setVisible(false);
            this.dispose();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.timerLabel.setText("Elapsed time: " + Utilities.calculateRuntimeMinutes(this.startTime, System.currentTimeMillis()));
    }
}

