/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.jmodeltest.gui;

import es.uvigo.darwin.jmodeltest.ModelTest;
import es.uvigo.darwin.jmodeltest.gui.JModelTestFrame;
import es.uvigo.darwin.jmodeltest.gui.XManager;
import es.uvigo.darwin.jmodeltest.selection.HLRT;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.BorderUIResource;

public class Frame_hLRT
extends JModelTestFrame {
    private static final long serialVersionUID = -3314020071170637296L;
    private JPanel PanelSettings = new JPanel();
    private JTextField TextFieldConfidenceLevelhLRT = new JTextField();
    private JList<String> HypothesisList = new JList();
    private DefaultListModel<String> listModel = new DefaultListModel();
    private JButton ButtonListUp = new JButton();
    private JButton ButtonListDown = new JButton();
    private JButton CancelButtonhLRT = new JButton();
    private JButton RunButtonhLRT = new JButton();
    private JButton JButtonDefaulthLRT = new JButton();
    private JPanel PanelForwardBackward = new JPanel();
    private JRadioButton ButtonForward = new JRadioButton();
    private JRadioButton ButtonBackward = new JRadioButton();
    private ButtonGroup ButtonGroupForwardBackward = new ButtonGroup();
    private JCheckBox jCheckBoxPAUPblock = new JCheckBox();
    private JCheckBox jCheckBoxDynamical = new JCheckBox();
    private String currentDirectory = System.getProperty("user.dir");
    private boolean mShown = false;

    public void initComponents() throws Exception {
        Image image = Toolkit.getDefaultToolkit().getImage(this.currentDirectory + "/resources/icons/Up24.gif");
        Image image2 = Toolkit.getDefaultToolkit().getImage(this.currentDirectory + "/resources/icons/Down24.gif");
        this.PanelSettings.setSize(new Dimension(460, 370));
        this.PanelSettings.setBorder(new BorderUIResource.TitledBorderUIResource(new LineBorder(new Color(153, 153, 153), 1, false), "hLRT Settings", 4, 2, new Font("Application", 1, 10), new Color(102, 102, 153)));
        this.PanelSettings.setLocation(new Point(10, 10));
        this.PanelSettings.setVisible(true);
        this.PanelSettings.setLayout(null);
        this.TextFieldConfidenceLevelhLRT.setToolTipText("Enter the confidence level for individual LRTs and click ENTER");
        this.TextFieldConfidenceLevelhLRT.setBorder(new BorderUIResource.TitledBorderUIResource(new LineBorder(new Color(153, 153, 153), 1, false), "Confidence level LRT", 4, 2, new Font("Application", 1, 10), new Color(102, 102, 153)));
        this.TextFieldConfidenceLevelhLRT.setVisible(true);
        this.TextFieldConfidenceLevelhLRT.setSize(new Dimension(130, 50));
        this.TextFieldConfidenceLevelhLRT.setText("0.01");
        this.TextFieldConfidenceLevelhLRT.setHorizontalAlignment(4);
        this.TextFieldConfidenceLevelhLRT.setLocation(new Point(20, 20));
        this.HypothesisList.setToolTipText("Use the buttons to move up and down the different hypotheses");
        this.HypothesisList.setBorder(new BorderUIResource.TitledBorderUIResource(new LineBorder(new Color(153, 153, 153), 1, false), "Hypotheses order", 4, 2, new Font("Application", 1, 10), new Color(102, 102, 153)));
        this.HypothesisList.setVisible(true);
        this.HypothesisList.setSize(new Dimension(130, 230));
        this.HypothesisList.setVisibleRowCount(ModelTest.testingOrder.size());
        this.HypothesisList.setFont(XManager.FONT_LABEL_BIG);
        this.HypothesisList.setSelectionMode(0);
        this.HypothesisList.setLocation(new Point(20, 80));
        this.ButtonListUp.setIcon(new ImageIcon(image));
        this.ButtonListUp.setVisible(true);
        this.ButtonListUp.setSize(new Dimension(35, 40));
        this.ButtonListUp.setLocation(new Point(155, 100));
        this.ButtonListDown.setIcon(new ImageIcon(image2));
        this.ButtonListDown.setVisible(true);
        this.ButtonListDown.setSize(new Dimension(35, 40));
        this.ButtonListDown.setLocation(new Point(155, 140));
        this.PanelForwardBackward.setSize(new Dimension(200, 50));
        this.PanelForwardBackward.setBorder(new BorderUIResource.TitledBorderUIResource(new LineBorder(new Color(153, 153, 153), 1, false), "Forward/Backward Selection", 4, 2, new Font("Application", 1, 10), new Color(102, 102, 153)));
        this.PanelForwardBackward.setLocation(new Point(200, 20));
        this.PanelForwardBackward.setVisible(true);
        this.PanelForwardBackward.setLayout(null);
        this.ButtonForward.setVisible(true);
        this.ButtonForward.setSize(new Dimension(90, 20));
        this.ButtonForward.setText("Forward");
        this.ButtonForward.setLocation(new Point(10, 20));
        this.ButtonForward.setToolTipText("Adds parameters starting from a JC model");
        this.ButtonForward.setSelected(true);
        this.ButtonBackward.setVisible(true);
        this.ButtonBackward.setSize(new Dimension(90, 20));
        this.ButtonBackward.setText("Backward");
        this.ButtonBackward.setLocation(new Point(100, 20));
        this.ButtonBackward.setToolTipText("Removes parameters starting from a GTR+I+G model");
        this.jCheckBoxDynamical.setVisible(true);
        this.jCheckBoxDynamical.setSize(new Dimension(200, 20));
        this.jCheckBoxDynamical.setText("Perform dynamical LRTs");
        this.jCheckBoxDynamical.setLocation(new Point(230, 100));
        this.jCheckBoxDynamical.setSelected(false);
        this.jCheckBoxDynamical.setToolTipText("The sequences of LRTs will be build according to best lnL moves");
        this.jCheckBoxPAUPblock.setVisible(true);
        this.jCheckBoxPAUPblock.setSize(new Dimension(160, 20));
        this.jCheckBoxPAUPblock.setText("Write PAUP* block");
        this.jCheckBoxPAUPblock.setLocation(new Point(230, 160));
        this.jCheckBoxPAUPblock.setSelected(false);
        this.jCheckBoxPAUPblock.setToolTipText("Writes a block of PAUP* commands implementing the selected model");
        this.JButtonDefaulthLRT.setVisible(true);
        this.JButtonDefaulthLRT.setSize(new Dimension(141, 40));
        this.JButtonDefaulthLRT.setText("Default Settings");
        this.JButtonDefaulthLRT.setLocation(new Point(10, 320));
        this.CancelButtonhLRT.setVisible(true);
        this.CancelButtonhLRT.setSize(new Dimension(140, 40));
        this.CancelButtonhLRT.setText("Cancel");
        this.CancelButtonhLRT.setLocation(new Point(160, 320));
        this.RunButtonhLRT.setVisible(true);
        this.RunButtonhLRT.setSize(new Dimension(140, 40));
        this.RunButtonhLRT.setText("Run");
        this.RunButtonhLRT.setLocation(new Point(310, 320));
        this.RunButtonhLRT.setToolTipText("Click here to start the hLRT selection");
        this.getRootPane().setDefaultButton(this.RunButtonhLRT);
        this.ButtonGroupForwardBackward.add(this.ButtonForward);
        this.ButtonGroupForwardBackward.add(this.ButtonBackward);
        this.setLocation(new Point(281, 80));
        this.getContentPane().setLayout(null);
        this.setTitle("Hierarchical Likelihood Ratio Tests (hLRT) Settings");
        this.PanelSettings.add(this.TextFieldConfidenceLevelhLRT);
        this.PanelSettings.add(this.HypothesisList);
        this.PanelSettings.add(this.ButtonListUp);
        this.PanelSettings.add(this.ButtonListDown);
        this.PanelSettings.add(this.PanelForwardBackward);
        this.PanelSettings.add(this.jCheckBoxDynamical);
        this.PanelSettings.add(this.jCheckBoxPAUPblock);
        this.PanelSettings.add(this.CancelButtonhLRT);
        this.PanelSettings.add(this.RunButtonhLRT);
        this.PanelSettings.add(this.JButtonDefaulthLRT);
        this.PanelForwardBackward.add(this.ButtonForward);
        this.PanelForwardBackward.add(this.ButtonBackward);
        this.getContentPane().add(this.PanelSettings);
        this.setSize(new Dimension(482, 420));
        this.setResizable(false);
        this.HypothesisList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                Frame_hLRT.this.HypothesisListValueChanged(listSelectionEvent);
            }
        });
        this.ButtonListUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Frame_hLRT.this.ButtonListUpActionPerformed(actionEvent);
            }
        });
        this.ButtonListDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Frame_hLRT.this.ButtonListDownActionPerformed(actionEvent);
            }
        });
        this.ButtonForward.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Frame_hLRT.this.ButtonForwardActionPerformed(changeEvent);
            }
        });
        this.jCheckBoxDynamical.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Frame_hLRT.this.jCheckBoxDynamicalActionPerformed(actionEvent);
            }
        });
        this.CancelButtonhLRT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Frame_hLRT.this.CancelButtonhLRTActionPerformed(actionEvent);
            }
        });
        this.RunButtonhLRT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Frame_hLRT.this.RunButtonhLRTActionPerformed(actionEvent);
            }
        });
        this.JButtonDefaulthLRT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Frame_hLRT.this.JButtonDefaulthLRTActionPerformed(actionEvent);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                Frame_hLRT.this.thisWindowClosing(windowEvent);
            }
        });
        if (this.options.doF) {
            this.listModel.addElement("freq");
        }
        this.listModel.addElement("titv");
        if (this.options.getSubstTypeCode() == 0) {
            this.listModel.addElement("2ti4tv");
        } else if (this.options.getSubstTypeCode() == 1) {
            this.listModel.addElement("2ti");
            this.listModel.addElement("2tv");
        } else {
            this.listModel.addElement("2ti");
            this.listModel.addElement("2tv");
            this.listModel.addElement("4tv");
        }
        if (this.options.doG) {
            this.listModel.addElement("gamma");
        }
        if (this.options.doI) {
            this.listModel.addElement("pinv");
        }
        this.HypothesisList.setModel(this.listModel);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.mShown) {
            return;
        }
        JMenuBar jMenuBar = this.getJMenuBar();
        if (jMenuBar != null) {
            int n = jMenuBar.getPreferredSize().height;
            Dimension dimension = this.getSize();
            dimension.height += n;
            this.setSize(dimension);
            Component[] componentArray = this.getLayeredPane().getComponentsInLayer(JLayeredPane.DEFAULT_LAYER);
            for (int i = 0; i < componentArray.length; ++i) {
                Point point = componentArray[i].getLocation();
                point.move(point.x, point.y + n);
                componentArray[i].setLocation(point);
            }
        }
        this.mShown = true;
    }

    void thisWindowClosing(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    public void ButtonListUpActionPerformed(ActionEvent actionEvent) {
        int n = this.HypothesisList.getSelectedIndex();
        if (n != 0) {
            this.swap(n, n - 1);
            this.HypothesisList.setSelectedIndex(n - 1);
            this.HypothesisList.ensureIndexIsVisible(n - 1);
        }
    }

    public void ButtonListDownActionPerformed(ActionEvent actionEvent) {
        int n = this.HypothesisList.getSelectedIndex();
        if (n != this.listModel.getSize() - 1) {
            this.swap(n, n + 1);
            this.HypothesisList.setSelectedIndex(n + 1);
            this.HypothesisList.ensureIndexIsVisible(n + 1);
        }
    }

    public void HypothesisListValueChanged(ListSelectionEvent listSelectionEvent) {
    }

    private void swap(int n, int n2) {
        if (n >= 0 && n2 >= 0 && n < this.listModel.getSize() && n2 < this.listModel.getSize()) {
            String string = this.listModel.getElementAt(n);
            String string2 = this.listModel.getElementAt(n2);
            this.listModel.set(n, string2);
            this.listModel.set(n2, string);
        }
    }

    public void ButtonForwardActionPerformed(ChangeEvent changeEvent) {
        this.listModel.removeAllElements();
        if (this.options.doF) {
            this.listModel.addElement("freq");
        }
        if (this.ButtonForward.isSelected()) {
            this.listModel.addElement("titv");
            if (this.options.getSubstTypeCode() == 0) {
                this.listModel.addElement("2ti4tv");
            } else if (this.options.getSubstTypeCode() == 1) {
                this.listModel.addElement("2ti");
                this.listModel.addElement("2tv");
            } else if (this.options.getSubstTypeCode() > 1) {
                this.listModel.addElement("2ti");
                this.listModel.addElement("2tv");
                this.listModel.addElement("4tv");
            }
        } else {
            if (this.options.getSubstTypeCode() == 0) {
                this.listModel.addElement("2ti4tv");
            } else if (this.options.getSubstTypeCode() == 1) {
                this.listModel.addElement("2tv");
                this.listModel.addElement("2ti");
            } else if (this.options.getSubstTypeCode() > 1) {
                this.listModel.addElement("4tv");
                this.listModel.addElement("2tv");
                this.listModel.addElement("2ti");
            }
            this.listModel.addElement("titv");
        }
        if (this.options.doG) {
            this.listModel.addElement("gamma");
        }
        if (this.options.doI) {
            this.listModel.addElement("pinv");
        }
        this.HypothesisList.setModel(this.listModel);
    }

    public void jCheckBoxDynamicalActionPerformed(ActionEvent actionEvent) {
        try {
            if (this.jCheckBoxDynamical.isSelected()) {
                this.ButtonListUp.setEnabled(false);
                this.ButtonListDown.setEnabled(false);
                this.HypothesisList.setEnabled(false);
            } else {
                this.ButtonListUp.setEnabled(true);
                this.ButtonListDown.setEnabled(true);
                this.HypothesisList.setEnabled(true);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void JButtonDefaulthLRTActionPerformed(ActionEvent actionEvent) {
        this.TextFieldConfidenceLevelhLRT.setText("0.01");
        this.listModel.removeAllElements();
        if (this.options.doF) {
            this.listModel.addElement("freq");
        }
        this.listModel.addElement("titv");
        if (this.options.getSubstTypeCode() == 0) {
            this.listModel.addElement("2ti4tv");
        } else if (this.options.getSubstTypeCode() == 1) {
            this.listModel.addElement("2ti");
            this.listModel.addElement("2tv");
        } else {
            this.listModel.addElement("2ti");
            this.listModel.addElement("2tv");
            this.listModel.addElement("4tv");
        }
        if (this.options.doG) {
            this.listModel.addElement("gamma");
        }
        if (this.options.doI) {
            this.listModel.addElement("pinv");
        }
        this.HypothesisList.setModel(this.listModel);
        this.ButtonForward.setSelected(true);
        this.jCheckBoxPAUPblock.setSelected(false);
        this.jCheckBoxDynamical.setSelected(false);
    }

    public void CancelButtonhLRTActionPerformed(ActionEvent actionEvent) {
        try {
            this.setVisible(false);
            this.dispose();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void RunButtonhLRTActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
        this.dispose();
        double d = Double.parseDouble(this.TextFieldConfidenceLevelhLRT.getText());
        boolean bl = this.jCheckBoxPAUPblock.isSelected();
        boolean bl2 = this.ButtonForward.isSelected();
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            ModelTest.testingOrder.setElementAt(this.listModel.getElementAt(i), i);
        }
        if (bl2 && ModelTest.testingOrder.indexOf("2tv") > ModelTest.testingOrder.indexOf("4tv")) {
            JOptionPane.showMessageDialog(this, "for forward hLRTs the hypothesis 2tv needs\nto be tested before the hypothesis 4tv", "jModelTest error", 0);
            ModelTest.getMainConsole().println("\nError: for forward hLRTs the hypothesis 2tv needs\nto be tested before the hypothesis 4tv");
        } else if (!bl2 && ModelTest.testingOrder.indexOf("2tv") < ModelTest.testingOrder.indexOf("4tv")) {
            JOptionPane.showMessageDialog(this, "for backward hLRTs the hypothesis 2tv needs\nto be tested after the hypothesis 4tv", "jModelTest error", 0);
            ModelTest.getMainConsole().println("\nError: for backward hLRTs the hypothesis 2tv needs\nto be tested after the hypothesis 4tv");
        }
        HLRT hLRT = new HLRT(this.options);
        if (this.jCheckBoxDynamical.isSelected()) {
            hLRT.computeDynamical(bl2, d, bl);
        } else {
            hLRT.compute(bl2, d, bl);
        }
    }
}

