/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.jmodeltest.gui;

import es.uvigo.darwin.jmodeltest.ModelTest;
import es.uvigo.darwin.jmodeltest.gui.FrameMain;
import es.uvigo.darwin.jmodeltest.gui.FramePreferences;
import es.uvigo.darwin.jmodeltest.gui.FrameResults;
import es.uvigo.darwin.jmodeltest.io.DocumentOutputStream;
import es.uvigo.darwin.jmodeltest.io.TextOutputStream;
import es.uvigo.darwin.jmodeltest.utilities.Utilities;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.io.PrintStream;
import java.net.URL;
import java.util.Calendar;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class XManager {
    private static XManager instance;
    public static final Font FONT_CONSOLE;
    public static final Font FONT_LABEL;
    public static final Font FONT_MENU;
    public static final Font FONT_STATUS;
    public static final Font FONT_SLIDER;
    public static final Font FONT_LABEL_BIG;
    public static final Font FONT_TABULAR;
    public static final Color LABEL_BLUE_COLOR;
    public static final Color LABEL_FAIL_COLOR;
    public static final Color LABEL_GREEN_COLOR;
    public static final Color PANEL_BORDER_COLOR;
    public static final Color MENU_COLOR;
    public static final Color MENU_FG_COLOR;
    public static final Color PANE_BACK_COLOR;
    public static final Color INNER_BORDER_COLOR;
    public static final Color OUTER_BORDER_COLOR;
    public static final Color DARK_GRAY_COLOR;
    public static final Color STATUS_BACK_COLOR;
    public static final Point MAIN_LOCATION;
    public static SimpleAttributeSet blueText;
    public static SimpleAttributeSet redText;
    public static SimpleAttributeSet blackText;
    public FrameMain frame;
    public FrameResults resultsFrame;
    private FramePreferences preferencesFrame;
    public static boolean resultsFrameBuilt;
    private JTextPane PANE;

    private XManager() {
        try {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.frame = new FrameMain();
            this.frame.initComponents();
            this.frame.setVisible(true);
            this.PANE = this.frame.getMainEditorPane();
            ModelTest.setMainConsole(new TextOutputStream(new PrintStream(new DocumentOutputStream(this.PANE.getDocument()))));
            ModelTest.setCurrentOutStream(ModelTest.getMainConsole());
            ModelTest.printHeader(ModelTest.getMainConsole());
            ModelTest.printNotice(ModelTest.getMainConsole());
            ModelTest.printCitation(ModelTest.getMainConsole());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void CheckExpiration(JFrame jFrame) {
        Calendar calendar = Calendar.getInstance();
        if (calendar.get(2) != 5 && calendar.get(2) != 11 || calendar.get(1) != 2007) {
            JOptionPane.showMessageDialog(jFrame, "Program has expired! \n    Bye...", "jModelTest warning", 2);
            jFrame.dispose();
            System.exit(0);
        }
    }

    public void setPane(JTextPane jTextPane) {
        this.PANE = jTextPane;
    }

    public JTextPane getPane() {
        return this.PANE;
    }

    public void buildFrameResults() {
        try {
            if (resultsFrameBuilt) {
                this.resultsFrame.dispose();
            }
            this.resultsFrame = new FrameResults();
            this.resultsFrame.initComponents();
            this.resultsFrame.setVisible(false);
            resultsFrameBuilt = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static XManager getInstance() {
        if (instance == null) {
            instance = new XManager();
        }
        return instance;
    }

    public void loadFramePreferences() {
        if (this.preferencesFrame == null) {
            this.preferencesFrame = new FramePreferences();
        }
        this.preferencesFrame.setVisible(true);
    }

    public void setLikeLabelText(String string) {
        this.frame.setLikeLabelText(string);
    }

    public void setDataLabelText(String string) {
        this.frame.setDataLabelText(string);
    }

    public void setLikeLabelColor(Color color) {
        this.frame.setLikeLabelColor(color);
    }

    public void enableMenuAIC(boolean bl) {
        this.frame.enableMenuAIC(bl);
    }

    public void enableMenuBIC(boolean bl) {
        this.frame.enableMenuBIC(bl);
    }

    public void enableMenuDT(boolean bl) {
        this.frame.enableMenuDT(bl);
    }

    public void enableMenuhLRT(boolean bl) {
        this.frame.enableMenuhLRT(bl);
    }

    public void enableMenuAveraging(boolean bl) {
        this.frame.enableMenuAveraging(bl);
    }

    public void enableMenuShowModelTable(boolean bl) {
        this.frame.enableMenuShowModelTable(bl);
    }

    public void enableMenuHtmlOutput(boolean bl) {
        this.frame.enableMenuHtmlOutput(bl);
    }

    public void selectedMenuResultsBLasParameters(boolean bl) {
        this.frame.selectedMenuResultsBLasParameters(bl);
    }

    public static ImageIcon makeIcon(String string, String string2) {
        String string3 = "icons/" + string + ".gif";
        URL uRL = XManager.class.getResource(string3);
        ImageIcon imageIcon = null;
        if (uRL != null) {
            imageIcon = new ImageIcon(uRL, string2);
        }
        return imageIcon;
    }

    public static JButton makeIconButton(String string, String string2, String string3) {
        ImageIcon imageIcon = XManager.makeIcon(string, string3);
        JButton jButton = new JButton();
        jButton.setToolTipText(string2);
        jButton.setLayout(null);
        jButton.setOpaque(false);
        jButton.setSize(20, 20);
        jButton.setVisible(true);
        if (imageIcon != null) {
            jButton.setIcon(imageIcon);
        } else {
            jButton.setText(string3);
        }
        return jButton;
    }

    static {
        LABEL_BLUE_COLOR = new Color(102, 102, 153);
        LABEL_FAIL_COLOR = new Color(153, 0, 0);
        LABEL_GREEN_COLOR = new Color(0, 153, 0);
        PANEL_BORDER_COLOR = new Color(153, 153, 153);
        MENU_COLOR = new Color(130, 130, 150);
        MENU_FG_COLOR = new Color(0, 0, 0);
        PANE_BACK_COLOR = Color.WHITE;
        INNER_BORDER_COLOR = new Color(182, 182, 182);
        OUTER_BORDER_COLOR = new Color(89, 89, 89);
        DARK_GRAY_COLOR = new Color(89, 89, 89);
        STATUS_BACK_COLOR = new Color(220, 220, 220);
        MAIN_LOCATION = new Point(281, 80);
        resultsFrameBuilt = false;
        FONT_CONSOLE = !Utilities.isWindows() ? new Font("Monospaced", 0, 12) : new Font("Lucida Console", 0, 12);
        FONT_LABEL = new Font("Application", 1, 10);
        FONT_LABEL_BIG = new Font("Application", 0, 12);
        FONT_SLIDER = new Font("Application", 1, 9);
        FONT_MENU = new Font("Dialog", 0, 9);
        FONT_STATUS = new Font("Dialog", 0, 9);
        FONT_TABULAR = new Font("Verdana", 0, 12);
        blackText = new SimpleAttributeSet();
        redText = new SimpleAttributeSet();
        blueText = new SimpleAttributeSet();
        StyleConstants.setForeground(blueText, Color.blue);
        StyleConstants.setForeground(redText, Color.red);
        StyleConstants.setForeground(blackText, Color.black);
    }
}

