/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.jmodeltest.io;

import es.uvigo.darwin.jmodeltest.ApplicationOptions;
import es.uvigo.darwin.jmodeltest.io.TextInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.PushbackReader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import pal.alignment.Alignment;
import pal.alignment.AlignmentParseException;
import pal.alignment.ReadAlignment;

public abstract class AlignmentReader {
    private static ApplicationOptions options = ApplicationOptions.getInstance();

    public static void getHeader(String string) {
        try {
            TextInputStream textInputStream = new TextInputStream(string);
            String string2 = textInputStream.readLine();
            textInputStream.close();
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            options.setNumTaxa(Integer.parseInt(stringTokenizer.nextToken()));
            options.setNumSites(Integer.parseInt(stringTokenizer.nextToken()));
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(new JFrame(), "Could not read the input alignment", "jModelTest error", 0);
        }
        if (options.getNumTaxa() <= 4) {
            JOptionPane.showMessageDialog(new JFrame(), "The number of taxa does not seem to be correct: " + options.getNumTaxa(), "jModelTest error", 0);
        }
        if (options.getNumSites() <= 1) {
            JOptionPane.showMessageDialog(new JFrame(), "The number of sites does not seem to be correct: " + options.getNumTaxa(), "jModelTest error", 0);
        }
    }

    public static Alignment createAlignment(PrintWriter printWriter, PushbackReader pushbackReader, boolean bl) throws es.uvigo.darwin.jmodeltest.exception.AlignmentParseException, IOException {
        int n;
        if (bl) {
            printWriter.println("");
            printWriter.println("**********************************************************");
            printWriter.println("  Reading alignment...");
        }
        ReadAlignment readAlignment = null;
        try {
            readAlignment = new ReadAlignment(pushbackReader);
        }
        catch (AlignmentParseException alignmentParseException) {
            throw new es.uvigo.darwin.jmodeltest.exception.AlignmentParseException(alignmentParseException.getMessage());
        }
        ArrayList<String> arrayList = new ArrayList<String>(readAlignment.getSequenceCount());
        for (n = 0; n < readAlignment.getSequenceCount(); ++n) {
            arrayList.add(readAlignment.getIdentifier(n).getName());
        }
        if (bl) {
            for (n = 0; n < readAlignment.getSequenceCount(); ++n) {
                printWriter.println("    Sequence #" + (n + 1) + ": " + readAlignment.getIdentifier(n).getName());
            }
            printWriter.println("   Alignment contains " + readAlignment.getSequenceCount() + " sequences of length " + readAlignment.getSiteCount());
            printWriter.println("");
            printWriter.println("**********************************************************");
            printWriter.println("");
        }
        return readAlignment;
    }
}

