/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.jmodeltest.io;

import es.uvigo.darwin.jmodeltest.ApplicationOptions;
import es.uvigo.darwin.jmodeltest.ModelTest;
import es.uvigo.darwin.jmodeltest.ModelTestConfiguration;
import es.uvigo.darwin.jmodeltest.exe.RunPhyml;
import es.uvigo.darwin.jmodeltest.io.RFHistogram;
import es.uvigo.darwin.jmodeltest.io.TextOutputStream;
import es.uvigo.darwin.jmodeltest.model.Model;
import es.uvigo.darwin.jmodeltest.selection.InformationCriterion;
import es.uvigo.darwin.jmodeltest.tree.TreeSummary;
import es.uvigo.darwin.jmodeltest.tree.TreeUtilities;
import es.uvigo.darwin.jmodeltest.utilities.Utilities;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.awt.GraphicsEnvironment;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import pal.tree.Tree;

public abstract class HtmlReporter {
    private static String[] TEMPLATE_DIRS = new String[]{"resources"};
    private static String[] TEMPLATE_FILES = new String[]{"resources" + File.separator + "style.css", "resources" + File.separator + "homeIcon.gif", "resources" + File.separator + "topIcon.gif", "resources" + File.separator + "logo0.png"};
    private static Map<String, Object> datamodel;
    private static File LOG_DIR;
    private static File IMAGES_DIR;
    private static String RESOURCES_DIR;

    public static void buildReport(ApplicationOptions applicationOptions, Model[] modelArray, File file) {
        HtmlReporter.buildReport(applicationOptions, modelArray, file, null);
    }

    public static void buildReport(ApplicationOptions applicationOptions, Model[] modelArray, File file, TreeSummary treeSummary) {
        String string;
        TextOutputStream textOutputStream;
        Object object;
        StringBuffer stringBuffer;
        HashMap<String, String> hashMap;
        ArrayList<Map<String, String>> arrayList;
        File file2 = file != null ? (!file.getName().endsWith(".htm") && !file.getName().endsWith(".html") ? new File(file.getAbsolutePath() + ".html") : file) : new File(LOG_DIR.getPath() + File.separator + applicationOptions.getInputFile().getName() + ".jmodeltest." + applicationOptions.getExecutionName() + ".html");
        datamodel = new HashMap<String, Object>();
        Date date = new Date();
        datamodel.put("date", date.toString());
        datamodel.put("system", System.getProperty("os.name") + " " + System.getProperty("os.version") + ", arch: " + System.getProperty("os.arch") + ", bits: " + System.getProperty("sun.arch.data.model") + ", numcores: " + Runtime.getRuntime().availableProcessors());
        HtmlReporter.fillInWithOptions(applicationOptions);
        HtmlReporter.fillInWithSortedModels(modelArray);
        datamodel.put("isTopologiesSummary", treeSummary != null ? new Integer(1) : new Integer(0));
        if (treeSummary != null) {
            HtmlReporter.fillInWithTopologies(treeSummary, applicationOptions);
        }
        if (applicationOptions.doAIC) {
            arrayList = new ArrayList<Map<String, String>>();
            hashMap = new HashMap<String, String>();
            HtmlReporter.fillInWIthInformationCriterion(ModelTest.getMyAIC(), arrayList, hashMap);
            datamodel.put("aicModels", arrayList);
            datamodel.put("bestAicModel", hashMap);
            datamodel.put("aicConfidenceCount", ModelTest.getMyAIC().getConfidenceModels().size());
            stringBuffer = new StringBuffer();
            for (Model object22 : ModelTest.getMyAIC().getConfidenceModels()) {
                stringBuffer.append(object22.getName() + " ");
            }
            datamodel.put("aicConfidenceList", stringBuffer.toString());
            if (applicationOptions.writePAUPblock) {
                object = new ByteArrayOutputStream();
                PrintStream printStream = new PrintStream((OutputStream)object);
                textOutputStream = new TextOutputStream(printStream);
                ModelTest.WritePaupBlock(textOutputStream, "AIC", ModelTest.getMyAIC().getMinModel());
                try {
                    string = ((ByteArrayOutputStream)object).toString("UTF8");
                    string = string.replaceAll("\n", "<br/>");
                    datamodel.put("aicPaup", string);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            HtmlReporter.buildChart(file2, ModelTest.getMyAIC());
            datamodel.put("aicEuImagePath", IMAGES_DIR.getName() + File.separator + file2.getName() + "_eu_AIC.png");
            datamodel.put("aicRfImagePath", IMAGES_DIR.getName() + File.separator + file2.getName() + "_rf_AIC.png");
        }
        if (applicationOptions.doAICc) {
            arrayList = new ArrayList();
            hashMap = new HashMap();
            HtmlReporter.fillInWIthInformationCriterion(ModelTest.getMyAICc(), arrayList, hashMap);
            datamodel.put("aiccModels", arrayList);
            datamodel.put("bestAiccModel", hashMap);
            datamodel.put("aiccConfidenceCount", ModelTest.getMyAICc().getConfidenceModels().size());
            stringBuffer = new StringBuffer();
            for (Model model : ModelTest.getMyAICc().getConfidenceModels()) {
                stringBuffer.append(model.getName() + " ");
            }
            datamodel.put("aiccConfidenceList", stringBuffer.toString());
            if (applicationOptions.writePAUPblock) {
                object = new ByteArrayOutputStream();
                PrintStream printStream = new PrintStream((OutputStream)object);
                textOutputStream = new TextOutputStream(printStream);
                ModelTest.WritePaupBlock(textOutputStream, "AICc", ModelTest.getMyAICc().getMinModel());
                try {
                    string = ((ByteArrayOutputStream)object).toString("UTF8");
                    string = string.replaceAll("\n", "<br/>");
                    datamodel.put("aiccPaup", string);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            HtmlReporter.buildChart(file2, ModelTest.getMyAICc());
            datamodel.put("aiccEuImagePath", IMAGES_DIR.getName() + File.separator + file2.getName() + "_eu_AICc.png");
            datamodel.put("aiccRfImagePath", IMAGES_DIR.getName() + File.separator + file2.getName() + "_rf_AICc.png");
        }
        if (applicationOptions.doBIC) {
            arrayList = new ArrayList();
            hashMap = new HashMap();
            HtmlReporter.fillInWIthInformationCriterion(ModelTest.getMyBIC(), arrayList, hashMap);
            datamodel.put("bicModels", arrayList);
            datamodel.put("bestBicModel", hashMap);
            datamodel.put("bicConfidenceCount", ModelTest.getMyBIC().getConfidenceModels().size());
            stringBuffer = new StringBuffer();
            for (Model model : ModelTest.getMyBIC().getConfidenceModels()) {
                stringBuffer.append(model.getName() + " ");
            }
            datamodel.put("bicConfidenceList", stringBuffer.toString());
            if (applicationOptions.writePAUPblock) {
                object = new ByteArrayOutputStream();
                PrintStream printStream = new PrintStream((OutputStream)object);
                textOutputStream = new TextOutputStream(printStream);
                ModelTest.WritePaupBlock(textOutputStream, "BIC", ModelTest.getMyBIC().getMinModel());
                try {
                    string = ((ByteArrayOutputStream)object).toString("UTF8");
                    string = string.replaceAll("\n", "<br/>");
                    datamodel.put("bicPaup", string);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            HtmlReporter.buildChart(file2, ModelTest.getMyBIC());
            datamodel.put("bicEuImagePath", IMAGES_DIR.getName() + File.separator + file2.getName() + "_eu_BIC.png");
            datamodel.put("bicRfImagePath", IMAGES_DIR.getName() + File.separator + file2.getName() + "_rf_BIC.png");
        }
        if (applicationOptions.doDT) {
            arrayList = new ArrayList();
            hashMap = new HashMap();
            HtmlReporter.fillInWIthInformationCriterion(ModelTest.getMyDT(), arrayList, hashMap);
            datamodel.put("dtModels", arrayList);
            datamodel.put("bestDtModel", hashMap);
            datamodel.put("dtConfidenceCount", ModelTest.getMyDT().getConfidenceModels().size());
            stringBuffer = new StringBuffer();
            for (Model model : ModelTest.getMyDT().getConfidenceModels()) {
                stringBuffer.append(model.getName() + " ");
            }
            datamodel.put("dtConfidenceList", stringBuffer.toString());
            if (applicationOptions.writePAUPblock) {
                object = new ByteArrayOutputStream();
                PrintStream printStream = new PrintStream((OutputStream)object);
                textOutputStream = new TextOutputStream(printStream);
                ModelTest.WritePaupBlock(textOutputStream, "DT", ModelTest.getMyDT().getMinModel());
                try {
                    string = ((ByteArrayOutputStream)object).toString("UTF8");
                    string = string.replaceAll("\n", "<br/>");
                    datamodel.put("dtPaup", string);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            HtmlReporter.buildChart(file2, ModelTest.getMyDT());
            datamodel.put("dtEuImagePath", IMAGES_DIR.getName() + File.separator + file2.getName() + "_eu_DT.png");
            datamodel.put("dtRfImagePath", IMAGES_DIR.getName() + File.separator + file2.getName() + "_rf_DT.png");
        }
        datamodel.put("doAICAveragedPhylogeny", ModelTest.getConsensusAIC() != null ? new Integer(1) : new Integer(0));
        if (ModelTest.getConsensusAIC() != null) {
            datamodel.put("aicConsensusTree", TreeUtilities.toNewick(ModelTest.getConsensusAIC().getConsensus(), true, true, true));
            datamodel.put("consensusType", ModelTest.getConsensusAIC().getConsensusType());
        }
        datamodel.put("doAICcAveragedPhylogeny", ModelTest.getConsensusAICc() != null ? new Integer(1) : new Integer(0));
        if (ModelTest.getConsensusAICc() != null) {
            datamodel.put("aiccConsensusTree", TreeUtilities.toNewick(ModelTest.getConsensusAICc().getConsensus(), true, true, true));
            datamodel.put("consensusType", ModelTest.getConsensusAICc().getConsensusType());
        }
        datamodel.put("doBICAveragedPhylogeny", ModelTest.getConsensusBIC() != null ? new Integer(1) : new Integer(0));
        if (ModelTest.getConsensusBIC() != null) {
            datamodel.put("bicConsensusTree", TreeUtilities.toNewick(ModelTest.getConsensusBIC().getConsensus(), true, true, true));
            datamodel.put("consensusType", ModelTest.getConsensusBIC().getConsensusType());
        }
        datamodel.put("doDTAveragedPhylogeny", ModelTest.getConsensusDT() != null ? new Integer(1) : new Integer(0));
        if (ModelTest.getConsensusDT() != null) {
            datamodel.put("dtConsensusTree", TreeUtilities.toNewick(ModelTest.getConsensusDT().getConsensus(), true, true, true));
            datamodel.put("consensusType", ModelTest.getConsensusDT().getConsensusType());
        }
        try {
            HtmlReporter.freemarkerDo(datamodel, "index.html", file2);
        }
        catch (Exception exception) {
            System.out.println("There was a problem building the html log files: " + exception.getLocalizedMessage());
        }
    }

    static void freemarkerDo(Map<String, Object> map, String string, File file) throws Exception {
        File file2;
        if (!LOG_DIR.exists() || !LOG_DIR.isDirectory()) {
            LOG_DIR.delete();
            LOG_DIR.mkdir();
        }
        if (!IMAGES_DIR.exists() || !IMAGES_DIR.isDirectory()) {
            IMAGES_DIR.delete();
            IMAGES_DIR.mkdir();
        }
        for (String string2 : TEMPLATE_DIRS) {
            file2 = new File(LOG_DIR.getPath() + File.separator + string2);
            if (file2.exists()) continue;
            file2.mkdirs();
        }
        for (String string2 : TEMPLATE_FILES) {
            File file3;
            file2 = new File(LOG_DIR.getPath() + File.separator + string2);
            if (file2.exists() || !(file3 = new File(RESOURCES_DIR + File.separator + string2)).exists()) continue;
            HtmlReporter.copyFile(file3, file2);
        }
        Configuration configuration = new Configuration();
        configuration.setDirectoryForTemplateLoading(new File(RESOURCES_DIR));
        Template template = configuration.getTemplate(string);
        FileWriter fileWriter = new FileWriter(file);
        template.process(map, (Writer)fileWriter);
    }

    private static void fillInWithOptions(ApplicationOptions applicationOptions) {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : ModelTest.arguments) {
            stringBuffer.append(string + " ");
        }
        datamodel.put("arguments", stringBuffer);
        datamodel.put("alignName", applicationOptions.getInputFile());
        datamodel.put("numTaxa", applicationOptions.getNumTaxa());
        datamodel.put("seqLength", applicationOptions.getNumSites());
        datamodel.put("phymlVersion", RunPhyml.PHYML_VERSION);
        datamodel.put("phymlBinary", Utilities.getBinaryVersion());
        datamodel.put("candidateModels", ModelTest.getCandidateModels().length);
        if (applicationOptions.getSubstTypeCode() == 0) {
            datamodel.put("substSchemes", "3");
        } else if (applicationOptions.getSubstTypeCode() == 1) {
            datamodel.put("substSchemes", "5");
        } else if (applicationOptions.getSubstTypeCode() == 2) {
            datamodel.put("substSchemes", "7");
        } else {
            datamodel.put("substSchemes", "11");
        }
        datamodel.put("includeF", applicationOptions.doF ? new Integer(1) : new Integer(0));
        datamodel.put("includeG", applicationOptions.doG ? new Integer(1) : new Integer(0));
        datamodel.put("includeI", applicationOptions.doI ? new Integer(1) : new Integer(0));
        datamodel.put("isAIC", applicationOptions.doAIC ? new Integer(1) : new Integer(0));
        datamodel.put("isAICc", applicationOptions.doAICc ? new Integer(1) : new Integer(0));
        datamodel.put("isBIC", applicationOptions.doBIC ? new Integer(1) : new Integer(0));
        datamodel.put("isDT", applicationOptions.doDT ? new Integer(1) : new Integer(0));
        datamodel.put("numCat", applicationOptions.numGammaCat);
        datamodel.put("isPAUP", applicationOptions.writePAUPblock ? new Integer(1) : new Integer(0));
        StringBuffer stringBuffer2 = new StringBuffer("Substitution parameters ");
        if (applicationOptions.countBLasParameters) {
            stringBuffer2.append("+ " + applicationOptions.getNumBranches() + " branch lengths ");
        }
        if (applicationOptions.optimizeMLTopology) {
            stringBuffer2.append("+ topology");
        }
        datamodel.put("freeParameters", stringBuffer2.toString());
        datamodel.put("userTreeDef", applicationOptions.userTopologyExists ? new Integer(1) : new Integer(0));
        if (applicationOptions.fixedTopology) {
            datamodel.put("baseTree", "Fixed BioNJ");
        } else if (applicationOptions.optimizeMLTopology) {
            datamodel.put("baseTree", "Maximum Likelihood");
        } else if (applicationOptions.userTopologyExists) {
            datamodel.put("baseTree", "Fixed user tree topology");
            datamodel.put("userTreeFilename", applicationOptions.getInputTreeFile().getName());
            datamodel.put("userTree", applicationOptions.getUserTree());
        } else {
            datamodel.put("baseTree", "BioNJ");
        }
        switch (applicationOptions.treeSearchOperations) {
            case NNI: {
                datamodel.put("searchAlgorithm", "NNI");
                break;
            }
            case SPR: {
                datamodel.put("searchAlgorithm", "SPR");
                break;
            }
            case BEST: {
                datamodel.put("searchAlgorithm", "Best of {NNI, SPR}");
            }
        }
        datamodel.put("confidenceInterval", String.format(Locale.ENGLISH, "%5.2f", applicationOptions.confidenceInterval * 100.0));
    }

    private static void fillInWithSortedModels(Model[] modelArray) {
        ArrayList arrayList = new ArrayList();
        int n = 1;
        for (Model model : modelArray) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("index", String.valueOf(n++));
            hashMap.put("name", model.getName());
            hashMap.put("partition", model.getPartition());
            hashMap.put("lnl", String.format(Locale.ENGLISH, "%5.4f", model.getLnL()));
            hashMap.put("k", String.valueOf(model.getK()));
            hashMap.put("fA", model.ispF() ? String.format(Locale.ENGLISH, "%5.4f", model.getfA()) : "-");
            hashMap.put("fC", model.ispF() ? String.format(Locale.ENGLISH, "%5.4f", model.getfC()) : "-");
            hashMap.put("fG", model.ispF() ? String.format(Locale.ENGLISH, "%5.4f", model.getfG()) : "-");
            hashMap.put("fT", model.ispF() ? String.format(Locale.ENGLISH, "%5.4f", model.getfT()) : "-");
            hashMap.put("titv", model.ispT() ? String.format(Locale.ENGLISH, "%5.4f", model.getTitv()) : "-");
            hashMap.put("rA", model.ispR() ? String.format(Locale.ENGLISH, "%5.4f", model.getRa()) : "-");
            hashMap.put("rB", model.ispR() ? String.format(Locale.ENGLISH, "%5.4f", model.getRb()) : "-");
            hashMap.put("rC", model.ispR() ? String.format(Locale.ENGLISH, "%5.4f", model.getRc()) : "-");
            hashMap.put("rD", model.ispR() ? String.format(Locale.ENGLISH, "%5.4f", model.getRd()) : "-");
            hashMap.put("rE", model.ispR() ? String.format(Locale.ENGLISH, "%5.4f", model.getRe()) : "-");
            hashMap.put("rF", model.ispR() ? String.format(Locale.ENGLISH, "%5.4f", model.getRf()) : "-");
            hashMap.put("pInv", model.ispI() ? String.format(Locale.ENGLISH, "%5.4f", model.getPinv()) : "-");
            hashMap.put("shape", model.ispG() ? String.format(Locale.ENGLISH, "%6.4f", model.getShape()) : "-");
            hashMap.put("tree", model.getTreeString());
            arrayList.add(hashMap);
        }
        datamodel.put("sortedModels", arrayList);
    }

    private static void fillInWithTopologies(TreeSummary treeSummary, ApplicationOptions applicationOptions) {
        datamodel.put("numberOfTopologies", treeSummary.getNumberOfTopologies());
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < treeSummary.getNumberOfTopologies(); ++i) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("index", String.valueOf(i));
            Tree tree = treeSummary.getTopology(i);
            hashMap.put("tree", TreeUtilities.toNewick(tree, false, false, false));
            List<Model> list = treeSummary.getModelsByTopology(i);
            StringBuilder stringBuilder = new StringBuilder();
            for (Model model : list) {
                stringBuilder.append(model.getName() + " ");
            }
            hashMap.put("models", stringBuilder.toString());
            hashMap.put("models", stringBuilder.toString());
            if (applicationOptions.doAIC) {
                hashMap.put("aicRank", String.valueOf(treeSummary.aicIndexOf(tree)));
                hashMap.put("aicRF", String.valueOf(treeSummary.aicRfOf(tree)));
                hashMap.put("aicAvgDistance", Utilities.format(treeSummary.aicAvgDistance(tree), 6, 4, true));
                hashMap.put("aicVarDistance", Utilities.format(treeSummary.aicVarDistance(tree), 6, 4, true));
                hashMap.put("aicWeight", Utilities.format(treeSummary.aicWeight(tree), 6, 4, false));
            }
            if (applicationOptions.doAICc) {
                hashMap.put("aiccRank", String.valueOf(treeSummary.aiccIndexOf(tree)));
                hashMap.put("aiccRF", String.valueOf(treeSummary.aiccRfOf(tree)));
                hashMap.put("aiccAvgDistance", Utilities.format(treeSummary.aiccAvgDistance(tree), 6, 4, true));
                hashMap.put("aiccVarDistance", Utilities.format(treeSummary.aiccVarDistance(tree), 6, 4, true));
                hashMap.put("aiccWeight", Utilities.format(treeSummary.aiccWeight(tree), 6, 4, false));
            }
            if (applicationOptions.doBIC) {
                hashMap.put("bicRank", String.valueOf(treeSummary.bicIndexOf(tree)));
                hashMap.put("bicRF", String.valueOf(treeSummary.bicRfOf(tree)));
                hashMap.put("bicAvgDistance", Utilities.format(treeSummary.bicAvgDistance(tree), 6, 4, true));
                hashMap.put("bicVarDistance", Utilities.format(treeSummary.bicVarDistance(tree), 6, 4, true));
                hashMap.put("bicWeight", Utilities.format(treeSummary.bicWeight(tree), 6, 4, false));
            }
            if (applicationOptions.doDT) {
                hashMap.put("dtRank", String.valueOf(treeSummary.dtIndexOf(tree)));
                hashMap.put("dtRF", String.valueOf(treeSummary.dtRfOf(tree)));
                hashMap.put("dtAvgDistance", Utilities.format(treeSummary.dtAvgDistance(tree), 6, 4, true));
                hashMap.put("dtVarDistance", Utilities.format(treeSummary.dtVarDistance(tree), 6, 4, true));
                hashMap.put("dtWeight", Utilities.format(treeSummary.dtWeight(tree), 6, 4, false));
            }
            arrayList.add(hashMap);
        }
        datamodel.put("sortedTopologies", arrayList);
    }

    private static void fillInWIthInformationCriterion(InformationCriterion informationCriterion, Collection<Map<String, String>> collection, Map<String, String> map) {
        Model model = informationCriterion.getModel(0);
        map.put("index", String.valueOf(1));
        map.put("name", model.getName());
        map.put("partition", model.getPartition());
        map.put("lnl", String.format(Locale.ENGLISH, "%5.4f", model.getLnL()));
        map.put("k", String.valueOf(model.getK()));
        map.put("fA", model.ispF() ? String.format(Locale.ENGLISH, "%5.4f", model.getfA()) : "-");
        map.put("fC", model.ispF() ? String.format(Locale.ENGLISH, "%5.4f", model.getfC()) : "-");
        map.put("fG", model.ispF() ? String.format(Locale.ENGLISH, "%5.4f", model.getfG()) : "-");
        map.put("fT", model.ispF() ? String.format(Locale.ENGLISH, "%5.4f", model.getfT()) : "-");
        map.put("titv", model.ispT() ? String.format(Locale.ENGLISH, "%5.4f", model.getTitv()) : "-");
        map.put("rA", model.ispR() ? String.format(Locale.ENGLISH, "%5.4f", model.getRa()) : "-");
        map.put("rB", model.ispR() ? String.format(Locale.ENGLISH, "%5.4f", model.getRb()) : "-");
        map.put("rC", model.ispR() ? String.format(Locale.ENGLISH, "%5.4f", model.getRc()) : "-");
        map.put("rD", model.ispR() ? String.format(Locale.ENGLISH, "%5.4f", model.getRd()) : "-");
        map.put("rE", model.ispR() ? String.format(Locale.ENGLISH, "%5.4f", model.getRe()) : "-");
        map.put("rF", model.ispR() ? String.format(Locale.ENGLISH, "%5.4f", model.getRf()) : "-");
        map.put("pInv", model.ispI() ? String.format(Locale.ENGLISH, "%5.4f", model.getPinv()) : "-");
        map.put("shape", model.ispG() ? String.format(Locale.ENGLISH, "%6.4f", model.getShape()) : "-");
        map.put("value", String.format(Locale.ENGLISH, "%5.4f", informationCriterion.getValue(model)));
        map.put("delta", String.format(Locale.ENGLISH, "%5.4f", informationCriterion.getDelta(model)));
        map.put("weight", String.format(Locale.ENGLISH, "%5.4f", informationCriterion.getWeight(model)));
        map.put("tree", model.getTreeString());
        map.put("cumWeight", String.format(Locale.ENGLISH, "%5.4f", informationCriterion.getCumWeight(model)));
        collection.add(map);
        for (int i = 1; i < informationCriterion.getNumModels(); ++i) {
            model = informationCriterion.getModel(i);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("index", String.valueOf(i + 1));
            hashMap.put("name", model.getName());
            hashMap.put("partition", model.getPartition());
            hashMap.put("lnl", String.format(Locale.ENGLISH, "%5.4f", model.getLnL()));
            hashMap.put("k", String.valueOf(model.getK()));
            hashMap.put("value", String.format(Locale.ENGLISH, "%5.4f", informationCriterion.getValue(model)));
            hashMap.put("delta", String.format(Locale.ENGLISH, "%5.4f", informationCriterion.getDelta(model)));
            hashMap.put("weight", String.format(Locale.ENGLISH, "%5.4f", informationCriterion.getWeight(model)));
            hashMap.put("cumWeight", String.format(Locale.ENGLISH, "%5.4f", informationCriterion.getCumWeight(model)));
            hashMap.put("tree", model.getTreeString());
            collection.add(hashMap);
        }
    }

    public static void copyFile(File file, File file2) throws IOException {
        FileChannel fileChannel = new FileInputStream(file).getChannel();
        FileChannel fileChannel2 = new FileOutputStream(file2).getChannel();
        try {
            fileChannel.transferTo(0L, fileChannel.size(), fileChannel2);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            if (fileChannel != null) {
                fileChannel.close();
            }
            if (fileChannel2 != null) {
                fileChannel2.close();
            }
        }
    }

    private static void buildChart(File file, InformationCriterion informationCriterion) {
        if (GraphicsEnvironment.isHeadless()) {
            return;
        }
        int n = 500;
        int n2 = 300;
        try {
            if (!IMAGES_DIR.exists()) {
                IMAGES_DIR.mkdir();
            }
            ChartUtilities.saveChartAsPNG((File)new File(IMAGES_DIR.getPath() + File.separator + file.getName() + "_rf_" + informationCriterion + ".png"), (JFreeChart)RFHistogram.buildRFHistogram(informationCriterion), (int)n, (int)n2);
            ChartUtilities.saveChartAsPNG((File)new File(IMAGES_DIR.getPath() + File.separator + file.getName() + "_eu_" + informationCriterion + ".png"), (JFreeChart)RFHistogram.buildEuclideanHistogram(informationCriterion), (int)n, (int)n2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        String string = ModelTestConfiguration.getLogDir();
        if (!string.startsWith(File.separator)) {
            string = ModelTestConfiguration.PATH + string;
        }
        LOG_DIR = new File(string);
        IMAGES_DIR = new File(string + File.separator + "images");
        RESOURCES_DIR = ModelTestConfiguration.PATH + "resources" + File.separator + "template";
    }
}

